/*
 *				m a t c h . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	match	Determine if a String Is a Leading Substring of Another
index		Determine if a string matches a leading substring of another
index		Pattern matching - match constant string

synopsis

	 char *
	 match(s,p)
	 char *s;
	 char *p;

description

	match(s,p) returns a pointer to the first character of s beyond those
	matching p, if p is an initial substring of s.  Otherwise, it returns
	NULL.  Thus,

		match("abcde","abc")

	returns a pointer to the 'd' in the first string;

		match("abcde","bc")

	returns NULL.

bugs

author

	Jerry Leichter

#endif

/*
 * )EDITLEVEL=05
 * Edit history
 * 0.0  4-May-81 JSL	Invention
 * 1.0  7-May-81 JSL	Now returns pointer to first character after the match
 *			instead of just TRUE.
 * 1.1 23-Jun-81 JSL	Conversion to the new documentation conventions.
 */

#define NULL 0

char *
match(s,p)
register char *s, *p;
{
	while (*s == *p && *s != '\0') {
		/*
		 * No need to check *p; it equals *s or
		 * the first test fails.
		 */
		p++;
		s++;
	}
	return((*p != '\0') ? NULL : s);
}
                                                                                                                                                                                                                                                                                                                                                                                  