/*
 *				c s d i f f . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	csdiff		Compute Difference of Two Csets
index			Compute difference of two csets

synopsis

	 #ifdef vms
	 #include "c:cset.h"
	 #else
	 #include <cset.h>
	 #endif

	 CSET *
	 csdiff(cs1,cs2);
	 CSET *cs1;
	 CSET *cs2;

description

	The cset returned by csdiff() has as members all elements of cs1 that
	are not members of cs2.  Whenever possible, csdiff() shares existing
	data by returning a cset that shares the memory used by cs1 and cs2.

	If csunique is true, a new cset is always formed.

	csdiff() returns NULL if it couldn't allocate a cset to return.

bugs

author

	Jerry Leichter

#endif

/*
)EDITLEVEL=02
 * Edit history
 * 0.0 16-Jul-82 JSL	Invention
 */

#ifdef vms
#include "c:cset.h"
#else
#include <cset.h>
#endif

CSET *
csdiff(cs1,cs2)
CSET *cs1;
CSET *cs2;
{	return(cscomp(csjoin(cscomp(cs1),cs2)));	}
					/* Use DeMorgan's law...	*/
                                  