/*
 *			s t r n c p . c
 */

/*)LIBRARY
*/

#ifdef	DOCUMENTATION

title	strncpy	String Copy With Count
index		String copy with count

synopsis
	.s.nf
	char *
	strncpy(out, in, count);
	char		*out;
	char		*in;
	unsigned int	count;
	.s.f
Description

	Copy "in" to "out".  Return out.
	At most, "count" bytes are moved from in.
	Note that "count" includes the trailing null.

	If strlen(in) is less than count, "out" is null-filled.

	If strlen(in) is greater than count, the output buffer
	will not be null-trailed.

Bugs

#endif

#define	EOS	0

char *
strncpy(out, in, count)
char			*out;
register char		*in;
register unsigned int	count;
/*
 * Copy in to out, with count.  Null fill if needed.
 */
{
	register char	*op;

	if (count != 0) {
	    for (op = out; (*op++ = *in++) != EOS;) {
		if (--count == 0)
		    goto done;		/* Branch if count bytes copied	*/
	    }
	    /*
	     * Null fill the output buffer
	     */
	    do {
		*op++ = EOS;
	    } while (--count != 0);
	}
done:	return (out);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           