-h- ESA.H	Sat Jan 02 18:07:06 1982	_DBB0:ESA.H;1
#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * esa.h
 * Header.
 *
 * Sizes of tables.
 * All may be freely changed, with the exception
 * of ERRMAX (If you really need to change him, look
 * at `outlisting').
 */
#define NCPS	8		/* Characters per symbol */
#define CODEMAX	100		/* Max bytes code per line */
#define USERMAX	300		/* User names */
#define SRCMAX	120		/* Source line length */
#define ERRMAX	10		/* Maximum errors per line */
#define CRSIZE	32		/* Bytes per object record */

#define dot	(&ust[0])	/* Location counter */

/*
 * 8008 magic.
 */
#define	LBI	016		/* Opcodes */
#define LCI	026
#define LDI	036
#define LEI	046
#define LHI	056
#define LLI	066

/*
 * Listing control modes.
 * Go in `listmode'.
 */
#define NLIST	0		/* No list */
#define SLIST	1		/* Source only list */
#define ALIST	2		/* Just address */
#define CLIST	3		/* Address and code */

/*
 * Symbol table structure.
 * Used in both the user symbol table and
 * the opcode table.
 */
struct sym {
	char s_name[NCPS];	/* Name */
	char s_type;		/* Type */
	char s_flag;		/* Some flags */
	int  s_value;		/* Value */
};

/*
 * Types.
 */
#define S_UND	0		/* Undefined */
#define S_ABS	1		/* Absolute */
#define S_IN	2		/* in */
#define S_OUT	3		/* out */
#define S_PAGE	4		/* .page */
#define S_BYTE	5		/* .byte */
#define S_WORD	6		/* .word */
#define S_ASCII	7		/* .ascii */
#define S_ASCIZ	8		/* .asciz */
#define S_BLKB	9		/* .blkb */
#define S_OP1	10		/* Opcode */
#define S_OP2	11		/* Opcode byte */
#define S_OP3	12		/* Opcode addr */
#define S_OP4	13		/* lbci */
#define S_OP5	14		/* ldei */
#define S_OP6	15		/* lhli */

/*
 * Flags.
 */
#define SF_MDF	01		/* Multiply defined */
#define SF_ASG	02		/* Defined by assignment */

/*
 * Variables.
 */
extern struct sym pst[];	/* Perm. symbol table */
extern struct sym ust[];	/* User  symbol table */
extern int listmode;		/* Listing control */
extern int listaddr;		/* Listing control */
extern FILE *src;		/* Source file */
extern FILE *lst;		/* Listing file */
extern FILE *esb;		/* Binary file */
extern int lflag;		/* `-l' flag */
extern int nflag;		/* `-n' flag */
extern int pass;		/* Which pass flag */
extern char *sptr;		/* Source pointer */
extern char sbuf[];		/* Source buffer */
extern char *cptr;		/* Code pocharer */
extern int  cadr;		/* Code base address */
extern int  crec;		/* Code buffer loc */
extern char cbuf[];		/* Code buffer */
extern char crbf[];		/* Code buffer */
extern char *eptr;		/* Error pointer */
extern char ebuf[];		/* Error buffer */
extern struct sym *pptr;	/* End of pst */
extern struct sym *uptr;	/* End of ust */
extern int lineno;		/* Line number */

/*
 * Functions.
 */
extern struct sym *lookup();	/* Lookup a name */
-h- ESA0.C	Sat Jan 02 18:07:06 1982	_DBB0:ESA0.C;1
/*)BUILD	$(PROGRAM)	= ESA		# untested
		$(INCLUDE)	= ESA.H
		$(FILES)	=
			{ esa0.c esa1.c esa2.c esa3.c esa4.c esa5.c }
*/

/*
 * esa0.c		8080 assembler with a funny output format??
 * Mainline.
 *
 * Updated (?) for the new compiler
 */
#include <stdio.h>
#include "esa.h"

/*
 * This is the mainline.
 * It scans the command line,
 * collects up a source file,
 * sets option flags and calls
 * the assembler proper.
 */
main(argc, argv)
char *argv[];
{
	register int i, c;
	register char *p;
	char *file;

	file = NULL;
	for(i=1; i<argc; ++i) {
		p = argv[i];
		if(*p++ == '-') {
			while(c = *p++)
				switch(c) {

				case 'l':
				case 'L':
					++lflag;
					break;

				case 'n':
				case 'N':
					++nflag;
					break;

				default:
					usage();
				}
		} else if(file != NULL)
			usage();
		else
			file = argv[i];
	}
	if(file == NULL)
		usage();
	assemble(file);
}

/*
 * Assemble a file.
 */
assemble(file)
char *file;
{
	char fn[40];

	name(fn, file, "esa", 0);
	if((src=fopen(fn, "r")) == NULL) {
		fprintf(stderr, "%s: cannot open.\n", fn);
		exit(1);
	}
	if(lflag) {
		name(fn, file, "lst", 1);
		if((lst=fopen(fn, "w")) == NULL) {
			fprintf(stderr, "%s: cannot create.\n", fn);
			exit(1);
		}
	}
	if(!nflag) {
		name(fn, file, "esb", 1);
		if((esb=fopen(fn, "w")) == NULL) {
			fprintf(stderr, "%s: cannot create.\n", fn);
			exit(1);
		}
	}
	for(pass=0; pass<2; ++pass) {
		rewind(src);
		lineno = 0;
		dot->s_type = S_ABS;
		dot->s_flag = SF_ASG;
		dot->s_value = 0;
		while(fgetss(sbuf, SRCMAX, src) != NULL) {
			++lineno;
			sptr = sbuf;
			cptr = cbuf;
			eptr = ebuf;
			asmline();
			if(pass) {
				outerrors();
				if(lflag)
					outlisting();
			}
		}
	}
	if(!nflag)
		cflush();
}

/*
 * If the user screws up, put out
 * a usage message.
 * Then quit.
 * Not much sense staying around.
 */
usage()
{
	fprintf(stderr, "Usage: esa [-l] [-n] file.\n");
	exit(1);
}

/*
 * Build RSX file names.
 * The mode argument is either 0
 * which means default, or 1 which
 * means replace with.
 */
name(fn, file, type, mode)
char *fn, *file, *type;
{
	register char *p1, *p2;
	register int c;

	p1 = fn;
	p2 = file;
	while((c = *p2++) && c!='.')
		*p1++ = c;
	if(mode == 0) {
		if(c == '.') {
			do {
				*p1++ = c;
			} while(c = *p2++);
		} else {
			*p1++ = '.';
			p2 = type;
			while(c = *p2++)
				*p1++ = c;
		}
	} else {
		*p1++ = '.';
		p2 = type;
		while(c = *p2++)
			*p1++ = c;
	}
	*p1 = '\0';
}
-h- ESA1.C	Sat Jan 02 18:07:06 1982	_DBB0:ESA1.C;1

/*
 * esa1.c
 * Assemble a line.
 */
#include <stdio.h>
#include "esa.h"

/*
 * Assemble a line.
 * The code is saved in the code
 * buffers for use by the listing
 * generator.
 * Binary code gets written right
 * out.
 */
asmline()
{
	register struct sym *sp;
	register int rs, rd;
	int a, c, f, opcode;
	char id[NCPS];
	
	listaddr = dot->s_value;
	listmode = SLIST;
loop:
	if((c=getnb())=='\0' || c=='/')
		return;
	if(!alpha(c)) {
		err('q');
		return;
	}
	getid(c, id);

	/*
	 * Direct assignment.
	 */
	if((c=getnb()) == '=') {
		sp = lookup(id, ust);
		if(sp->s_type!=S_UND && (sp->s_flag&SF_ASG)==0)
			err('m');
		sp->s_type = S_ABS;
		sp->s_flag |= SF_ASG;
		sp->s_value = listaddr = expr();
		listmode = ALIST;

	/*
	 * Label.
	 */
	} else if(c == ':') {
		if((sp=lookup(id, ust)) == dot)
			err('.');
		else if(pass==0) {
			if(sp->s_type!=S_UND && (sp->s_flag&SF_ASG)==0)
				sp->s_flag |= SF_MDF;
			sp->s_type = S_ABS;
			sp->s_value = dot->s_value;
		} else {
			if((sp->s_flag&SF_MDF)!=0)
				err('m');
			if(sp->s_type!=S_ABS || sp->s_value!=dot->s_value)
				err('p');
		}
		listmode = ALIST;
		goto loop;
	
	/*
	 * Normal (keyword) line.
	 */
	} else {
		putback(c);
		listmode = CLIST;
		if((sp=lookup(id, pst)) == NULL)
			err('o');
		else {
			opcode = sp->s_value;
			switch(sp->s_type) {

			case S_BYTE:
				do {
					a = expr();
					byte(a);
					codeb(a);
				} while((c=getnb()) == ',');
				putback(c);
				break;

			case S_WORD:
				do {
					a = expr();
					codew(a);
				} while((c=getnb()) == ',');
				putback(c);
				break;

			case S_ASCII:
				ascii(0);
				break;

			case S_ASCIZ:
				ascii(1);
				break;

			case S_BLKB:
				a = expr();
				if((c=getnb()) == ',')
					f = expr();
				else {
					putback(c);
					f = 0;
				}
				while(a--)
					codeb(f);
				listmode = ALIST;
				break;

			case S_OP1:
				codeb(opcode);
				break;

			case S_OP2:
				a = expr();
				byte(a);
				codeb(opcode);
				codeb(a);
				break;

			case S_OP3:
				a = expr();
				codeb(opcode);
				codew(a);
				break;

			case S_OP4:
				lrp(LBI, LCI);
				break;

			case S_OP5:
				lrp(LDI, LEI);
				break;

			case S_OP6:
				lrp(LHI, LLI);
				break;

			case S_IN:
				a = expr();
				if((a&~07) != 0)
					err('t');
				codeb(opcode | a<<1);
				break;

			case S_OUT:
				a = expr();
				if((a&~037)!=0 || a<010)
					err('t');
				codeb(opcode | a<<1);
				break;

			default:
				err('o');
			}
		}
	}
	if((c=getnb())!='\0' && c!='/')
		err('q');
}

/*
 * Code a load register pair
 * instruction.
 * The opcode used to load up
 * the hi half is `hi'; the
 * one for the low half is
 * `lo'.
 */
lrp(hi, lo)
{
	register int a;

	a = expr();
	codeb(hi);
	codeb(a>>8);
	codeb(lo);
	codeb(a);
}

/*
 * Process the body of a `.ascii' or of a
 * `.asciz'.
 * The `z' flag is true for an
 * `.asciz'.
 */
ascii(z)
{
	register int c, delim;

	if((delim=getnb()) == '\0') {
		err('q');
		return;
	}
	while((c=getmap())!='\0' && c!=delim)
		codeb(c);
	if(c == '\0')
		err('q');
	if(z)
		codeb(0);
}

/*
 * Given a number (usually the result
 * of an expression, check that the
 * number can be expressed in a byte.
 * If it cannot put out a `t' error.
 */
byte(b)
{
	if((b&0200)!=0)
		b |= ~0377;
	if(b>127 || b<-128)
		err('t');
}
-h- ESA2.C	Sat Jan 02 18:07:06 1982	_DBB0:ESA2.C;1

/*
 * esa2.c
 * Expression reader.
 */
#include <stdio.h>
#include "esa.h"

/*
 * Read in an expression.
 * The type is always absolute.
 * Expressions get interpreted from
 * left to right.
 * No priority.
 * Parentheses may be used to force
 * the order of evaluation.
 */
expr()
{
	register int c;
	int l, r;

	if(!term(&l))
		return(0);
	while(validop(c=getnb())) {
		if(!term(&r)) {
			err('e');
			return(l);
		}
		switch(c) {

		case '+':
			l += r;
			break;

		case '-':
			l -= r;
			break;

		case '*':
			l *= r;
			break;

		case '%':
			l /= r;

		case '&':
			l &= r;
			break;

		case '|':
			l |= r;
		}
	}
	putback(c);
	return(l);
}

/*
 * Test if a character is a valid arithmetic
 * operator.
 * True return if it is.
 */
validop(c)
{
	switch(c) {

	case '+':
	case '-':
	case '*':
	case '%':
	case '&':
	case '|':
		return(1);

	default:
		return(0);
	}
}

/*
 * Get a term.
 * Store it back through the supplied pointer.
 * If no valid term put any characters you read
 * back.
 * True return if a term was obtained.
 */
term(vp)
int *vp;
{
	register struct sym *sp;
	register int c;
	char id[NCPS];

	if((c=getnb())>='0' && c<='9') {
		*vp = getnum(c);
		return(1);
	} else if(alpha(c)) {
		getid(c, id);
		sp = lookup(id, ust);
		if(sp->s_type == S_UND)
			err('u');
		*vp = sp->s_value;
		return(1);
	} else if(c=='-' || c=='!') {
		if(!term(vp)) {
			err('e');
			return(0);
		} else if(c == '-')
			*vp = -*vp;
		else
			*vp = ~*vp;
	} else if(c == '(') {
		*vp = expr();
		if(getnb() != ')')
			err('(');
		return(1);
	} else if(c == '\'') {
		*vp = getmap();
		if(getnb() != '\'')
			err('\'');
		return(1);
	} else {
		putback(c);
		return(0);
	}
}
-h- ESA3.C	Sat Jan 02 18:07:06 1982	_DBB0:ESA3.C;1

/*
 * esa3.c
 * Lexical processing.
 */
#include <stdio.h>
#include "esa.h"

/*
 * Get the next non white character
 * from the input.
 */
getnb()
{
	register int c;

	while((c=getraw())==' ' || c=='\t');
	return(c);
}

/*
 * Get the next input character.
 * Be very careful with respect to
 * end of lines.
 */
getraw()
{
	register int c;

	if((c = *sptr) != '\0')
		++sptr;
	return(c);
}

/*
 * Test if a character is alphabetic.
 * True return if it is.
 */
alpha(ac)
{
	register int c;

	c = ac;
	if(c=='.' || c=='_' || (c>='a' && c<='z') || (c>='A' && c<='Z'))
		return(1);
	return(0);
}

/*
 * Push a character back into the input.
 * Must not push back beyond the start of
 * the line.
 */
putback(c)
{
	if(c != '\0')
		if(--sptr < sbuf)
			error("Putback\n");
}

/*
 * Read in an indentifier.
 * Store it (padded with nulls) into the
 * supplied buffer.
 */
getid(ac, id)
char *id;
{
	register int c;
	register char *p;

	c = ac;
	p = id;
	while(alpha(c) || (c>='0' && c<='9')) {
		if(p < &id[NCPS])
			*p++ = c;
		c = getraw();
	}
	while(p < &id[NCPS])
		*p++ = '\0';
	putback(c);
}

/*
 * Get a number, in either the hexadecimal or
 * the decimal radix.
 * Decimal is indicated by a trailing '.'.
 */
getnum(ac)
{
	register int c, v, hexseen;
	int hex, dec;

	c = ac;
	hex = dec = hexseen = 0;
	while((v=digvalue(c)) >= 0) {
		hex = 16*hex + v;
		dec = 10*dec + v;
		if(v > 9)
			++hexseen;
		c = getraw();
	}
	if(c == '.') {
		if(hexseen)
			err('n');
		return(dec);
	} else {
		putback(c);
		return(hex);
	}
}

/*
 * Given a character, return its numeric value.
 * This is in the range 0 to 15.
 * Return -1 if the input is junk.
 */
digvalue(ac)
{
	register int c;

	c = ac;
	if(c>='0' && c<='9')
		return(c-'0');
	if(c>='a' && c<='f')
		return(c-'a'+10);
	if(c>='A' && c<='F')
		return(c-'A'+10);
	return(-1);
}

/*
 * Lookup a symbol in a symbol table, which
 * may be either `pst' or `ust'.
 * Failures in the `pst' return NULL.
 * Failures in the `ust' cause a new symbol to
 * be added.
 */
struct sym *
lookup(id, astp)
char *id;
struct sym *astp;
{
	register struct sym *stp, *endp;

	if((stp=astp) == ust)
		endp = uptr;
	else
		endp = pptr;
	while(stp < endp) {
		if(match(id, stp->s_name))
			return(stp);
		++stp;
	}
	if(astp == pst)
		return(NULL);
	if(stp >= &ust[USERMAX])
		error("Symbol table overflow\n");
	copy(stp->s_name, id, NCPS);
	stp->s_type = S_UND;
	stp->s_flag = 0;
	stp->s_value = 0;
	++uptr;
	return(stp);
}

/*
 * Compare two names.
 * True return if the same.
 */
match(aa1, aa2)
char *aa1, *aa2;
{
	register char *a1, *a2;
	register int n;

	a1 = aa1;
	a2 = aa2;
	n = NCPS;
	do
		if(*a1++ != *a2++)
			return(0);
	while(--n);
	return(1);
}

/*
 * Get the next character from the input
 * using string mappings.
 */
getmap()
{
	register int n, c, v;

	if((c=getraw()) == '\\')
		switch(c = getraw()) {

		case 'n':
			c = '\n';
			break;

		case 'r':
			c = '\r';
			break;

		case 't':
			c = 0x20;
			break;

		case 'b':
			c = '\b';
			break;

		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
			v = n = 0;
			while(++n<=3 && c>='0' && c<='7') {
				v = 8*v + c - '0';
				c = getraw();
			}
			putback(c);
			c = v;
			break;

		default:
			putback(c);
			c = '\\';
		}
	else if(c == ' ')
		c = 0xD0;
	else if(c == '/')
		c = 0x40;
	else if(c == '@')
		c = 0x3D + 1; /* Kludge */
	else if(c == '\t')
		c = 0x20;
	else if(c == '_')
		c = 0x3D;
	return(c);
}
-h- ESA4.C	Sat Jan 02 18:07:06 1982	_DBB0:ESA4.C;1

/*
 * esa4.c
 * Code and listing.
 */
#include <stdio.h>
#include "esa.h"

/*
 * Output a byte to the code buffer.
 * Also update `.'.
 */
codeb(b)
{
	if(cptr < &cbuf[CODEMAX])
		*cptr++ = b&0377;
	else
		err('z');
	if(pass && !nflag) {
		if(crec>=CRSIZE || cadr+crec!=dot->s_value) {
			cflush();
			cadr = dot->s_value;
		}
		crbf[crec++] = b;
	}
	++dot->s_value;
}

/*
 * Output a word (low byte first) to the code
 * buffer.
 */
codew(w)
{
	codeb(w);
	codeb(w>>8);
}

/*
 * Put an error into the error buffer.
 * If this error type is already there
 * just return.
 * Otherwise add it to the end.
 * It is a fatal error for the error
 * buffer to overflow.
 */
err(c)
{
	register char *p;

	p = ebuf;
	while(p < eptr)
		if(*p++ == c)
			return;
	if(p >= &ebuf[ERRMAX])
		error("Ebuf overflow\n");
	*p++ = c;
	eptr = p;
}

/*
 * Output the code collected in the code buffer
 * and the source line to the listing.
 * This routine is only called if the `-l' option
 * is present.
 * Note the great trouble caused by the signs on
 * the bytes being extended.
 */
outlisting()
{
	register int nbytes;
	register char *cp;
	int w1, w2, w3;

	if(listmode == NLIST)
		return;
	for(cp=eptr; cp<&ebuf[ERRMAX]; *cp++=' ')
		;
	if(listmode == SLIST)
		fprintf(lst, "%.10s      ", ebuf);
	else
		fprintf(lst, "%.10s %04x ", ebuf, listaddr);
	if(listmode == ALIST) {
		fprintf(lst, "%9s%6d %s\n", "", lineno, sbuf);
	} else {
		nbytes = cptr-cbuf;
		w1 = cbuf[0] & 0377;
		w2 = cbuf[1] & 0377;
		w3 = cbuf[2] & 0377;
		switch(nbytes) {

		case 0:
			fprintf(lst, "%9s", "");
			break;

		case 1:
			fprintf(lst, "%02x%7s", w1, "");
			break;

		case 2:
			fprintf(lst, "%02x %02x%4s", w1, w2, "");
			break;

		default:
			fprintf(lst, "%02x %02x %02x ", w1, w2, w3);
		}
		fprintf(lst, "%6d %s\n", lineno, sbuf);
		cp = &cbuf[3];
		while((nbytes -= 3) > 0) {
			fprintf(lst, "%16s", "");
			switch(nbytes) {

			case 1:
				w1 = cp[0] & 0377;
				fprintf(lst, "%02x\n", w1);
				break;

			case 2:
				w1 = cp[0] & 0377;
				w2 = cp[1] & 0377;
				fprintf(lst, "%02x %02x\n", w1, w2);
				break;

			default:
				w1 = cp[0] & 0377;
				w2 = cp[1] & 0377;
				w3 = cp[2] & 0377;
				fprintf(lst, "%02x %02x %02x\n", w1, w2, w3);
			}
			cp += 3;
		}
	}
}

/*
 * Output errors to the terminal.
 */
outerrors()
{
	register char *p;

	p = ebuf;
	while(p < eptr)
		printf("%c %04d\n", *p++, lineno);
}

/*
 * Flush the code buffer.
 */
cflush()
{
	register int i, c, csum;

	if(crec == 0)
		return;
	fprintf(esb, "%02x%02x %02x ", (cadr>>8)&0377, cadr&0377, crec);
	csum = 0;
	for(i=0; i<crec; ++i) {
		c = crbf[i]&0377;
		csum += c;
		fprintf(esb, "%02x", c);
	}
	fprintf(esb, " %02x%02x\n", csum&0377, (csum>>8)&0377);
	crec = 0;
}
-h- ESA5.C	Sat Jan 02 18:07:06 1982	_DBB0:ESA5.C;1

/*
 * esa5.c
 * Tables and things.
 */
#include <stdio.h>
#include "esa.h"

/*
 * Assorted variables.
 */
int  listmode;			/* Listing mode */
int  listaddr;			/* Listing address */
FILE *src;			/* Source ioptr */
FILE *lst;			/* Listing ioptr */
FILE *esb;			/* Binary ioptr */
int  lflag;			/* `-l' flag */
int  nflag;			/* `-n' flag */
int  pass;			/* Pass indicator */
int  lineno;			/* Line number */
char *sptr;			/* Source scanning pointer */
char *cptr;			/* Code pocharer */
int cadr -1;			/* Code base address */
int crec  0;			/* Code buffer pointer */
char *eptr;			/* Error pointer */

/*
 * Buffers.
 */
char sbuf[SRCMAX];		/* Source line buffer */
char ebuf[ERRMAX];		/* Error buffer */
char cbuf[CODEMAX];		/* Code buffer */
char crbf[CRSIZE];		/* Output code buffer */

/*
 * User symbol table.
 * The first item must be '.'.
 */
struct sym ust[USERMAX] {
	".",		S_ABS,		SF_ASG,	0,
	"port0",	S_ABS,		0,	020,
	"port1",	S_ABS,		0,	021,
	"port2",	S_ABS,		0,	022,
	"port3",	S_ABS,		0,	023,
	"port4",	S_ABS,		0,	024,
	"port5",	S_ABS,		0,	025,
	"port6",	S_ABS,		0,	026,
	"port7",	S_ABS,		0,	027,
	"port8",	S_ABS,		0,	030,
	"port9",	S_ABS,		0,	031,
	"porta",	S_ABS,		0,	032,
	"portb",	S_ABS,		0,	033,
	"portc",	S_ABS,		0,	034,
	"portd",	S_ABS,		0,	035,
	"porte",	S_ABS,		0,	036,
	"portf",	S_ABS,		0,	037
};

/*
 * Opcode table.
 * Also contains pseudo operations and
 * registers.
 */
struct sym pst[] {
	".byte",	S_BYTE,		0,	0,
	".word",	S_WORD,		0,	0,
	".ascii",	S_ASCII,	0,	0,
	".asciz",	S_ASCIZ,	0,	0,
	".blkb",	S_BLKB,		0,	0,
	"aca",		S_OP1,		0,	0210,	
	"acb",		S_OP1,		0,	0211,	
	"acc",		S_OP1,		0,	0212,	
	"acd",		S_OP1,		0,	0213,	
	"ace",		S_OP1,		0,	0214,	
	"ach",		S_OP1,		0,	0215,	
	"acl",		S_OP1,		0,	0216,	
	"acm",		S_OP1,		0,	0217,	
	"ada",		S_OP1,		0,	0200,	
	"adb",		S_OP1,		0,	0201,	
	"adc",		S_OP1,		0,	0202,	
	"add",		S_OP1,		0,	0203,	
	"ade",		S_OP1,		0,	0204,	
	"adh",		S_OP1,		0,	0205,	
	"adl",		S_OP1,		0,	0206,	
	"adm",		S_OP1,		0,	0207,	
	"cpa",		S_OP1,		0,	0270,	
	"cpb",		S_OP1,		0,	0271,	
	"cpc",		S_OP1,		0,	0272,	
	"cpd",		S_OP1,		0,	0273,	
	"cpe",		S_OP1,		0,	0274,	
	"cph",		S_OP1,		0,	0275,	
	"cpl",		S_OP1,		0,	0276,	
	"cpm",		S_OP1,		0,	0277,	
	"dcb",		S_OP1,		0,	0011,	
	"dcc",		S_OP1,		0,	0021,	
	"dcd",		S_OP1,		0,	0031,	
	"dce",		S_OP1,		0,	0041,	
	"dch",		S_OP1,		0,	0051,	
	"dcl",		S_OP1,		0,	0061,	
	"hlt",		S_OP1,		0,	0377,	
	"inb",		S_OP1,		0,	0010,	
	"inc",		S_OP1,		0,	0020,	
	"ind",		S_OP1,		0,	0030,	
	"ine",		S_OP1,		0,	0040,	
	"inh",		S_OP1,		0,	0050,	
	"inl",		S_OP1,		0,	0060,	
	"laa",		S_OP1,		0,	0300,	
	"lab",		S_OP1,		0,	0301,	
	"lac",		S_OP1,		0,	0302,	
	"lad",		S_OP1,		0,	0303,	
	"lae",		S_OP1,		0,	0304,	
	"lah",		S_OP1,		0,	0305,	
	"lal",		S_OP1,		0,	0306,	
	"lam",		S_OP1,		0,	0307,	
	"lba",		S_OP1,		0,	0310,	
	"lbb",		S_OP1,		0,	0311,	
	"lbc",		S_OP1,		0,	0312,	
	"lbd",		S_OP1,		0,	0313,	
	"lbe",		S_OP1,		0,	0314,	
	"lbh",		S_OP1,		0,	0315,	
	"lbl",		S_OP1,		0,	0316,	
	"lbm",		S_OP1,		0,	0317,	
	"lca",		S_OP1,		0,	0320,	
	"lcb",		S_OP1,		0,	0321,	
	"lcc",		S_OP1,		0,	0322,	
	"lcd",		S_OP1,		0,	0323,	
	"lce",		S_OP1,		0,	0324,	
	"lch",		S_OP1,		0,	0325,	
	"lcl",		S_OP1,		0,	0326,	
	"lcm",		S_OP1,		0,	0327,	
	"lda",		S_OP1,		0,	0330,	
	"ldb",		S_OP1,		0,	0331,	
	"ldc",		S_OP1,		0,	0332,	
	"ldd",		S_OP1,		0,	0333,	
	"lde",		S_OP1,		0,	0334,	
	"ldh",		S_OP1,		0,	0335,	
	"ldl",		S_OP1,		0,	0336,	
	"ldm",		S_OP1,		0,	0337,	
	"lea",		S_OP1,		0,	0340,	
	"leb",		S_OP1,		0,	0341,	
	"lec",		S_OP1,		0,	0342,	
	"led",		S_OP1,		0,	0343,	
	"lee",		S_OP1,		0,	0344,	
	"leh",		S_OP1,		0,	0345,	
	"lel",		S_OP1,		0,	0346,	
	"lem",		S_OP1,		0,	0347,	
	"lha",		S_OP1,		0,	0350,	
	"lhb",		S_OP1,		0,	0351,	
	"lhc",		S_OP1,		0,	0352,	
	"lhd",		S_OP1,		0,	0353,	
	"lhe",		S_OP1,		0,	0354,	
	"lhh",		S_OP1,		0,	0355,	
	"lhl",		S_OP1,		0,	0356,	
	"lhm",		S_OP1,		0,	0357,	
	"lla",		S_OP1,		0,	0360,	
	"llb",		S_OP1,		0,	0361,	
	"llc",		S_OP1,		0,	0362,	
	"lld",		S_OP1,		0,	0363,	
	"lle",		S_OP1,		0,	0364,	
	"llh",		S_OP1,		0,	0365,	
	"lll",		S_OP1,		0,	0366,	
	"llm",		S_OP1,		0,	0367,	
	"lma",		S_OP1,		0,	0370,	
	"lmb",		S_OP1,		0,	0371,	
	"lmc",		S_OP1,		0,	0372,	
	"lmd",		S_OP1,		0,	0373,	
	"lme",		S_OP1,		0,	0374,	
	"lmh",		S_OP1,		0,	0375,	
	"lml",		S_OP1,		0,	0376,	
	"nda",		S_OP1,		0,	0240,	
	"ndb",		S_OP1,		0,	0241,	
	"ndc",		S_OP1,		0,	0242,	
	"ndd",		S_OP1,		0,	0243,	
	"nde",		S_OP1,		0,	0244,	
	"ndh",		S_OP1,		0,	0245,	
	"ndl",		S_OP1,		0,	0246,	
	"ndm",		S_OP1,		0,	0247,	
	"ora",		S_OP1,		0,	0260,	
	"orb",		S_OP1,		0,	0261,	
	"orc",		S_OP1,		0,	0262,	
	"ord",		S_OP1,		0,	0263,	
	"ore",		S_OP1,		0,	0264,	
	"orh",		S_OP1,		0,	0265,	
	"orl",		S_OP1,		0,	0266,	
	"orm",		S_OP1,		0,	0267,	
	"ral",		S_OP1,		0,	0022,	
	"rar",		S_OP1,		0,	0032,	
	"ret",		S_OP1,		0,	0007,	
	"rfc",		S_OP1,		0,	0003,	
	"rfp",		S_OP1,		0,	0033,	
	"rfs",		S_OP1,		0,	0023,	
	"rfz",		S_OP1,		0,	0013,	
	"rlc",		S_OP1,		0,	0002,	
	"rrc",		S_OP1,		0,	0012,	
	"rs1",		S_OP1,		0,	0015,	
	"rs2",		S_OP1,		0,	0025,	
	"rs3",		S_OP1,		0,	0035,	
	"rs4",		S_OP1,		0,	0045,	
	"rs5",		S_OP1,		0,	0055,	
	"rs6",		S_OP1,		0,	0065,	
	"rs7",		S_OP1,		0,	0075,	
	"rst",		S_OP1,		0,	0005,	
	"rtc",		S_OP1,		0,	0043,	
	"rtp",		S_OP1,		0,	0073,	
	"rts",		S_OP1,		0,	0063,	
	"rtz",		S_OP1,		0,	0053,	
	"sba",		S_OP1,		0,	0230,	
	"sbb",		S_OP1,		0,	0231,	
	"sbc",		S_OP1,		0,	0232,	
	"sbd",		S_OP1,		0,	0233,	
	"sbe",		S_OP1,		0,	0234,	
	"sbh",		S_OP1,		0,	0235,	
	"sbl",		S_OP1,		0,	0236,	
	"sbm",		S_OP1,		0,	0237,	
	"sua",		S_OP1,		0,	0220,	
	"sub",		S_OP1,		0,	0221,	
	"suc",		S_OP1,		0,	0222,	
	"sud",		S_OP1,		0,	0223,	
	"sue",		S_OP1,		0,	0224,	
	"suh",		S_OP1,		0,	0225,	
	"sul",		S_OP1,		0,	0226,	
	"sum",		S_OP1,		0,	0227,	
	"xra",		S_OP1,		0,	0250,	
	"xrb",		S_OP1,		0,	0251,	
	"xrc",		S_OP1,		0,	0252,	
	"xrd",		S_OP1,		0,	0253,	
	"xre",		S_OP1,		0,	0254,	
	"xrh",		S_OP1,		0,	0255,	
	"xrl",		S_OP1,		0,	0256,	
	"xrm",		S_OP1,		0,	0257,	
	"ihl",		S_OP1,		0,	0070,	
	"dhl",		S_OP1,		0,	0071,	
	"exc",		S_OP1,		0,	0042,	
	"sfa",		S_OP1,		0,	0311,	
	"rfa",		S_OP1,		0,	0322,	
	"sam",		S_OP1,		0,	0166,	
	"sma",		S_OP1,		0,	0126,	
	"ide",		S_OP1,		0,	0344,	
	"dde",		S_OP1,		0,	0333,	
	"ina",		S_OP1,		0,	0116,	
	"dca",		S_OP1,		0,	0077,	
	"pop",		S_OP1,		0,	0156,	
	"jde",		S_OP1,		0,	0176,	
	"cde",		S_OP1,		0,	0174,	
	"aci",		S_OP2,		0,	0014,	
	"adi",		S_OP2,		0,	0004,	
	"cpi",		S_OP2,		0,	0074,	
	"lai",		S_OP2,		0,	0006,	
	"lbi",		S_OP2,		0,	0016,	
	"lci",		S_OP2,		0,	0026,	
	"ldi",		S_OP2,		0,	0036,	
	"lei",		S_OP2,		0,	0046,	
	"lhi",		S_OP2,		0,	0056,	
	"lli",		S_OP2,		0,	0066,	
	"lmi",		S_OP2,		0,	0076,	
	"ndi",		S_OP2,		0,	0044,	
	"ori",		S_OP2,		0,	0064,	
	"sbi",		S_OP2,		0,	0034,	
	"sui",		S_OP2,		0,	0024,	
	"xri",		S_OP2,		0,	0054,	
	"tai",		S_OP2,		0,	0072,	
	"gam",		S_OP3,		0,	0136,	
	"gbm",		S_OP3,		0,	0114,	
	"gcm",		S_OP3,		0,	0124,	
	"gdm",		S_OP3,		0,	0134,	
	"gem",		S_OP3,		0,	0144,	
	"ghm",		S_OP3,		0,	0154,	
	"glm",		S_OP3,		0,	0164,	
	"gma",		S_OP3,		0,	0001,	
	"gmb",		S_OP3,		0,	0017,	
	"gmc",		S_OP3,		0,	0027,	
	"gmd",		S_OP3,		0,	0037,	
	"gme",		S_OP3,		0,	0047,	
	"gmh",		S_OP3,		0,	0057,	
	"gml",		S_OP3,		0,	0067,	
	"inm",		S_OP3,		0,	0146,	
	"cal",		S_OP3,		0,	0106,	
	"cfc",		S_OP3,		0,	0102,	
	"cfp",		S_OP3,		0,	0132,	
	"cfs",		S_OP3,		0,	0122,	
	"cfz",		S_OP3,		0,	0112,	
	"ctc",		S_OP3,		0,	0142,	
	"ctp",		S_OP3,		0,	0172,	
	"cts",		S_OP3,		0,	0162,	
	"ctz",		S_OP3,		0,	0152,	
	"jfc",		S_OP3,		0,	0100,	
	"jfp",		S_OP3,		0,	0130,	
	"jfs",		S_OP3,		0,	0120,	
	"jfz",		S_OP3,		0,	0110,	
	"jmp",		S_OP3,		0,	0104,	
	"jtc",		S_OP3,		0,	0140,	
	"jtp",		S_OP3,		0,	0170,	
	"jts",		S_OP3,		0,	0160,	
	"jtz",		S_OP3,		0,	0150,	
	"lbci",		S_OP4,		0,	0,
	"ldei",		S_OP5,		0,	0,
	"lhli",		S_OP6,		0,	0,
	"in",		S_IN,		0,	0101,
	"out",		S_OUT,		0,	0101,
	"advrdr",	S_OP1,		0,	0121,
	"outdat",	S_OP1,		0,	0123,
	"outcon",	S_OP1,		0,	0125,
	"setx",		S_OP1,		0,	0127,
	"punch",	S_OP1,		0,	0131,
	"sety",		S_OP1,		0,	0135,
	"beep",		S_OP1,		0,	0121,
	"inio",		S_OP1,		0,	0101,
	"incon",	S_OP1,		0,	0103,
	"rdy",		S_OP1,		0,	0105,
	"portin",	S_OP1,		0,	0111
};

/*
 * Pointers to the end of the two symbol
 * tables.
 * These must be here for the `sizeof' to
 * work.
 */
struct sym *pptr &pst[sizeof(pst)/sizeof(pst[0])]; /* Ditto */
struct sym *uptr &ust[17];
                                                                                                                                                                                                                                                                                                                           