-h- ASM80.C	Sat Jan 02 18:05:52 1982	_DBB0:ASM80.C;1
/*
 * asm80.c
 * Mainline.
 *
 * Updated (?) for the new compiler
 */

/*)BUILD	$(PROGRAM)	= ASM80		# untested
		$(INCLUDE)	= ASM80.H
		$(FILES)	=
			{ asm80.c asm81.c asm82.c asm83.c asm84.c asm85.c }
*/

#include <stdio.h>
#include "asm80.h"

/*
 * This is the mainline.
 * It scans the command line,
 * collects up a source file,
 * sets option flags and calls
 * the assembler proper.
 */
main(argc, argv)
char *argv[];
{
	register int i, c;
	register char *p;
	char *file;

	file = NULL;
	for(i=1; i<argc; ++i) {
		p = argv[i];
		if(*p++ == '-') {
			while(c = *p++)
				switch(c) {

				case 'l':
				case 'L':
					++lflag;
					break;

				case 'n':
				case 'N':
					++nflag;
					break;

				default:
					usage();
				}
		} else if(file != NULL)
			usage();
		else
			file = argv[i];
	}
	if(file == NULL)
		usage();
	assemble(file);
}

/*
 * Assemble a file.
 */
assemble(file)
char *file;
{
	char fn[40];
	char sn[40];

	name(sn, file, "i80", 0);
	if((src=fopen(sn, "r")) == NULL) {
		fprintf(stderr, "%s: cannot open\n", sn);
		exit(1);
	}
	if(lflag) {
		name(fn, file, "lis", 1);
		if((lst=fopen(fn, "w")) == NULL) {
			fprintf(stderr, "%s: cannot create\n", fn);
			exit(1);
		}
	}
	if(!nflag) {
		name(fn, file, "lod", 1);
		if((obj=fopen(fn, "w")) == NULL) {
			fprintf(stderr, "%s: cannot create\n", fn);
			exit(1);
		}
		fprintf(obj, "\033&b\n");
	}
	for(pass=0; pass<2; ++pass) {
		lineno = 0;
		dot->s_type = S_ABS;
		dot->s_flag = SF_ASG;
		dot->s_value = 0;
		while(fgetss(sbuf, SRCMAX, src) != NULL) {
			++lineno;
			sptr = sbuf;
			cptr = cbuf;
			eptr = ebuf;
			asmline();
			if(pass) {
				outerrors();
				if(lflag)
					outlisting();
			}
		}
		if(!pass) {
			fclose(src);
			src=fopen(sn,"r");
		}
	}
	if(lflag) symprt();
	if(!nflag)
		cflush(1);
}

/*
 * If the user screws up, put out
 * a usage message.
 * Then quit.
 * Not much sense staying around.
 */
usage()
{
	fprintf(stderr, "Usage: as8 [-ln] file\n");
	exit(1);
}

/*
 * Build RSX file names.
 * The mode argument is either 0
 * which means default, or 1 which
 * means replace with.
 */
name(fn, file, type, mode)
char *fn, *file, *type;
{
	register char *p1, *p2;
	register int c;

	p1 = fn;
	p2 = file;
	while((c = *p2++) && c!='.')
		*p1++ = c;
	if(mode == 0) {
		if(c == '.') {
			do {
				*p1++ = c;
			} while(c = *p2++);
		} else {
			*p1++ = '.';
			p2 = type;
			while(c = *p2++)
				*p1++ = c;
		}
	} else {
		*p1++ = '.';
		p2 = type;
		while(c = *p2++)
			*p1++ = c;
	}
	*p1 = '\0';
}
-h- ASM80.COM	Sat Jan 02 18:05:52 1982	_DBB0:ASM80.COM;1
! assemble and link native VAX 8080 assembler
! Warning: uses the native VAX C compiler
$ cc asm80
$ cc asm81
$ cc asm82
$ cc asm83
$ cc asm84
$ cc asm85
$ @asm80l.com
-h- ASM80.H	Sat Jan 02 18:05:52 1982	_DBB0:ASM80.H;1
#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * as8.h
 * Header.
 * Sizes of tables.
 * Don't change ERRMAX.
 */
#define NCPS	8		/* Characters per symbol */
#define CLMAX	100		/* Code bytes, line */
#define CBMAX	32		/* Code bytes, object */
#define USERMAX	1000		/* User names */
#define SRCMAX	128		/* Source line length */
#define ERRMAX	10		/* Maximum errors per line */
#define REFMAX	4000		/* Maximum reference entries */
#define LREFMAX	16		/* References per listing line */
#define dot	(&ust[0])	/* Location counter */

/*
 * 8080 Magic numbers.
 */
#define BC	0		/* BC in instructions */
#define DE	1		/* DE in instructions */
#define HL	2		/* HL in instructions */
#define SP	3		/* SP in instructions */
#define PSW	4		/* Flag */
#define INR	0004		/* INR opcode */
#define DCR	0005		/* DCR opcode */

/*
 * Listing control modes.
 * Go in `listmode'.
 */
#define NLIST	0		/* No list */
#define SLIST	1		/* Source only list */
#define ALIST	2		/* Just address */
#define CLIST	3		/* Address and code */

/*
 * Reference chain structure
 */
struct reflst {
	int r_stmtno;		/* The statement number */
	struct reflst *r_chain;	/* Chain pointer */
};

/*
 * Symbol table structure.
 * Used in both the user symbol table and
 * the opcode table.
 */
struct sym {
	char s_name[NCPS];	/* Name */
	char s_type;		/* Type */
	char s_flag;		/* Some flags */
	struct reflst *s_ref;	/* Reference chain pointer */
	int  s_value;		/* Value */
};

/*
 * Types.
 */
#define S_UND	0		/* Undefined */
#define S_ABS	1		/* Absolute */
#define S_REG	2		/* Register */
#define S_REGP	3		/* Register pair */
#define S_ENTRY	4		/* .entry */
#define S_BYTE	5		/* .byte */
#define S_WORD	6		/* .word */
#define S_ASCII	7		/* .ascii */
#define S_ASCIZ	8		/* .asciz */
#define S_BLKB	9		/* .blkb */
#define S_OP1	10		/* Opcode */
#define S_OP2	11		/* Opcode byte */
#define S_OP3	12		/* Opcode reg,byte */
#define S_OP4	13		/* Opcode reg,reg */
#define S_OP5	14		/* Opcode bd */
#define S_OP6	15		/* Opcode bdhs */
#define S_OP7	16		/* Opcode bdhpsw */
#define S_OP8	17		/* Opcode 0-7 */
#define S_OP9	18		/* Opcode reg */
#define S_OP10	19		/* Opcode rp,word */
#define S_OP11	20		/* Opcode address */

/*
 * Flags.
 */
#define SF_MDF	01		/* Multiply defined */
#define SF_ASG	02		/* Defined by assignment */

/*
 * Variables.
 */
extern	struct	sym pst[];	/* Opcode table */
extern	struct	sym ust[];	/* User symbols */
extern	struct	reflst reftab[]; /* Reference list */
extern	int	listmode;	/* Listing control */
extern	int	listaddr;	/* Listing control */
extern	int	entaddr;	/* .entry address */
extern	FILE	*src;		/* Source */
extern	FILE	*lst;		/* Listing */
extern	FILE	*obj;		/* Object */
extern	int	lflag;		/* -l flag */
extern	int	nflag;		/* -n flag */
extern	int	pass;		/* Which pass? */
extern	int	lineno;		/* Line number */
extern	char	*sptr;		/* Source pointer */
extern	char	sbuf[];		/* Source buffer */
extern	char	*cptr;		/* Listing code pointer */
extern	char	cbuf[];		/* Listing code buffer */
extern	char	*eptr;		/* Error pointer */
extern	char	ebuf[];		/* Error buffer */
extern	int	cadr;		/* Object address */
extern	int	crec;		/* Object index */
extern	char	crbf[];		/* Object buffer */
extern	int	symcnt;		/* Count of symbols */
extern	int	refcnt;		/* Count of references */
extern	struct	sym *pptr;	/* End of pst */
extern	struct	sym *uptr;	/* End of ust */
extern	struct	reflst *refptr;	/* End of Reference table */

/*
 * Functions.
 */
extern	struct	sym *lookup();	/* Search */
-h- ASM80L.COM	Sat Jan 02 18:05:52 1982	_DBB0:ASM80L.COM;1
$ link asm80,asm81,asm82,asm83,asm84,asm85@[c]cmd
-h- ASM81.C	Sat Jan 02 18:05:52 1982	_DBB0:ASM81.C;1

/*
 * asm81.c
 * Assemble a line.
 */
#include <stdio.h>
#include "asm80.h"

/*
 * Assemble a line.
 */
asmline()
{
	register struct sym *sp;
	register int rs, rd;
	int a, c, opcode;
	char id[NCPS];
	
	listaddr = dot->s_value;
	listmode = SLIST;
loop:
	if((c=getnb())=='\0' || c==';')
		return;
	if(!alpha(c)) {
		err('q');
		return;
	}
	getid(c, id);

	/*
	 * Direct assignment.
	 */
	if((c=getnb()) == '=') {
		sp = lookup(id, ust);
		if(sp->s_type!=S_UND && (sp->s_flag&SF_ASG)==0)
			err('m');
		sp->s_type = S_ABS;
		sp->s_flag |= SF_ASG;
		sp->s_value = listaddr = expr();
		listmode = ALIST;
		if (pass!=0)
			sp->s_ref->r_stmtno= - sp->s_ref->r_stmtno;

	/*
	 * Label.
	 */
	} else if(c == ':') {
		if((sp=lookup(id, ust)) == dot)
			err('.');
		else if(pass==0) {
			if(sp->s_type!=S_UND && (sp->s_flag&SF_ASG)==0)
				sp->s_flag |= SF_MDF;
			sp->s_type = S_ABS;
			sp->s_value = dot->s_value;
		} else {
			if((sp->s_flag&SF_MDF)!=0)
				err('m');
			if(sp->s_type!=S_ABS || sp->s_value!=dot->s_value)
				err('p');
		}
		listmode = ALIST;
		if (pass!=0)
			sp->s_ref->r_stmtno= - sp->s_ref->r_stmtno;
		goto loop;
	
	/*
	 * Normal (keyword) line.
	 */
	} else {
		putback(c);
		listmode = CLIST;
		if((sp=lookup(id, pst)) == NULL)
			err('o');
		else {
			opcode = sp->s_value;
			switch(sp->s_type) {

			case S_ENTRY:
				entaddr = expr();
				break;

			case S_BYTE:
				do {
				    c=getnb();
				    putback(c);
				    if(c=='\'')
					ascii(0);
				    else {
					a = expr();
					byte(a);
					codeb(a);
				    }
				} while((c=getnb()) == ',');
				putback(c);
				break;

			case S_WORD:
				do {
					codew(expr());
				} while((c=getnb()) == ',');
				putback(c);
				break;

			case S_ASCII:
				ascii(0);
				break;

			case S_ASCIZ:
				ascii(1);
				break;

			case S_BLKB:
				a = expr();
				while(a--)
					codeb(0);
				listmode = ALIST;
				break;

			case S_OP1:
				codeb(opcode);
				break;

			case S_OP2:
				a = expr();
				byte(a);
				codeb(opcode);
				codeb(a);
				break;

			case S_OP3:
				rd = getreg(S_REG);
				comma();
				a = expr();
				byte(a);
				code3(opcode, rd);
				codeb(a);
				break;

			case S_OP4:
				rd = getreg(S_REG);
				comma();
				rs = getreg(S_REG);
				codeb(opcode | rd<<3 | rs);
				break;

			case S_OP5:
				if((rd=getreg(S_REGP))!=BC && rd!=DE)
					err('a');
				code4(opcode, rd);
				break;

			case S_OP6:
				if((rd=getreg(S_REGP)) == PSW)
					err('a');
				code4(opcode, rd);
				break;

			case S_OP7:
				if((rd=getreg(S_REGP)) == SP)
					err('a');
				if(rd == PSW)
					rd = SP;
				code4(opcode, rd);
				break;

			case S_OP8:
				a = expr();
				if(a<0 || a>7)
					err('t');
				code3(opcode, a&07);
				break;

			case S_OP9:
				rs = getreg(S_REG);
				if(opcode==INR || opcode==DCR)
					code3(opcode, rs);
				else
					codeb(opcode | rs);
				break;

			case S_OP10:
				if((rd=getreg(S_REGP)) == PSW)
					err('a');
				comma();
				a = expr();
				code4(opcode, rd);
				codew(a);
				break;

			case S_OP11:
				a = expr();
				codeb(opcode);
				codew(a);
				break;

			default:
				err('o');
			}
		}
	}
	if((c=getnb())!='\0' && c!=';')
		err('q');
}

/*
 * Process the body of .ascii
 * and .asciz pseudo ops.
 * The z flag is true for a
 * .asciz
 */
ascii(z)
{
	register int c, delim;

	if((delim=getnb()) == '\0') {
		err('q');
		return;
	}
	while((c=getmap())!='\0' && c!=delim)
		codeb(c);
	if(c == '\0')
		err('q');
	if(z)
		codeb(0);
}

/*
 * Get a register.
 * Type is either S_REG or S_REGP.
 */
getreg(type)
{
	register struct sym *sp;
	register int c;
	char id[NCPS];

	if(!alpha(c=getnb())) {
		err('a');
		putback(c);
		return(0);
	}
	getid(c, id);
	if((sp=lookup(id, pst))==NULL) {
		err('a');
		return(0);
	}
	if(sp->s_type==S_REG && type==S_REGP) {

		switch(sp->s_value) {
		case 0: return(0);  /* b = bc */
		case 2: return(1);  /* d = de */
		case 4: return(2);  /* h = hl */
		default:
			err('a');
			return(0);
		}

	}
	if (sp->s_type!=type) {
		err('a');
		return(0);
	}
	return(sp->s_value);
}

/*
 * Insure that the value of
 * an expression is a legal
 * byte value.
 * Error if not.
 */
byte(b)
{
	if((b&0200)!=0)
		b |= ~0377;
	if(b>127 || b<-128)
		err('t');
}

/*
 * Check for `,'.
 */
comma()
{
	if(getnb() != ',')
		err('a');
}

/*
 * Build instructions of the
 * general form xxrrrxxx.
 */
code3(x, r)
{
	codeb(x | r<<3);
}

/*
 * Build instructions of the
 * general form xxrrxxxx.
 */
code4(x, r)
{
	codeb(x | r<<4);
}
-h- ASM82.C	Sat Jan 02 18:05:52 1982	_DBB0:ASM82.C;1

/*
 * asm82.c
 * Expressions.
 */
#include <stdio.h>
#include "asm80.h"

/*
 * Read an expression.
 * Return its value.
 * All expressions are evaluated
 * left to right; parentheses
 * may be used to alter the order
 * of evaluation.
 */
expr()
{
	register int c;
	int l, r;

	if(!term(&l))
		return(0);
	while(validop(c=getnb())) {
		if(!term(&r)) {
			err('e');
			return(l);
		}
		switch(c) {

		case '+':
			l += r;
			break;

		case '-':
			l -= r;
			break;

		case '*':
			l *= r;
			break;

		case '%':
			l /= r;
			break;

		case '&':
			l &= r;
			break;

		case '|':
			l |= r;
		}
	}
	putback(c);
	return(l);
}

/*
 * Check for valid arithmetic
 * operators.
 */
validop(c)
{
	switch(c) {

	case '+':
	case '-':
	case '*':
	case '%':
	case '&':
	case '|':
		return(1);

	default:
		return(0);
	}
}

/*
 * Get a term.
 * Store its value in the
 * indicated place.
 * Return true if a term is
 * found.
 * If no term is found no
 * characters are read and
 * false is returned.
 */
term(vp)
int *vp;
{
	register struct sym *sp;
	register int c;
	char id[NCPS];

	/*
	 * Number.
	 */
	if((c=getnb())>='0' && c<='9') {
		*vp = getnum(c);
		return(1);

	/*
	 * Id.
	 */
	} else if(alpha(c)) {
		getid(c, id);
		sp = lookup(id, ust);
		if(sp->s_type == S_UND)
			err('u');
		*vp = sp->s_value;
		return(1);

	/*
	 * Unary ops.
	 */
	} else if(c=='-' || c=='!') {
		if(!term(vp)) {
			err('e');
			return(0);
		} else if(c == '-')
			*vp = -*vp;
		else
			*vp = ~*vp;

	/*
	 * Parentheses.
	 */
	} else if(c == '(') {
		*vp = expr();
		if(getnb() != ')')
			err('(');
		return(1);

	/*
	 * Character constant.
	 */
	} else if(c == '\'') {
		*vp = getmap();
		if(getnb() != '\'')
			err('\'');
		return(1);

	/*
	 * None.
	 */
	} else {
		putback(c);
		return(0);
	}
}
-h- ASM83.C	Sat Jan 02 18:05:52 1982	_DBB0:ASM83.C;1

/*
 * asm83.c
 * Lex.
 */
#include <stdio.h>
#include "asm80.h"

/*
 * Get the next non white
 * character.
 */
getnb()
{
	register int c;

	while((c=getraw())==' ' || c=='\t');
	return(c);
}

/*
 * Get next character from
 * the input.
 * Apply string mappings.
 */
getmap()
{
	register int n, c, v;

	if((c=getraw()) == '\\')
		switch(c = getraw()) {

		case 'n':
			c = '\n';
			break;

		case 'r':
			c = '\r';
			break;

		case 't':
			c = '\t';
			break;

		case 'b':
			c = '\b';
			break;

		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
			v = n = 0;
			while(++n<=3 && c>='0' && c<='7') {
				v = 8*v + c - '0';
				c = getraw();
			}
			putback(c);
			c = v;
			break;

		default:
			putback(c);
			c = '\\';
		}
	return(c);
}

/*
 * Get next character.
 * Basic routine.
 * Don't screw up on end of
 * line.
 */
getraw()
{
	register int c;

	if((c = *sptr) != '\0')
		++sptr;
	return(c);
}

/*
 * Check for alpha.
 */
alpha(c)
register int c;
{
	if(c=='.' || c=='_' || (c>='a' && c<='z') || (c>='A' && c<='Z'))
		return(1);
	return(0);
}

/*
 * Put a character back.
 * A line at a time version
 * of ungetc.
 * Die if too many characters
 * are put back.
 */
putback(c)
{
	if(c != '\0')
		if(--sptr < sbuf)
			abort();
}

/*
 * Read in an indentifier.
 * Store it (padded with nulls) into the
 * supplied buffer.
 */
getid(c, id)
register int c;
char *id;
{
	register char *p;

	p = id;
	while(alpha(c) || (c>='0' && c<='9')) {
		if(p < &id[NCPS])
			*p++ = c;
		c = getraw();
	}
	while(p < &id[NCPS])
		*p++ = '\0';
	putback(c);
}

/*
 * Read numbers.
 * Trailing period means decimal.
 * Otherwise hex.
 */
getnum(c)
register int c;
{
	register int v, hexseen;
	int hex, dec, decseen, oct;

	hex = dec = oct = hexseen = decseen = 0;
	while((v=digvalue(c)) >= 0) {
		hex = 16*hex + v;
		dec = 10*dec + v;
		oct = 8*oct + v;
		if(v > 9)
			++hexseen;
		if(v > 7)
			++decseen;
		c = getraw();
	}
	if(c == 'q') {
		if(decseen)
			err('n');
		return(oct);
	} else if(c == 'h') {
		return(hex);
	} else {
		if(hexseen)
			err('n');
		putback(c);
		return(dec);
	}
}

/*
 * Return the numeric value
 * of a character (0 to 15) or
 * -1 if bad.
 */
digvalue(c)
register int c;
{
	if(c>='0' && c<='9')
		return(c-'0');
	if(c>='a' && c<='f')
		return(c-'a'+10);
	if(c>='A' && c<='F')
		return(c-'A'+10);
	return(-1);
}

/*
 * Lookup id.
 * The table is either the pst or
 * the ust.
 * Failure in the pst returns
 * NULL; failure in the ust adds
 * a symbol.
 */
struct sym *
lookup(id, stp)
char *id;
register struct sym *stp;
{
	register struct sym *tmp1, *tmp2;
	int s;

	if(stp == pst) {
		while(stp < pptr) {
			if(comp(id,stp->s_name)==0) return(stp);
			stp++;
		}
	return(NULL);
	}
	
	while ((s=comp(id,stp->s_name)) >= 0) {
		if (s == 0) {
			refgen(stp,lineno);
			return(stp);
		}
		stp++;
	}
	if (uptr >= &ust[USERMAX]) {
		fprintf(stderr,"Symbol Tabel Overflow!\n");
		exit(1);
	}
	for (tmp1 = ++uptr; tmp1 > stp;) {
		tmp2 = tmp1--;
		copy (tmp2->s_name, tmp1->s_name, NCPS);
		tmp2->s_type = tmp1->s_type;
		tmp2->s_flag = tmp1->s_flag;
		tmp2->s_ref = tmp1->s_ref;
		tmp2->s_value = tmp1->s_value;
	}
	copy (stp->s_name, id, NCPS);
	stp->s_type = S_UND;
	stp->s_flag = 0;
	stp->s_ref = NULL;
	stp->s_value = 0;
	refgen(stp,lineno);
	++symcnt;
	return(stp);
}

/*
 * Record a reference for the symbol
 */
refgen(stp, iline)
register struct sym *stp;
register int iline;
{
	if (pass!=1) return;
	if (refptr >= &reftab[REFMAX]) {
		fprintf(stderr,"Reference Table Overflow!\n");
		exit(1);
	}
	refptr->r_chain = stp->s_ref;
	refptr->r_stmtno = iline;
	stp->s_ref = refptr++;
	++refcnt;
	return;
}

/*
 * Compare two names.
 * return integer >0 if a1 > a2
 *                =0 if a1 = a2
 *                <0 if a1 < a2
 */
comp(a1,a2)
register char *a1, *a2;
{
	register int c1,c2;
	int i;

	for (i=1; i <= NCPS; i++)
		if((c1= *a1++) != (c2= *a2++)) return (c1-c2);
	return(0);
}

/*
 * Copy strings
 */
copy(s1,s2,len)
register char *s1, *s2;
register int len;
{
	while (len-- > 0) *s1++ = *s2++;
	return;
}
-h- ASM84.C	Sat Jan 02 18:05:52 1982	_DBB0:ASM84.C;1

/*
 * asm84.c
 * Code and listing.
 */
#include <stdio.h>
#include "asm80.h"

/*
 * Output code byte.
 * Save it in the per line
 * buffer for outlisting.
 * Update dot.
 */
codeb(b)
{
	b &= 0377;
	if(cptr < &cbuf[CLMAX])
		*cptr++ = b;
	else
		err('z');
	if(pass && !nflag) {
		if(crec>=CBMAX || cadr+crec!=dot->s_value) {
			cflush(0);
			cadr = dot->s_value;
		}
		crbf[crec++] = b;
	}
	++dot->s_value;
}

/*
 * Output a word.
 * Low then high.
 */
codew(w)
{
	codeb(w);
	codeb(w>>8);
}

/*
 * Signal error.
 * Add it to the error buffer
 * if not already there.
 */
err(c)
{
	register char *p;

	p = ebuf;
	while(p < eptr)
		if(*p++ == c)
			return;
	if(p >= &ebuf[ERRMAX])
		abort();
	*p++ = c;
	eptr = p;
}

/*
 * Format a line for the
 * listing.
 * More work than you would
 * think.
 * Only called if -l.
 */
outlisting()
{
	register int nbytes;
	register char *cp;
	int w1, w2, w3;

	if(listmode == NLIST)
		return;
	for(cp = eptr; cp < &ebuf[ERRMAX]; *cp++ = ' ');
	if(listmode == SLIST)
		fprintf(lst, "%10s      ", ebuf);
	else
		fprintf(lst, "%10s %04x ", ebuf, listaddr);
	if(listmode == ALIST)
		fprintf(lst, "%9s%6d %s\n", "", lineno, sbuf);
	else {
		nbytes = cptr-cbuf;
		w1 = cbuf[0]&0377;
		w2 = cbuf[1]&0377;
		w3 = cbuf[2]&0377;
		switch(nbytes) {

		case 0:
			fprintf(lst, "%9s", "");
			break;

		case 1:
			fprintf(lst, "%02x%7s", w1, "");
			break;

		case 2:
			fprintf(lst, "%02x %02x%4s", w1, w2, "");
			break;

		default:
			fprintf(lst, "%02x %02x %02x ", w1, w2, w3);
		}
		fprintf(lst, "%6d %s\n", lineno, sbuf);
		cp = &cbuf[3];
		while((nbytes -= 3) > 0) {
			fprintf(lst, "%16s", "");
			switch(nbytes) {

			case 1:
				w1 = cp[0]&0377;
				fprintf(lst, "%02x\n", w1);
				break;

			case 2:
				w1 = cp[0]&0377;
				w2 = cp[1]&0377;
				fprintf(lst, "%02x %02x\n", w1, w2);
				break;

			default:
				w1 = cp[0]&0377;
				w2 = cp[1]&0377;
				w3 = cp[2]&0377;
				fprintf(lst, "%02x %02x %02x\n", w1, w2, w3);
			}
			cp += 3;
		}
	}
}

/*
 * Write errors to the tty.
 */
outerrors()
{
	register char *p;

	p = ebuf;
	while(p < eptr)
		printf("%c %04d\n", *p++, lineno);
}

/*
 * Flush the binary code
 * buffer.
 * J. Morse Z-80 Format
 * The lf flag, if true, says that
 * this is the last line.
 */
cflush(lf)
{
	register int i;

	if(crec == 0)
		return;
	fprintf(obj, "^%04x/", cadr);
	for(i=0; i<crec; ++i)
		fprintf(obj, "%02x", crbf[i]&0377);
		fprintf(obj, "\n");
	crec = 0;
}

/*
 * Print out the symbol table to Listing
 */
symprt()
{
	register struct sym *stp;
	register struct reflst *ref;
	struct reflst *ref1, *ref2;
	int i,r;
	char c1;

	fprintf(lst,"\14\n");
	for (stp=ust; stp < uptr; stp++) {
		if (stp->s_flag && SF_ASG) c1='='; else c1=' ';
		fprintf(lst,"\t%-8s    %c %04x    ",stp->s_name,c1,stp->s_value);
		ref1 = stp->s_ref;
		ref = NULL;
		while (ref1!=NULL) {
			ref2=ref1;
			ref1=ref1->r_chain;
			ref2->r_chain=ref;
			ref=ref2;
		}
		i=LREFMAX;
		while (ref!=NULL) {
			r=ref->r_stmtno;
			if(r<0) {
				r = -r;
				c1 = '#';
			} else c1 = ' ';
			fprintf(lst,"%5d%c",r,c1);
			ref=ref->r_chain;
			i--;
			if (!i && ref!=NULL) {
				fprintf(lst,"\n\t\t\t      ");
				i=LREFMAX;
			}
		}
		fprintf(lst,"\n");
	}
	fprintf(lst,"\n%6d Symbols\n%6d References\n",symcnt,refcnt);
	return;
}
-h- ASM85.C	Sat Jan 02 18:05:52 1982	_DBB0:ASM85.C;1

/*
 * asm85.c
 * Tables.
 */
#include <stdio.h>
#include "asm80.h"

/*
 * Assorted variables.
 */
int	listmode;		/* Listing control */
int	listaddr;		/* Listing control */
int	entaddr;		/* Entry address */
FILE	*src;			/* Source */
FILE	*lst;			/* Listing */
FILE	*obj;			/* Object */
int	lflag;			/* -l flag */
int	nflag;			/* -n flag */
int	pass;			/* Which pass? */
int	lineno;			/* Line number */
char	*sptr;			/* Source pointer */
char	sbuf[SRCMAX];		/* Source buffer */
char	*cptr;			/* Listing code pointer */
char	cbuf[CLMAX];		/* Listing code buffer */
char	*eptr;			/* Error pointer */
char	ebuf[ERRMAX];		/* Error buffer */
int	cadr;			/* Object address */
int	crec;			/* Object index */
char	crbf[CBMAX];		/* Object buffer */
int	symcnt	1;		/* Symbol counter */
int	refcnt	0;		/* Reference counter */

/*
 * Reference table
 */
struct reflst reftab[REFMAX];

/*
 * User symbol table.
 * The first item must be '.'.
 * The next symbol is a dummy guaranteed to collate higher
 * than any "real" symbol.
 */
struct sym ust[USERMAX] = {
	".",		S_ABS,		SF_ASG,	NULL,	0,
	"~~~~~~~~",	0,		0,	NULL,	0
};

/*
 * Opcode table.
 * Also contains pseudo operations and
 * registers.
 */
struct sym pst[] = {
	"b",		S_REG,		0, NULL, 0,
	"c",		S_REG,		0, NULL, 1,
	"d",		S_REG,		0, NULL, 2,
	"e",		S_REG,		0, NULL, 3,
	"h",		S_REG,		0, NULL, 4,
	"l",		S_REG,		0, NULL, 5,
	"m",		S_REG,		0, NULL, 6,
	"a",		S_REG,		0, NULL, 7,
	"bc",		S_REGP,		0, NULL, 0,
	"de",		S_REGP,		0, NULL, 1,
	"hl",		S_REGP,		0, NULL, 2,
	"sp",		S_REGP,		0, NULL, 3,
	"psw",		S_REGP,		0, NULL, PSW,
	".entry",	S_ENTRY,	0, NULL, 0,
	"db",		S_BYTE,		0, NULL, 0,
	".byte",	S_BYTE,		0, NULL, 0,
	"dw",		S_WORD,		0, NULL, 0,
	".word",	S_WORD,		0, NULL, 0,
	".ascii",	S_ASCII,	0, NULL, 0,
	".asciz",	S_ASCIZ,	0, NULL, 0,
	"ds",		S_BLKB,		0, NULL, 0,
	".blkb",	S_BLKB,		0, NULL, 0,
	"pchl",		S_OP1,		0, NULL, 0351,
	"ret",		S_OP1,		0, NULL, 0311,
	"rc",		S_OP1,		0, NULL, 0330,
	"rnc",		S_OP1,		0, NULL, 0320,
	"rz",		S_OP1,		0, NULL, 0310,
	"rnz",		S_OP1,		0, NULL, 0300,
	"rm",		S_OP1,		0, NULL, 0370,
	"rp",		S_OP1,		0, NULL, 0360,
	"rpe",		S_OP1,		0, NULL, 0350,
	"rpo",		S_OP1,		0, NULL, 0340,
	"xchg",		S_OP1,		0, NULL, 0353,
	"sphl",		S_OP1,		0, NULL, 0371,
	"cma",		S_OP1,		0, NULL, 0057,
	"daa",		S_OP1,		0, NULL, 0047,
	"rlc",		S_OP1,		0, NULL, 0007,
	"rrc",		S_OP1,		0, NULL, 0017,
	"ral",		S_OP1,		0, NULL, 0027,
	"rar",		S_OP1,		0, NULL, 0037,
	"xthl",		S_OP1,		0, NULL, 0343,
	"ei",		S_OP1,		0, NULL, 0373,
	"di",		S_OP1,		0, NULL, 0363,
	"stc",		S_OP1,		0, NULL, 0067,
	"cmc",		S_OP1,		0, NULL, 0077,
	"nop",		S_OP1,		0, NULL, 0000,
	"hlt",		S_OP1,		0, NULL, 0166,
	"in",		S_OP2,		0, NULL, 0333,
	"out",		S_OP2,		0, NULL, 0323,
	"adi",		S_OP2,		0, NULL, 0306,
	"aci",		S_OP2,		0, NULL, 0316,
	"sui",		S_OP2,		0, NULL, 0326,
	"sbi",		S_OP2,		0, NULL, 0336,
	"ani",		S_OP2,		0, NULL, 0346,
	"xri",		S_OP2,		0, NULL, 0356,
	"ori",		S_OP2,		0, NULL, 0366,
	"cpi",		S_OP2,		0, NULL, 0376,
	"mvi",		S_OP3,		0, NULL, 0006,
	"mov",		S_OP4,		0, NULL, 0100,
	"ldax",		S_OP5,		0, NULL, 0012,
	"stax",		S_OP5,		0, NULL, 0002,
	"dad",		S_OP6,		0, NULL, 0011,
	"inx",		S_OP6,		0, NULL, 0003,
	"dcx",		S_OP6,		0, NULL, 0013,
	"push",		S_OP7,		0, NULL, 0305,
	"pop",		S_OP7,		0, NULL, 0301,
	"rst",		S_OP8,		0, NULL, 0307,
	"add",		S_OP9,		0, NULL, 0200,
	"sub",		S_OP9,		0, NULL, 0220,
	"adc",		S_OP9,		0, NULL, 0210,
	"sbb",		S_OP9,		0, NULL, 0230,
	"ana",		S_OP9,		0, NULL, 0240,
	"xra",		S_OP9,		0, NULL, 0250,
	"ora",		S_OP9,		0, NULL, 0260,
	"cmp",		S_OP9,		0, NULL, 0270,
	"inr",		S_OP9,		0, NULL, 0004,
	"dcr",		S_OP9,		0, NULL, 0005,
	"lxi",		S_OP10, 	0, NULL, 0001,
	"jpo",		S_OP11,		0, NULL, 0342,
	"jpe",		S_OP11,		0, NULL, 0352,
	"jm",		S_OP11,		0, NULL, 0372,
	"jp",		S_OP11,		0, NULL, 0362,
	"jnz",		S_OP11,		0, NULL, 0302,
	"jz",		S_OP11,		0, NULL, 0312,
	"jnc",		S_OP11,		0, NULL, 0322,
	"jc",		S_OP11,		0, NULL, 0332,
	"cpo",		S_OP11,		0, NULL, 0344,
	"cpe",		S_OP11,		0, NULL, 0354,
	"cm",		S_OP11,		0, NULL, 0374,
	"cp",		S_OP11,		0, NULL, 0364,
	"cnz",		S_OP11,		0, NULL, 0304,
	"cz",		S_OP11,		0, NULL, 0314,
	"cnc",		S_OP11,		0, NULL, 0324,
	"cc",		S_OP11,		0, NULL, 0334,
	"call",		S_OP11,		0, NULL, 0315,
	"jmp",		S_OP11,		0, NULL, 0303,
	"lda",		S_OP11,		0, NULL, 0072,
	"sta",		S_OP11,		0, NULL, 0062,
	"lhld",		S_OP11,		0, NULL, 0052,
	"shld",		S_OP11,		0, NULL, 0042
};

/*
 * Pointers to the end of the
 * tables.
 * Must be here!
 */
struct sym *pptr &pst[sizeof(pst)/sizeof(pst[0])]; /* Ditto */
struct sym *uptr &ust[1];	/* Pointer to end of ust */
struct reflst *refptr &reftab[0]; /* Pointer to end of reference table */
                                                                                                                                                                                                             