Program Scribe;
(*SCRIBE.PAS--Lists all of one or more source files. *)

Const
  maxnbr	= 32500;   (*Maximum number of lines to be printed*)
  nbrsize	= 5;   (*Number of digits in maxnbr*)

Label 10;

Type
  Namerecord	= Packed Array [1..14] of char;   (*This holds the physical file name*)

Var
  pagelength	: Integer;   (*Number of lines to be printed on a page*)
  topmargin	: Integer;   (*Number of unused lines at top of page*)
  bottommargin	: Integer;   (*Number of unused lines at bottom of page*)
  name		: namerecord;  (*Array to hold physical file name*)
  f		: Text;   (*Logical file name to be printed*)
  p,dir		: Text;   (*Logical file name for printer*)
 
  fac		: Text; (*Logical file name of the file containing format data*)
  len		: Integer;   (*Tells if file exists*)

		(**********  OPENFILE  **********)

Procedure openfile(Var name : Namerecord);
(*This procedure takes the physical file name from keyboard and links it to 
the logical file name, ie, opens the desired file*)

  Label 5;
  
  Var
    i,count	: Integer;

  Begin
    rewrite(dir,'DK0:DIR.DAT');
5:  repeat
	For i := 1 to 14 do
	   name[i] := ' ';
	write('Enter device, filename and extension: ');
       count := 0;
       while NOT eoln do
          begin
		count := succ(count);
		If count > 14 then
		   begin
			writeln('File name is too large  ');
			readln;
			goto 5
		   end;
		read(name[count]);
          end;
    writeln(dir,name);
    readln;
  Until name[1] = ' ';
  close(dir)
End;     (*Openfile*)

		(**********  PRINTLINES  **********)

Procedure printlines(Var f : Text;Var name : Namerecord);

Label 10;

Var
  linenbr	: Integer;   (*Line numbers*)
  k		: Integer;   (*Counts lines*)
  pagenbr	: Integer;   (*Page numbers*)
  i		: Integer;   (*Counter*)
  ch		: Char;
  len		: Integer;   (*File flag*)
  mo,da,yr	: Integer;   (*Date*)

Procedure idate(Var mo,da,yr : Integer); Fortran;

Begin
  idate(mo,da,yr);
  rewrite(p,'LP:');
  reset(dir,'DK0:DIR.DAT');
  while NOT eof(dir) do
     begin
	linenbr := 1;
	pagenbr := 1;
	k := 1;
	i := 0;
	Repeat   (*Try twice to open a file*)
	   readln(dir,name);
	   If name[1] = ' ' then goto 10;
	   reset(f,name,'PAS',len);
	   i := succ(i);
	Until (i = 2) or (len > -1);
	If len = -1 then
	   begin
		write('No file opened');
		goto 10
	   end;
	For i := 1 to topmargin do   (*Line feeds for top margin*)
	   writeln(p);
	writeln(p,name,'                    ',mo:1,'/',da:1,'/',yr:1,(*Heading*)
			'                              Page # ',pagenbr:3);
	while NOT eof(f) do   (*Print until EOF or until maximum line
							 number is reached*)
	   begin
		write(p,linenbr:4,'    ');   (*Line numbers*)
		while NOT eoln(f) do   (*Read a line of text*)
		   begin
			read(f,ch);   (*Read a character*)
			write(p,ch)   (*Print a character*)
		   end;
		readln(f);   (*Go to next line of file*)
		writeln(p);   (*Go to next line of printer*)
		If ((k MOD pagelength) = 0) and NOT eof(f) then   (*Go to top of the
		 next page after printing the number of lines in page length*)
		   begin
			For i := 1 to bottommargin - 1 do   (*Line feed for
								bottom margin*)
				writeln(p);
			writeln(p,name,'                    ',mo:1,'/',da:1,'/',yr:1,   (*Heading*)
				'                              Page # ',pagenbr:3);
			pagenbr := succ(pagenbr);
			For i := 1 to topmargin do  (*Line feed for top margin*)
				writeln(p);
		writeln(p,name,'                    ',mo:1,'/',da:1,'/',yr:1,(*Heading*)
				'                              Page # ',pagenbr:3);
		   end;
		If eof(f) then   (*After finishing the listing go to
							 top of next page*)
		   begin
			If k MOD pagelength = 0 then
			   For i := 1 to bottommargin - 1 do
				writeln(p)
			else
			   begin
				k := k MOD pagelength;   (*If you are beyond
					the first page then divide the last line
					number by the page length and the
					remainder is the number of lines used
					on the last page*)
				For i:= k + 1 to pagelength + bottommargin -1 do
				    (*Move from last line on last page to top of
								next page*)
	   			   writeln(p)
	   		   end;
		writeln(p,name,'                    ',mo:1,'/',da:1,'/',yr:1,(*Heading*)
				'                              Page # ',pagenbr:3)
		   end;
		linenbr := succ(linenbr);
		k := succ(k)
	   end;
     end;
  close(p);
10: End;     (*Printlines*)
		(**********  MAIN PROGRAM  **********)

Begin
  reset(fac,'DK0:FAC','.DAT',len);
  If len = -1 then   (*If file fac does not exist program aborts*)
     begin
	writeln('Format data file does not exist.  Run FACE program!');
	readln;
	goto 10
     end;
  readln(fac,topmargin);
  readln(fac,pagelength);
  readln(fac,bottommargin);
  openfile(name);     (*Opens file*)
  printlines(f,name);     (*Prints the file*)
  close(fac);
10: close(f)
 End.     (*Main*)
                                                                                                                                                                            