C******************************************************************************
C
C      Neither First Chicago Corporation, the First National Bank of Chicago,
C nor any of its employees makes any warranty, either expressed or implied,
C assumes any legal liability, nor any responsibility for the accuracy,
C completeness or usefulness of any information, product or process disclosed.
C Neither does First Chicago Corportion, the First National Bank of Chicago,nor
C any of its employees represent that use of this material would not infringe
C privately owned rights.
C
C******************************************************************************
C
C
C
C	FSALEN.FOR   MAIN PROGRAM FOR FINDING THE LENGTH OF FSA FILES
C
C **********************************************************************
C ***********************************************************************
C
C WRITTEN BY:  SHERMAN TODD, DOUGLAS BOHRER
C	   PERSONNEL DEPARTMENT, THE FIRST NATIONAL BANK OF CHICAGO
C	   1 FIRST NATIONAL PLAZA, 22ND FLOOR
C	   CHICAGO, ILLINOIS 60670
C
C DATE:	       17-MAR-81
C
C PURPOSE:  THIS PROGRAM COUNTS THE NUMBER OF RECORDS IN A FORTRAN
C           SEQUENTIAL ASCII(FSA) INPUT FILE AND STORES THE RESULT
C           IN AN APL READ FILE.  EACH RECORD IS EXAMINED A CHARACTER
C           AT A TIME UNTIL THE END-OF-FILE IS REACHED.  THE NUMBER
C           OF RECORDS READ IS THEN WRITTEN TO THE OUTPUT FILE AND
C           ALL FILES ARE CLOSED.
C           THE NAME OF THE APL VARIABLE WITH THE LENGTH IS LEN.
C           FROM APL, )READ OUTPUT FILE TO GET THE FILE LENGTH.
C
C ***********************************************************************
C
	LOGICAL*1  IFILE(14),OFILE(14),IREC(2048),CNTRLZ,NULEND
C
C FORMATS USED IN THE PROGRAM
C
  510	FORMAT(14A1)
  520	FORMAT(I3)
  530	FORMAT(255A1,145A1,112A1)
  550	FORMAT(' len_',F12.0)
C
C SYSTEM PROMPTS TO THE USER
C
	TYPE *, ' INPUT FILE NAME?'
	READ(5,510) (IFILE(I),I=1,14)
	OPEN(UNIT=1,NAME=IFILE,ACCESS='SEQUENTIAL',FORM='FORMATTED',
	1TYPE='OLD')
	TYPE *, ' INPUT RECORD LENGTH?'
	READ(5,520) LENREC
	TYPE *, ' OUTPUT FILE NAME?'
	READ(5,510) (OFILE(I),I=1,14)
	OPEN(UNIT=2,NAME=OFILE,ACCESS='SEQUENTIAL',FORM='FORMATTED',
	1TYPE='NEW')
C
C INITIALIZE THE RECORD COUNTER
C
	NRECS=0
C
C READ THE NEXT INPUT RECORD.  IF THERE IS AN END-OF-FILE CONDITION
C GO TO STATEMENT 999.
C
  600	READ(1,530,END=999) (IREC(I),I=1,LENREC)
C
C RESET THE LOGICAL VARIABLES:  NULEND AND CNTRLZ.
C
	NULEND=.TRUE.
	CNTRLZ=.FALSE.
C
C IN THIS LOOP, SEARCH THE CURRENT RECORD TO DETERMINE IF EITHER ALL
C OF ITS CHARACTERS ARE NULLS OR ONE OF ITS CHARACTERS IS A CONTROL Z.
C THESE TESTS ARE USED TO HELP DETERMINE IF THE END-OF-FILE HAS BEEN
C REACHED.
C
	DO 650, II=1,LENREC
	CNTRLZ=CNTRLZ.OR.IREC(II).EQ.26
  	NULEND=NULEND.AND.(IREC(II).EQ.0) 
  650	CONTINUE
C
C IF THE END-OF-FILE HAS NOT BEEN REACHED THEN INCREMENT THE RECORD
C COUNTER AND BRANCH TO READ THE NEXT RECORD.
C
	IF(.NOT.(NULEND.OR.CNTRLZ)) NRECS=NRECS+1
	IF(.NOT.(NULEND.OR.CNTRLZ)) GO TO 600
C
C ELSE, THE END-OF-FILE HAS BEEN REACHED SO TYPE A MESSAGE INDICATING 
C THIS AND TYPE OUT THE NUMBER OF RECORDS ON THE FILE.  NOW WRITE
C THIS  VALUE OUT TO THE OUTPUT FILE AND CLOSE ALL OPENED FILES.
C
  999	TYPE *, '***END-OF-FILE***'
 1000	TYPE *, NRECS
	RECS=NRECS
	WRITE(2,550) RECS
	CLOSE(UNIT=1,DISP='SAVE')
	CLOSE(UNIT=2,DISP='SAVE')
	STOP
	END
                                                                                                                       