	PROGRAM T3D
C
C	THIS PROGRAM TESTS THE NEW DIGLIB 3D TRANSFORMATIONS
C
	DIMENSION XLIM(2), YLIM(2), ZLIM(2), CAMPOS(3)
C
	CALL SELDEV(4)
	NSPIR = 5	!NUMBER OF SPIRALS
	NPPS = 50	!NUMBER OF POINTS PER SINGLE SPIRAL
	TWOPI = 2.0*3.14159265
	DTHETA = TWOPI/NPPS
	XLIM(1) = -1.0
	XLIM(2) = 1.0
	YLIM(1) = -1.0
	YLIM(2) = 1.0
	ZLIM(1) = 0.0
	ZLIM(2) = NSPIR*NPPS*DTHETA
C
	TYPE 11
11	FORMAT('$Enter CAMERA positioning option: ')
	ACCEPT 12, IOPTNS
12	FORMAT(I5)
	GOTO (20,30,40) IOPTNS+1
20	TYPE 21
21	FORMAT('$Enter CAMERA position: ')
	GOTO 50
30	TYPE 31
31	FORMAT('$Enter CAMERA dx,dy,dz: ')
	GOTO 50
40	TYPE 41
41	FORMAT('$Enter CAMERA dr,theta,phi: ')
50	ACCEPT 51, CAMPOS
51	FORMAT(3F14.0)
	TYPE 52
52	FORMAT('$Enter X and Y axis ratios: ')
	ACCEPT 51, XRATIO, YRATIO
	TYPE 53
53	FORMAT('$Enter X0 and Y0: ')
	ACCEPT 51, X0,Y0
	TYPE 54
54	FORMAT('$Enter WIDTH and HEIGHT: ')
	ACCEPT 51, WIDTH,HEIGHT
	IF (WIDTH .EQ. 0) WIDTH = GSXLCM()
	IF (HEIGHT .EQ. 0) HEIGHT = GSYLCM()
	CALL VIEW3D(XLIM,YLIM,ZLIM,CAMPOS,XRATIO,YRATIO,X0,Y0,
	1	WIDTH,HEIGHT,IOPTNS,IERR)
	IF (IERR .NE. 0) GO TO 900
C
	CALL BGNPLT
C
C	DRAW THE RECTANGULAR-PARALELA-PIPED
C
C AROUND THE BOTTOM
	CALL SCAL3D(XLIM(1),YLIM(1),ZLIM(1),VX,VY,IERR)
	CALL GSMOVE(VX,VY)
	CALL SCAL3D(XLIM(1),YLIM(2),ZLIM(1),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
	CALL SCAL3D(XLIM(2),YLIM(2),ZLIM(1),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
	CALL SCAL3D(XLIM(2),YLIM(1),ZLIM(1),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
	CALL SCAL3D(XLIM(1),YLIM(1),ZLIM(1),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
C UP TO, AND AROUND THE TOP
	CALL SCAL3D(XLIM(1),YLIM(1),ZLIM(2),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
	CALL SCAL3D(XLIM(1),YLIM(2),ZLIM(2),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
	CALL SCAL3D(XLIM(2),YLIM(2),ZLIM(2),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
	CALL SCAL3D(XLIM(2),YLIM(1),ZLIM(2),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
	CALL SCAL3D(XLIM(1),YLIM(1),ZLIM(2),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
C NOW THE OTHER VERTICAL LINES
	CALL SCAL3D(XLIM(1),YLIM(2),ZLIM(1),VX,VY,IERR)
	CALL GSMOVE(VX,VY)
	CALL SCAL3D(XLIM(1),YLIM(2),ZLIM(2),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
	CALL SCAL3D(XLIM(2),YLIM(2),ZLIM(1),VX,VY,IERR)
	CALL GSMOVE(VX,VY)
	CALL SCAL3D(XLIM(2),YLIM(2),ZLIM(2),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
	CALL SCAL3D(XLIM(2),YLIM(1),ZLIM(1),VX,VY,IERR)
	CALL GSMOVE(VX,VY)
	CALL SCAL3D(XLIM(2),YLIM(1),ZLIM(2),VX,VY,IERR)
	CALL GSDRAW(VX,VY)
C ALL DONE
C
C	NOW DRAW THE SPIRALS
C
	X = COS(0.0)
	Y = SIN(0.0)
	Z = 0.0
	CALL SCAL3D(X,Y,Z,VX,VY,IERR)
	CALL GSMOVE(VX,VY)
	DO 100 I=1,NSPIR*NPPS
	  THETA = I*DTHETA
	  X = COS(THETA)
	  Y = SIN(THETA)
	  Z = THETA
	  CALL SCAL3D(X,Y,Z,VX,VY,IERR)
	  CALL GSDRAW(VX,VY)
100	CONTINUE
	CALL ENDPLT
800	CONTINUE
	CALL RLSDEV
	STOP
900	TYPE 901
901	FORMAT(' Sorry, part of scene is behind the camera!')
	GOTO 800
	END
                                                                                                                                                                                                                      