	SUBROUTINE AXIS(BLOW,BHIGH,MAXTKS,LSHORT,LRAGGD,BMIN,BMAX,
	1   BTMIN,BTMAX,BTICK,IPWR)
	LOGICAL*1 LSHORT, LRAGGD
C
C	THIS SUBROUTINE IS MAINLY FOR INTERNAL USE,
C	ITS FUNCTION IS TO DETERMINE A SUITABLE
C	"TICK" DISTANCE OVER THE RANGE SPECIFIED BETWEEN
C	ALOW AND AHIGH.   IT OUTPUTS THE AXIS RANGE BMIN,BMAX
C	AND THE TICK DISTANCE BTICK STRIPPED OF THEIR POWER OF
C	TEN.   THE POWER OF TEN IS RETURNED IN THE VAR. IPWR.
C
	DIMENSION JTICKS(6)
	LOGICAL LDIVDS
	LOGICAL*1 LISNEG
C
C	IF A RAGGED AXIS IS "TOO CLOSE" TO THE NEXT TICK, THEN EXTEND IT.
C	 THE "TOO CLOSE" PARAMETER IS THE VARIABLE TOOCLS
C
	DATA TOOCLS /0.8/
C
	DATA FUZZ /0.001/
	DATA JTICKS /1,2,5,4,3,10/
	DATA SMLRNG /0.01/
C
C
	TOOBIG = 1.0/SMLRNG
	MAXTKS = MAX0(1,MAXTKS)
	MINTKS = MAX0(1,MAXTKS/2)
	BMAX = BHIGH
	BMIN = BLOW
	LISNEG = .FALSE.
	IF (BMAX .GE. BMIN) GO TO 30
	BMAX = BLOW
	BMIN = BHIGH
	LISNEG = .TRUE.
C
C	MAKE SURE WE HAVE ENOUGH RANGE, IF NOT, INCREASE AHIGH
C
30	RANGE = BMAX - BMIN
	TEMP = AMAX1(ABS(BMIN),ABS(BMAX))
	IF (TEMP .EQ. 0.0) TEMP = 10.0
	IF (RANGE/TEMP .GE. SMLRNG) GO TO 40
		BMIN = BMIN - SMLRNG*TEMP
		BMAX = BMAX + SMLRNG*TEMP
40	CONTINUE
C
C	STRIP THE RANGE OF ITS POWER OF TEN
C
	IPWR=ALOG10(BMAX-BMIN)-2
50	TENX = 10.0**IPWR
	ASTRT = AINT(BMIN/TENX)
	AFIN = AINT(BMAX/TENX+0.999)
	IF (AFIN*TENX .LT. BMAX) AFIN = AFIN + 1
	IF (ABS(AFIN) .GE. TOOBIG .OR. ABS(ASTRT) .GE. TOOBIG) GOTO 70
	RANGE = AFIN - ASTRT
	IF (RANGE .LE. 10*MAXTKS) GO TO 75
70	IPWR = IPWR + 1
	GO TO 50
75	CONTINUE
C
C	SEARCH FOR A SUITABLE TICK
C
D	TYPE 9999, BMIN, ASTRT, BMAX, AFIN, TENX
D9999	FORMAT(/' AXIS DEBUG'/'      DATA          STRIPPED'/
D	1   2(1X,G14.7,2X,G14.7/)/' POWER = ',G14.7)
	BTICK = 0
	DO 100 I=1,6
		TICK = JTICKS(I)
		NTICK = RANGE/TICK+0.999
D	TYPE 9998, I, TICK, NTICK
D9998	FORMAT(/' Try number ',I1/' Tick value is ',F3.0/
D	1   ' Number of ticks is ',I2/)
		IF (NTICK .GT. MAXTKS) GO TO 100
		IF (NTICK .GE. MINTKS .AND.
	1	    LDIVDS(ASTRT,TICK) .AND. LDIVDS(AFIN,TICK)) GO TO 150
		IF (BTICK .EQ. 0) BTICK = TICK
100	CONTINUE
C
C	USE BEST NON-PERFECT TICK
C
	GO TO 160
C
C	FOUND A GOOD TICK
C
150	BTICK=JTICKS(I)
160	CONTINUE
D	TYPE 9997, BTICK
D9997	FORMAT(/' Tick picker chose ',F3.0/)
	IF (BTICK .NE. 10.0) GO TO 165
	  BTICK = 1.0
	  IPWR = IPWR + 1
	  TENX = 10.0*TENX
165	TICK = BTICK*TENX
C
C	FIGURE OUT TICK LIMITS
C
	BTMIN = BTICK*AINT(BMIN/TICK)
	IF (BTMIN*TENX .LT. BMIN) BTMIN = BTMIN + BTICK
	BTMAX = BTICK*AINT(BMAX/TICK)
	IF (BTMAX*TENX .GT. BMAX) BTMAX = BTMAX - BTICK
	NINTVL = (BTMAX-BTMIN)/BTICK
C
C	IF USER ABSOLUTELY MUST HAVE RAGGED AXIS, THEN FORCE IT.
C
	IF (LSHORT .AND. LRAGGD) GO TO 180
C
C	CHECK INDIVIDUALLY
C
	IF (LSHORT .AND. (NINTVL .GT. 0) .AND.
	1   ((BTMIN-BMIN/TENX)/BTICK .LE. TOOCLS) ) GO TO 170
	  IF ((BTMIN-BMIN/TENX) .GT. FUZZ) BTMIN = BTMIN - BTICK
	  BMIN = BTMIN*TENX
170	CONTINUE
	IF (LSHORT .AND. (NINTVL .GT. 0) .AND.
	1   ((BMAX/TENX-BTMAX)/BTICK .LE. TOOCLS) ) GO TO 180
	  IF ((BMAX/TENX-BTMAX) .GT. FUZZ) BTMAX = BTMAX + BTICK
	  BMAX = BTMAX*TENX
180	CONTINUE
	IF (.NOT. LISNEG) GO TO 200
C	SWITCH BACK TO BACKWARDS
	BTICK = -BTICK
	TEMP = BMIN
	BMIN = BMAX
	BMAX = TEMP
	TEMP = BTMIN
	BTMIN = BTMAX
	BTMAX = TEMP
200	RETURN
	END

	FUNCTION LDIVDS(ANUMER,ADENOM)
	LOGICAL LDIVDS
	IF (ANUMER/ADENOM .EQ. AINT(ANUMER/ADENOM)) GO TO 10
	LDIVDS = .FALSE.
	RETURN
10	LDIVDS = .TRUE.
	RETURN
	END
                                                                                        