	FUNCTION FCHISQ (NDATA, X, Y, DY, NMODEL, A)
C
C	Calculate chi-squared for the model FUNCTN (X,A) and
C	the data (X,Y,DY).
C
	DIMENSION X(1), Y(1), DY(1), A(1)
	DOUBLE PRECISION FUNCTN
	EXTERNAL FUNCTN
C
	FCHISQ = 0.
	NFREE = NDATA - NMODEL
	IF (NFREE.LE.0) RETURN
C
	DO 10 I=1, NDATA
	    FCHISQ = FCHISQ+((Y(I)-FUNCTN(X(I),A,NMODEL))/DY(I))**2
10	CONTINUE
C
	FCHISQ = FCHISQ / FLOAT(NFREE)
C
	RETURN
	END
                                                                                   