      subroutine GRID (nax,nay,ixdim,iydim,ixo,iyo,ia,iv,ixgap,iygap,
     &               ixstt,ityn,itxn,iystt,lxoffx,lyoffx,lxoffy,lyoffy,
     &              iszn,insetx,insety,icusiz,length,iyspc,iszct,iszgt)
c
c     is called by PLOT. It specifies the device-dependent co-ordinate
c     grid limits.
c
      iwat='N'
      if (iwat.eq.'Y'.and.nax.gt.0) go to 10  ! A3 paper
      if (iwat.eq.'Y'.and.nax.lt.0) go to 20  ! A4 paper
c---------------------------------------------------------------------
c     These specifications, in 1/72" units, are for the Laserwriter.
c
      ixmax=572	! these limits define A4 paper minus unusable 8mm border
      iymax=816
      ixmin=24
      iymin=24
c
      iv=0
      if (nay.lt.0) iv=1
      nax=iabs(nax)
      nay=iabs(nay)
      ixo=96     ! x-coordinate of origin of axes
      iyo=70     ! y-coordinate of origin of axes
      ixdim=iymax-ixo-10 ! after coordinate frame rotation by 90 degrees
      iydim=ixmax-iyo-30 ! -30 to leave room for the title
      ixgap=70    ! gap to be left between x-axes if side-by-side
      iygap=20    ! gap to be left between y-axes if above each other
      ia=0
      ixstt=10    ! x-inset for start of x-axis title
      ityn=-30    ! y-offset for x-axis title
      itxn=-50    ! x-offset for y-axis title
      iystt=10    ! y-inset for start of y-axis title
      icusiz=2    ! 1 char. unit (= 0.7mm) = 2 points
      lxoffx=-17  ! x-offset for x-axis numbers
      lyoffx=-14  ! y-offset for x-axis numbers
      lxoffy=-39  ! x-offset for y-axis numbers
      lyoffy=-5   ! y-offset for y-axis numbers
      iszn=4      ! size of numbers on axes
      insetx=-150 ! x-inset for start of line sample and curve title
      insety=-10  ! y-inset for start of line sample and curve title
      length=56   ! length of line-identification sample
      iyspc=18    ! vertical spacing of subsequent line samples
      iszct=5     ! size of characters for curve titles
      iszgt=3     ! size of characters for graph title
      if (iv.eq.0) return
c
c     vertical format LaserWriter graph (differences from above)
      ixdim=ixmax-ixo-10
      iydim=iymax-iyo-30
      return
c---------------------------------------------------------------------
c     these are the WAPLOT values, in 0.1mm units, for A3 paper
10    nax=iabs(nax)
      nay=iabs(nay)
      ixo=250
      iyo=150
      ixdim=3100
      iydim=2300
      ixgap=350
      iygap=250
      if (nax.eq.1.and.nay.eq.4) iygap=150
      ixstt=900
      ityn=-80
      itxn=-170
      iystt=200
      iyspc=80
      ia=0
      go to 30
c
c     the following are the values in WAPLOT for horizontal A4 paper
20    iv=0
      if (nay.lt.0) iv=1
      nax=iabs(nax)
      nay=iabs(nay)
      ixo=200
      iyo=120
      ixdim=2600
      iydim=1580
      ixgap=280
      iygap=120
      if (nax.eq.1.and.nay.eq.4) iygap=80
      ixstt=300
      ityn=-60
      itxn=-140
      iystt=120
      iyspc=60
      ia=4
      if (iv.eq.0) go to 30
c
c     A4 vertical paper - differences from horizontal A4 only
      iyo=150
      ixdim=1600
      iydim=2300
      ixgap=160
      iygap=250
      if (nax.eq.1.and.nay.eq.4) iygap=150
c
c     WAPLOT values common to A3 and A4 size plots
30    lxoffx=-50
      lyoffx=-50
      lxoffy=-130
      lyoffy=-15
      iszn=3
      insetx=-410
      insety=-100
      icusiz=7
      length=150
      iszct=3
      iszgt=4
c
      return
      end
                                         