c
c
      function idigts (valmin,valmax,fmt)
c
c	PROG NAME:			IDIGTS.rat
c
c	DATE OF FIRST VERSION:		 3-Jan-83
c	DATE OF CURRENT VERSION:	21-Jun-83
c
c	PURPOSE:	PLTFIL function to determine the number of digits
c			in the largest value between VALMIN and VALMAX,
c			using the format type FMT.
c
c	USAGE:		N = IDIGTS (VALMIN,VALMAX,FMT)
c
c			where  VALMIN = Minimum axis annotation value
c			       VALMAX = Maximum axis annotation value
c				  FMT = ASCIZ string containing format spec
c
c	PROGRAMMER:	Eric Javel
c
c*********************************************************************
c
      bytefmt(1)
      dimensionval(2),ndig(2)
      externalindex
c
c---------------------------------------------------------------------
c
      val(1) = valmin
      val(2) = valmax
c     for
      i=1
23000 if(.not.(i.le.2))goto 23002
         a = val(i)
         n = 1
c See if the value is negative.  If so, bump the digit count
c and make the value positive
         if(.not.(a .lt. 0.))goto 23003
            n = n + 1
            a = -a
c Determine the number of digits in the integer part of the value
23003    continue
c        while
23005    if(.not.(a .ge. 10.))goto 23006
            a = a/10.
            n = n + 1
            goto 23005
c        endwhile
23006    continue
c If floating point, add in the number of digits after the
c decimal point and take the decimal point into account
         j = index (fmt,'.')
         if(.not.(j .ne. 0))goto 23007
            n = n + (fmt(j+1)-"60) + 1
c Remember the total number of digits
23007    continue
         ndig(i) = n
          i=i+1
         goto 23000
c     endfor
23002 continue
      idigts = max0 (ndig(1),ndig(2))
      return
      end
                                                                                                                                                                                                                                                                                      