c		HVPLOT	Part III
c
c	Error Checking, Digitising and Reading Subroutines for HVPLOT
c
c	Dr R N Caffin and S L Hewett
c	CSIRO Div of Textile Physics
c	338 Blaxland Rd
c	Ryde  N S W  2112
c	Australia
c
c	21-Sep-84
c
c
c	Error Checking Subroutines for HVPLOT

	Subroutine CHECK

	include 'HV.INC'

	if(hv)goto 500

c	Error Checking for the HP Plotters
c
	type *,'(OE)'
	write(9,1000)
1000	format('OE')			!Ask for HP-GL errors
	type *,'(sent OE)'
90	call pread(I1,nQ)
	if(nq.eq.0)goto 90
	if(I1.eq.0)goto 100
	type 1010,I1
1010	format(x,'HP-GL Error code: ',I3)
c
100	type *,'(esc.E)'
	write(9,1020) esc
1020	format(A,'.E')			!Ask for RS232C errors
	type *,'(sent esc.E)'
	call pread(I1,nQ)
	if(nq.eq.0)goto 100
	if(I1.eq.0)goto 120
	type 1030,I1
1030	format(x,'RS232C Error code: ',I3)
c
120	type *,'Plotter Status checked OK.'
c
500	return
	end

c	Special READ routine for CHECK

	subroutine Pread(I1,nQ)
c
	rewind 9			!To allow Fortran to read from it
	i=isleep(0,0,0,10)
	read(9,1020,err=150) nQ,I1
1020	format(Q,I6)
	type *,'nQ',nQ
	rewind 9			!Back to write mode
	return
c
150	type *,'Pread error: I1=',I1,' nQ=',nQ
	return
c
	end

c	Digitising routine for Plotter

	Subroutine Digitz(x,y,done)

	include 'HV.INC'
	integer		ix,iy,ip,lastx,lasty
	logical*1	done
	data		lastx,lasty/-32000,-32000/

	rewind 9			!Just in case
	call send('DP')			!Into digitise mode
	type 1000,bell
1000	format('+',a,$)			!Beep the operator

100	rewind 9			!Required for looping from below
	call send('OS')			!Ask for status

110	  rewind 9			!Turn around/jam out
	  i=isleep(0,0,0,10)		!God knows why, but it's needed
	  read(9,1010)nq,i		!Get status
1010	  format(Q,I6)
	  if(nQ.eq.0)goto 110		!Try again if not returned yet

	if((i.and.4).eq.0)goto 100	!Wait till user hits plotter "Enter"

	rewind 9			!Turn around
	call send('OD')			!Send the point values
120	  rewind 9			!Jam out/turn around
	  i=isleep(0,0,0,10)
	  read(9,1020)nq,ix,iy,ip	!Read parameters
1020	  format(Q,3I6)
	  if(nQ.eq.0)goto 120		!If not returned, try again

	done=.false.
	if(lastx.eq.ix.and.lasty.eq.iy)done=.true.
	lastx=ix
	lasty=iy
	x=float(ix-250)*(xmax-xmin)/10000.+xmin		!Now convert to user
	y=float(iy-279)*(ymax-ymin)/7200. +ymin		! scales

	return
	end

c	Plotter READ routines

	subroutine Pread1(I1)		!Read one integer variable
c
10	rewind 9			!To allow Fortran to read from it
	i=isleep(0,0,0,10)
	read(9,1020,err=150) nQ,I1
1020	format(Q,I6)
	if(nQ.eq.0)goto 10		!Check: was data received?
c
100	rewind 9			!Back to write mode
	return
c
150	type *,'Pread1 error: I1=',I1
	goto 100
c
	end

	subroutine Pread2(I1,I2)	!Read two integer variables
c
10	rewind 9			!To allow Fortran to read from it
	i=isleep(0,0,0,10)
	read(9,1020,err=150) nQ,I1,I2
1020	format(Q,2I6)
	type *,'nQ=',nQ
	if(nQ.eq.0)goto 10
100	rewind 9			!Back to write mode
	return
c
150	type *,'Pread2 error: I1,2=',I1,I2
	goto 100
c
	end

	subroutine Pread3(I1,I2,I3)	!Read three integer variables
c
10	rewind 9			!To allow Fortran to read from it
	i=isleep(0,0,0,10)
	read(9,1020,err=100) I1,I2,I3
1020	format(3I6)
	if(nQ.eq.0)goto 10

	rewind 9			!Back to write mode
	return
c
100	type *,'Pread3 error: I1,2,3=',I1,I2,I3
	return
c
	end

	subroutine Pread4(I1,I2,I3,I4)	!Read four integer variables
c
	i=isleep(0,0,0,10)
10	rewind 9			!To allow Fortran to read from it
	i=isleep(0,0,0,10)
	read(9,1020,err=100) I1,I2,I3,I4
1020	format(4I6)
	if(nQ.eq.0)goto 10

	rewind 9			!Back to write mode
	return
c
100	type *,'Pread4 error: I1,2,3,4=',I1,I2,I3,I4
	return
c
	end
                                                                                                                                                                                                                                                                                                                                                                                                                           