/*
 *	detab <file >file
 */

/*)BUILD	$(TKBOPTIONS) = {
			TASK	= ...DET
		}
*/

#ifdef	DOCUMENTATION

title	detab	Replace tabs by blanks
index		Replace tabs by blanks

synopsis

	detab infile outfile

description

	Copies input to output, replacing sequences of tabs
	by a string of blanks (presupposing tabstops every
	8 columns).  Trailing blanks are removed.  If the file
	arguments are missing, the standard input and output
	are used.

diagnostics

	None

author

	Martin Minow

bugs

bugs

	Tabs occur every eight column only.

	On VMS, a file produced when an explicit output file spec is
	provided will be in "C format" (STREAM_LF records).  If you use
	redirection, the output will be variable-length records with
	implied carriage control - which is more easily dealt with in
	many cases.

#endif

#include <stdio.h>
#ifdef vms
#include		<ssdef.h>
#include		<stsdef.h>
#define	IO_SUCCESS	(SS$_NORMAL | STS$M_INHIB_MSG)
#define	IO_ERROR	SS$_ABORT
#endif
/*
 * Note: IO_SUCCESS and IO_ERROR are defined in the Decus C stdio.h file
 */
#ifndef	IO_SUCCESS
#define	IO_SUCCESS	0
#endif
#ifndef	IO_ERROR
#define	IO_ERROR	1
#endif
#define	FALSE	0
#define	TRUE	1
#define	EOS	0
#define	BLANK	' '
#define	TAB	'\t'
#define	NEWLINE	'\n'
#define	FALSE	0
#define	TRUE	1

char	line[513];

main(argc, argv)
char *argv[];
{
	register int	i;
	register char	*lstart;
	register char	*lend;

#ifdef vms
	argc = getredirection(argc,argv);
#endif

	for (i = 1; i < argc; i++) {
	    if (i == 1) {
		if (freopen(argv[i], "r", stdin) == NULL) {
		    perror(argv[i]);
		    exit(IO_ERROR);
		}
	    }
	    else {
		if (freopen(argv[i], "w", stdout) == NULL) {
		    perror(argv[i]);
		    exit(IO_ERROR);
		}
	    }
	}
	while (gets(line) != NULL) {
	    lstart = line;
	    while ((lend = strchr(lstart, TAB)) != NULL) {
		/*
		 * Found a tab.
		 */
		*lend++ = EOS;
		printf("%s", lstart);
		i = 8 - ((lend - lstart - 1) & 07);
		while (--i >= 0)
		    putchar(BLANK);
		lstart = lend;
	    }
	    printf("%s\n", lstart);
	}
}		
                                                                                                                                                                                                                                                                                                                                                                                                                                             