! TMAKLB.COM
!
! Build the RT-11 runtime DECUS C library/OTS
!
! Prepared by:
!		Bob Denny
!		15-SEP-80
! Edit history:
!	05-May-82	Edits for TSX+, new ATOF/DTOA
!
! If you do this all on one disk, you need about 2000. or more blocks
! and room for 400 files in the directory. Therefore, your directory
! must have at least 6. segments in it. Use the INIT/SEG:nn. command.
!
! This command procedure builds either the non-EIS or the EIS library;
! see editing notes below.
!
! You must make the following logical device assignments:
!
!	SR:	Source files.			( 610 blocks )
!	OB:	Temporary object file workspace.( 280 blocks )
!	LS:	Listing output.			( 980 blocks )
!	OU:	Library output.			(  60 blocks )
!
! The library size assignments must be edited to reflect actual system
! sizes.  DO NOT assume that the given sizes will work.
!
! This command file deletes OB:*.OB.  Be sure that is what you want to do.
! Also, you should delete or rename the current versions of SUPORT.OBJ,
! ATOF.OBJ, DTOA.OBJ and CLIB.OBJ (to SUPORT.OLD and CLIB.OLD, for example)
! so that the library build can proceed without problems.  This is especially
! true if SUPORT.OBJ, ATOF.OBJ, DTOA.OBJ and CLIB.OBJ are protected files.
! After completing the library build, you should protect these files.
!
ASSIGN SM4 SR
ASSIGN SM4 OB
ASSIGN NL  LS
ASSIGN SM4 OU
!
DATE
TIME
!
! Assemble the system independent (common) modules
! To assemble an EIS library, change "TCLBAS" to "TCLEIS"
!
@SR:TCLBAS.COM
!
! Assemble the RT-11 specific modules
! To assemble an EIS library, change "RILBAS" to "RILEIS"
!
@SR:TILBAS.COM
!
! SUPORT, ATOF, and DTOA don't go into the library.
!
SET ERROR NONE
DELETE/NOQ OU:SUPORT.OBJ,OU:DTOA.OBJ,OU:ATOF.OBJ
SET ERROR ERROR
COPY/NOLOG OB:SUPORT.OB OU:SUPORT.OBJ
COPY/NOLOG OB:DTOA.OB OU:DTOA.OBJ
COPY/NOLOG OB:ATOF.OB OU:ATOF.OBJ
DELETE/NOQ OB:SUPORT.OB,OB:DTOA.OB,OB:ATOF.OB
!
! Merge all object files and build the library
!
COPY/CONCAT/NOLOG OB:*.OB OB:OTS.TMP
DELETE/NOQ OB:*.OB
R LIBR
OU:CLIB=OB:OTS.TMP
^C
DELETE/NOQ OB:OTS.TMP
!
DATE
TIME
!
! Library build complete -- it is recommended that you RENAME/PROTECT
! ATOF.OBJ, DTOA.OBJ, CLIB.OBJ and SUPORT.OBJ.
!
                                                                                                                                                                                                                                                                                                                       