/********************************************************************************/
/*				*************					*/
/*				*  Y 1 . H  *					*/
/*				*************					*/
/*										*/
/*  This file contains the external declarations needed to hook Yacc modules	*/
/* which were originally in Y1.C to their impure data in Y1IMP.1C. Also does	*/
/* the include of the original data/external file DTXTRN.H.			*/
/*										*/
/********************************************************************************/

# include "dtxtrn.h"

/* lookahead computations */

extern int tbitset;  /* size of lookahead sets */
extern struct looksets lkst [ ];
extern int nlset; /* next lookahead set index */
extern int nolook; /* flag to suppress lookahead computations */
extern struct looksets clset;  /* temporary storage for lookahead computations */

/* working set computations */

extern struct wset wsets[ ];
extern struct wset *cwp;

/* state information */

extern int nstate;		/* number of states */
extern struct item *pstate[ ];	/* pointers to the descriptions of the states */
extern int tystate[ ];		/* contains type information about the states */
extern int indgo[ ];		/* index to the stored goto table */
extern int tstates[ ]; 		/* states generated by terminal gotos */
extern int ntstates[ ]; 	/* states generated by nonterminal gotos */
extern int mstates[ ]; 		/* chain of overflows of term/nonterm generation lists  */

/* storage for the actions in the parser */

extern int amem[ ];		/* action table storage */
extern int *memp;		/* next free action table position */

/* other storage areas */

extern int temp1[ ];		/* temporary storage, indexed by terms + ntokens or states */
extern int lineno;		/* current input line number */
extern int fatfl;	  	/* if on, error is fatal */
extern int nerrors;		/* number of errors */

/* storage for information about the nonterminals */

extern int **pres[ ];		/* vector of pointers to productions yielding each nonterminal */
extern struct looksets *pfirst[ ]; /* vector of pointers to first sets for each nonterminal */
extern int pempty[ ];		/* vector of nonterminals nontrivially deriving e */

/* accumulators for statistics information */

extern struct wset *zzcwp;
extern int zzgoent;
extern int zzgobest;
extern int zzacent;
extern int zzexcp;
extern int zzclose;
extern int zzsrconf;
extern int * zzmemsz;
extern int zzrrconf;

                                                                                                              