.ENABLE SUBSTITUTION
.; DECUS C Runtime library build command file for RSX-11M.
.; By
.;	Bob Denny
.;	12-Sep-80
.;
.; Edit History
.; 28-May-81 RBD	Major improvements. Much more automatic.
.; 19-Jan-82 MM		Changed .OBJ to .OB
.; 10-Feb-82 MM		Added C$$FLT
.; 14-Feb-82 MM		Keep dtoa out of the library.
.; 21-Feb-82 MM		dtoa is in [5,5]
.; 15-Apr-82 SDR	Keep atod out of the library and add .ENABLE AMA
.; 01-MAY-82 RBD	Final Pre-decus merge and minor improvements,
.;			 remove .ENABL AMA
.; 06-Jul-82 MM		Renamed atod -> atof for C compatibility
.; 24-Jul-82 MM		Track JSL's RSX.MAC changes
.; 21-Oct-82 RBD	Updates for RSX-11M V4.0 ... Check that CLI is MCR.
.;			If running on V3.2 install BIGMAC/BIGTKB else MAC/TKB
.; 06-Dec-82 MM		Added VMS3.0 switch
.; 06-Jul-84 RBD	Added RMS/FCS selection option.  Remove V3.2 stuff.
.;			Default off VMS junk for native RSX.  It's huge.
.;
; MMAKLB.CMD
;
; Build the DECUS C runtime library -- for RSX-11M
;
.IF <CLI> EQ "MCR" .GOTO 90
;
; This command file must be run under MCR.  Since "AT" will give
; confusing restart instructions (will be for '<CLI>'), MMAKCC will
; now exit.  Type "@MMAKLB" when you have changed CLI's to MCR.
;
.EXIT
.90:
.IFNINS ...MAC INS $MAC
.IFNINS ...LBR INS $LBR
.IFNINS ...PIP INS $PIP
.IFNINS ...TKB INS $TKB
;
; You must override the assignments in this file if you want the following
; logical devices to be assigned to other than SY:
;
;	SR:	Source and command files must be on this device.
;		SR: MUST BE WRITE ENABLED. RSX.MAC/RT11.MAC are
;		created on this device.
;	LS:	Listings go to this device. (Default == NL:)
;	OB:	Objects go to this device.
;
; NOTE: The library C.OLB will be created in LB:[1,1]. Don't forget to
;       copy STDIO.H (and other "common" .H files) there also.
;
ASN SY:=SR:
ASN NL:=LS:
ASN SY:=OB:
;
.ASK OK Are the above assignments OK?
.IFT OK .GOTO 100
;
; We will now pause so that you may change assignment(s)...
.PAUSE
.100:
;
.SETF EIS
.ASK OLD Is your processor an 11/04, 11/05, 11/10, or 11/20
.ASK FLT Should the floating-point default be (non-standard) single precsision
.IFT OLD .GOTO 110
.ASK EIS Does your machine have EIS
.110:
;
; The Decus C character type table assumes that ASCII characters
; may range from 000 to 0377 (full 8-bits).  You can save 128. bytes
; by eliminating this part of the table.  (Decus C character type
; routines will be eventually extended to support extended ASCII
; tests.  These extensions have not yet been made.)
; The DEC Professional 3xx systems support the 8-bit character set.
;
.ASK XAS Restrict table to 7-bit ASCII
;
; You may build the DECUS C support library for use with either FCS-11
; or RMS-11.  Traditionally, this library uses FCS, which is somewhat
; smaller.  However, if you are building the library for P/OS use, or
; if you have DECnet and wish to use the RMS DECnet file I/O support,
; you may build the library for use with RMS.  If you do select RMS,
; the RMSMAC.MLB macro library must be in LB:[1,1] for the library
; to build.  NOTE: RMS specific modules may be identified by their
; "module ID" from a full listing of the library, or on the link map
; of a task built with the RMS version of the library.
;
.ASK RMS Build the RMS version of the library
.SETF RMSUPD
.SETN FILES 0
.IFT RMS .GOTO RMS01
.TESTFILE LB:[1,1]C.OLB
.IF <FILERR> NE 1 .GOTO RMS02
;
; If you have already built the FCS version, you may generate an RMS
; version, which will be called CR.OLB, by assembling only the RMS
; specific modules and replacing them into a copy of the FCS version
; of C.OLB.  This procedure requires that LB:[1,1] contain the RMS macro
; library RMSMAC.MLB and the FCS version of the C library C.OLB.
;
.ASK RMSUPD Generate an RMS library from the FCS library
.IFT RMSUPD .GOTO RMS01
.RMS02:
;
; Building FCS version of library ...
;
; FCS requires static allocation of block buffers for record
; I/O. The code for this is in the C library. At this time, you
; must select the default number of block buffers which will be
; allocated to your C tasks. You need one buffer for each record
; oriented file open at any one time. You must specify at least 3
; as stdin, stdout and stderr each use one. If, at task build time,
; you wish to increase this allocation, you may use the TKB option
; "ACTFIL=n". This will extend the block buffer P-section for that
; particular task, so it can handle more simultaneous files.
;
.ASKN [3.:16.:4.] FILES How many block buffers
.GOTO FCS01
.RMS01:
;
; Building RMS version of library ...
.FCS01:
;
; Build RSX.MAC
;
.OPEN SR:RSX.MAC
.ENABLE DATA
	.TITLE	RSX	RSX HEADER FILE
;
; Created by MMAKLB.CMD on '<DATE>' at '<TIME>'
;
RSX	=	1		;Assemble for RSX
.DISABLE DATA
.IFT OLD .DATA C$$SXT	=	0		;No SXT, no EIS
.IFF EIS .DATA C$$EIS	=	0		;No EIS
.IFF FLT .DATA C$$FLT	=	0		;Double precision default
.IFT FLT .DATA C$$FLT	=	1		;Single precision default
.IFT XAS .DATA XASCII	=	0		;7-bit Ascii only
.IFT RMS .DATA RMSIO	=	1		;Assemble for RMS-11
.IFT RMSUPD .DATA RMSIO	=	1		;Assemble for RMS-11
.IFF RMS .DATA N$$FIL	=	'FILES'.	;Default number of block buffers
.ENABLE DATA
VMS3.0	=	0		;Forget VMS release-specific code

C$PMTR	=	4		;Locally define C$PMTR and C$AUTO
C$AUTO	=	-6		;To minimize global symbol references

.IIF	NDF	L$$IST	.NLIST
.IIF	NDF	L$$IST	.DSABL	CRF
.IIF	NDF	C$$SXT	C$$SXT	=	1	; SXT default
.IIF	NDF	C$$EIS	C$$EIS	=	1	; EIS default
.IIF	NDF	XASCII	XASCII	=	1	; Allow extended Ascii
.IIF	NDF	RMSIO	RMSIO	=	0	; FCS default

.MACRO	CALL	ARG1,ARG2
.IF	B	ARG2
	  JSR	PC,ARG1
.IFF
	  JSR	ARG1,ARG2
.ENDC
.ENDM	CALL

.MACRO	CALLR	ARG1
	  JMP	ARG1
.ENDM	CALLR

.MACRO	RETURN	ARG1
.IF B	ARG1
	  RTS	PC
.IFF
	  RTS	ARG1
.ENDC
.ENDM	RETURN

;
; The null branch macro
;
.macro	.br	label
.iif	ndf	label	.error	label argument needed
.iif	ne	.-label	.error	label must be the next location
.endm	.br

;
; The .sob macro is like an sob but does not set condition codes correctly
; since it is a dec/bne when sob isn't available.
;

.IF EQ	C$$SXT
.MACRO	.SOB	ARG1,ARG2
	  DEC	ARG1
	  BNE	ARG2
.ENDM	.SOB
.IFF
.MACRO	.SOB	ARG1,ARG2
	  SOB	ARG1,ARG2
.ENDM	.SOB
.ENDC

;
; This macro defines the crash instruction
;
.MACRO	CRASH
.LIST
	  BPT
.NLIST
.ENDM	CRASH

;
; Check an assumption.  Use this macro as follows:
;
;	ASSUME	ARG1 COND ARG2
;
; An error will be signalled unless the condition is satisfied.
; COND may be one of:  EQ,NE,GT,GE,LT,LE,DF,NDF,B,NB,Z,NZ,G,L,
; but it may not be IDN or DIF.
;
.MACRO	ASSUME	ARG1,COND,ARG2
	.IF	COND	<ARG1>-<ARG2>
	.IFF
		.ERROR	;Invalid assumption (ARG1) COND (ARG2)
	.ENDC
.ENDM

	.ENABL	LC, GBL
	.NLIST	CND, BEX
.IIF	NDF	L$$IST	.ENABL	CRF
.IIF	NDF	L$$IST	.LIST

.DISABLE DATA
.CLOSE
.IFT RMSUPD .GOTO RMSUP
;
PIP SR:[5,4]/FO/NV=SR:RSX.MAC
;
TIM
; Assemble the Op. Syst. non-specific modules in [5,4]
SET /UIC=[5,4]
TIM
MAC @SR:XCLBAS
;
; And now the OS specific ones in [5,5]
SET /UIC=[5,5]
TIM
MAC @SR:XILBAS
;
TIM
; Concatenate all modules and build the library
;
PIP LB:[1,1]DTOA.OBJ=OB:[5,5]DTOA.OB
PIP LB:[1,1]ATOF.OBJ=OB:[5,5]ATOF.OB
PIP OB:DTOA.OB;*,ATOF.OB;*/DE
PIP OB:OTS.TMP=OB:[5,4]*.OB,[5,5]*.OB
PIP OB:[5,4]*.OB;*/DE
PIP OB:[5,5]*.OB;*/DE
LBR LB:[1,1]C/CR=OB:OTS.TMP
PIP OB:OTS.TMP;*/DE
;
; Library build complete
;
.EXIT
.RMSUP:
;
; Creating CR.OLB from C.OLB and RMS-specific modules
;
TIM
; Assemble RMS-specific modules
;
MAC @SR:XRMSAS
;
TIM
; Concatenate all modules and build the library
;
PIP OB:OTS.TMP=OB:*.OB
PIP OB:*.OB;*/DE
LBR LB:[1,1]CR.OLB/CO=LB:[1,1]C.OLB
LBR LB:[1,1]CR/RP=OB:OTS.TMP
PIP OB:OTS.TMP;*/DE
;
; LB:[1,1] CR.OLB -- Library build complete
;
                                                                                                                                                                                                                                                                                                                                                                        