	PROGRAM TSKCO
C------------------------------------------------------------
C
C	MK 1.2		01-FEB-82	MEY
C
C	(C) E.MEYER	30-JAN-82
C
C------------------------------------------------------------
C
C	THIS PROGRAM CONVERTS TASK IMAGE FILES TO OTHER
C	FORMATS LIKE BINARY OR HEX.
C	THE CODE MUST START AT BLOCK 3. USE THE FOLLOWING
C	BUILD OPTIONS FOR CREATING THE TASK IMAGE:
C	
C	TEST/-HD/-MM,TEST=TEST,...
C	/
C	STACK = 0
C	PAR   = GEN:STARTADR:SIZE
C	//
C	
C	NOTE: CODE ALWAYS STARTS AT BLOCK 3. STARTADR HAS NO EFFECT HERE.
C
C	CAUTION: OFFSETS OF THE TASK LABEL BLOCK 0 ARE USED.
C		 PLEASE VERIFY THESE OFFSETS IN CASE OF A NEW
C		 VERSION OF RSX.
C
C		 VALUES USED: L$BMXZ	20 (OCTAL)
C
C		 YOU CAN FIND THESE VALUES IN THE TASK BUILDER
C		 MANUAL (CURRENTLY IN APPENDIX B)
C
C------------------------------------------------------------
C
C	CALLS:	LIBO:	ASKS
C
C------------------------------------------------------------
C
	BYTE	BTSKNM(80), BOUTNM(80)
	BYTE	BLOCK(512), BHEX(1024)
	BYTE	BFORM, BDUMP, BBYTS
C
	INTEGER	LBMXZ
	DATA	LBMXZ	/17/
C
C------ ENTRY POINT ------
C
1	CALL	ASKS('/Enter task image file name \',BTSKNM,ITSKN)
	DO 4	I=1,ITSKN
	IF	( BTSKNM(I) .EQ. '.' ) GOTO 5
4	CONTINUE
	BTSKNM(ITSKN+1) = '.'
	BTSKNM(ITSKN+2) = 'T'
	BTSKNM(ITSKN+3) = 'S'
	BTSKNM(ITSKN+4) = 'K'
	ITSKN	= ITSKN + 4
5	BTSKNM(ITSKN+1) = 0
	OPEN	( UNIT=2 , NAME=BTSKNM , TYPE='OLD' , ERR=9990,
     *		  FORM='UNFORMATTED' , ACCESS='DIRECT' , RECORDSIZE=128 )
C
	CALL	ASKS('/Output: binary (B) or formatted (F)\',BOUTNM,I)
	BFORM	= BOUTNM(1)
	IF	( BFORM .EQ. 'B' ) GOTO 10
	CALL	ASKS('/Dump format (D) or INTEL format (I)\',BOUTNM,I)
	BDUMP	= BOUTNM(1)
	BBYTS	= 'B'
	IF	( BDUMP .EQ. 'I' ) GOTO 10
	CALL	ASKS('/Dump bytes (B) or words (W)        \',BOUTNM,I)
	BBYTS	= BOUTNM(1)
C
10	CALL	ASKS('/Enter output file name     \',BOUTNM,IOUTN)
	BOUTNM(IOUTN+1) = 0
	IF	( BFORM .EQ. 'B' ) GOTO 15
	IF	( IOUTN .NE. 0 ) GOTO 12
	IOUTN	= 3
	BOUTNM(1) = 'T'
	BOUTNM(2) = 'I'
	BOUTNM(3) = ':'
	BOUTNM(4) = 0
12	OPEN	( UNIT=3 , NAME=BOUTNM , TYPE='NEW' , ERR=9991)
	GOTO	20
15	OPEN	( UNIT=3 , NAME=BOUTNM , TYPE='NEW' , ERR=9991 ,
     *		  FORM='UNFORMATTED' , ACCESS='DIRECT' , RECORDSIZE=128 )
C
C------	READ TASK LABEL BLOCK 0
C
20	READ	(2'1) BLOCK
	I	= BLOCK(LBMXZ)
	IF	( I .LT. 0 ) I = I + 256
	I	= I + (BLOCK(LBMXZ+1) * 256)
	ISIZE	= I / 8
	IF	( ISIZE*8 .LT. I ) ISIZE = ISIZE + 1
C
C------ IF DUMP WRITE TASK FILE NAME
C
	IF	( BDUMP .NE. 'D' ) GOTO 30
	WRITE(3,900,ERR=9993) (BTSKNM(I), I=1,ITSKN)
900	FORMAT	(1H ,80A1)
C
C------	READ ONE BLOCK
C
30	DO 70	ICNT=1,ISIZE
	READ	(2'ICNT+2,ERR=9992) BLOCK
	IF	( BFORM .NE. 'B' ) GOTO 40
C
C------	WRITE UNFORMATTED
C
	WRITE	(3'ICNT,ERR=9992) BLOCK
	GOTO	70
C
C------ CONVERT TO HEX
C
40	INUM2	= 1
	DO 50	INUM = 1,512
	IBIN	= BLOCK(INUM)
	IF	( IBIN .LT. 0 ) IBIN = IBIN + 256
	IHEX	= 0
	IF	( IBIN/128 .EQ. 0 ) GOTO 41
	IHEX	= 8
	IBIN	= IBIN - 128
C
41	IF	( IBIN/64 .EQ. 0 ) GOTO 42
	IHEX	= IHEX + 4
	IBIN	= IBIN - 64
C
42	IF	( IBIN/32 .EQ. 0 ) GOTO 43
	IHEX	= IHEX + 2
	IBIN	= IBIN - 32
C
43	IF	( IBIN/16 .EQ. 0 ) GOTO 44
	IHEX	= IHEX + 1
	IBIN	= IBIN - 16
C
44	IF	( IHEX .GE. 10 ) IHEX = IHEX + 7
	BHEX(INUM2) = IHEX + '0'
	INUM2	= INUM2 + 1
	IHEX	= 0
	IF	( IBIN/8 .EQ. 0 ) GOTO 45
	IHEX	= 8
	IBIN	= IBIN - 8
C
45	IF	( IBIN/4 .EQ. 0 ) GOTO 46
	IHEX	= IHEX + 4
	IBIN	= IBIN - 4
C
46	IF	( IBIN/2 .EQ. 0 ) GOTO 47
	IHEX	= IHEX + 2
	IBIN	= IBIN - 2
C
47	IF	( IBIN .NE. 0 ) IHEX = IHEX + 1
C
	IF	( IHEX .GE. 10 ) IHEX = IHEX + 7
	BHEX(INUM2) = IHEX + '0'
	INUM2	= INUM2 + 1
C
50	CONTINUE
C
C------	WRITE TO OUTFILE
C
	IF	( BDUMP .EQ. 'D' ) GOTO 62
C
C------	INTEL FORMAT
C
	WRITE	(3,901,ERR=9992) BHEX
901	FORMAT	(1H ,2A1)
	GOTO	70
C
62	IF	( BBYTS .EQ. 'B' ) GOTO 64
C
C------	DUMP WORDS
C
	WRITE	(3,902,ERR=9992) ICNT-1, BHEX
902	FORMAT	(/,1H ,'BLOCK NUMBER',I8,'.',/,(1H ,8(4A1,'  ')))
	GOTO	70
C
C------ DUMP BYTES
C
64	WRITE	(3,903,ERR=9992) ICNT-1, BHEX
903	FORMAT	(/,1H ,'BLOCK NUMBER',I8,'.',/,(1H ,16(2A1,'  ')))
C
70	CONTINUE
	GOTO	500
C
C------	ERROR ENTRIES
C
990	FORMAT	(1H ,'TSKCO -- Error in open ',80A1)
C
9990	WRITE	(7,990) (BTSKNM(I), I=1,ITSKN)
	CLOSE	( UNIT=2 )
	GOTO	1
C
9991	WRITE	(7,990) (BOUTNM(I), I=1,IOUTN)
	CLOSE	( UNIT=3 )
	GOTO	10
C
9992	WRITE	(7,991)
991	FORMAT	(1H ,'TSKCO -- Read error')
	GOTO	30
C
9993	WRITE	(7,992)
992	FORMAT	(1H ,'TSKCO -- Write error')
	GOTO	30
C
C------	EXIT
C
500	WRITE	(7,905) ICNT-1
905	FORMAT	(/,1H ,I8,' blocks processed',/)
C
600	CLOSE	( UNIT=2 )
	CLOSE	( UNIT=3 )
	END
                                                                                                                                                                                                                                                                                                                                                                                                                                                                       