C SUBROUTINE OS8BLK (V1A) - CALCULATES ABSOLUTE TRACK AND SECTOR ADDRESSES
C OF A GIVEN OS/8 BLOCK NUMBER
C
	SUBROUTINE OS8BLK(BLOCK,SECTOR,TK1,TK2)
	INTEGER*2 TK1,TK2,SECPTR,BLOCK,SECTOR(4)
	BYTE INTL(28)
C
C INTERLEAVE TABLE - 2:1 SECTOR INTERLEAVE FOR OS/8
C
	DATA INTL/1,3,5,7,9,11,13,15,17,19,21,23,25,
     12,4,6,8,10,12,14,16,18,20,22,24,26,1,3/
C
C LOAD SECTOR ARRAY FROM INTERLEAVE TABLE
C
	SECPTR=MOD(BLOCK*4+1,26)-1
	DO 10 N=1,4
10	SECTOR(N)=INTL(SECPTR+N)
C
C LOAD TRACK ARRAY
C
	TK1=BLOCK*2/13+1
	TK2=TK1
	IF(SECPTR.EQ.24)TK2=TK2+1
	RETURN
	END
                                                                                                                                                                                                                                                                                                                                                                                                                                                