PROGRAM R65ROM; { V2A-QDX Edit #11 6-Apr-82 Autor: -tf-  File: R65ROM.PAS  }
{
R65ROM liest das von R65 erzeugte Load-File .LOD und erzeugt 4 Files mit
den binaeren Daten (=ROM-Image) zum Stanzen eines Lochstreifens.
}

{ RT11SJ V4, Oregon PASCAL 1.2 }

CONST
  VersionNumber = 'V2A-QDX-011/RT'; VersionDate = '6-Apr-82';

  ROMSIZE     = 03777B {oktal, 2K Bytes};

  ROMLOWADR0  = 60000B {oktal};
  ROMHIGHADR0 = 63777B {oktal};

  ROMLOWADR1  = 64000B {oktal};
  ROMHIGHADR1 = 67777B {oktal};

  ROMLOWADR2  = 70000B {oktal};
  ROMHIGHADR2 = 73777B {oktal};

  ROMLOWADR3  = 74000B {oktal};
  ROMHIGHADR3 = 77777B {oktal};

TYPE
  BYTE = ARRAY [1..2] OF CHAR;
  UNSIGNED = 0..65535;
  ROM = ARRAY [0..ROMSIZE] OF CHAR {eigentlich bytes};

  VAR
    ROMFILE : FILE OF ROM;
    ROM0,ROM1,ROM2,ROM3 : ROM;
    LEN,SIZE,J,BYTECOUNT,VALUE  : INTEGER;
    ADDR                        : UNSIGNED;
    TWONIBBLES,HBT,LBT          : BYTE;
    INFILE,OUTFILE              : TEXT;
    CH                          : CHAR;
    FILENAME                    : ARRAY [1..8] OF CHAR;
    CONTROLLIST                 : BOOLEAN;

    FUNCTION HEXBIN(VAR BT:BYTE):INTEGER;

    VAR
      NIB1,NIB2 :INTEGER;

     BEGIN{HEXBIN}
       NIB1:=ORD(BT[1])-ORD('0');
       IF NIB1 > 9 THEN NIB1:=NIB1-7; { HEX A..F }
       NIB2:=ORD(BT[2])-ORD('0');
       IF NIB2 > 9 THEN NIB2:=NIB2-7; { HEX A..F }
       HEXBIN := (16*NIB1) + NIB2;
     END{HEXBIN};


   PROCEDURE WRITEFILENAME(N:INTEGER);

   VAR I: INTEGER;

   BEGIN{WRITEFILENAME}
     I:=1;
     WHILE (FILENAME[I]#' ') AND (I<=6) DO
       BEGIN WRITE(FILENAME[I]); I:=I+1 END;
     WRITE('.RO',N:1);
   END{WRITEFILENAME};



BEGIN {R65ROM}

  WRITELN('R65ROM ',VERSIONNUMBER,' (',VERSIONDATE,')');

  REPEAT
    WRITE('LOD-File: '); READLN(FILENAME);
    LEN:=0;
    RESET(INFILE,FILENAME,'.LOD',LEN);
    IF LEN<=0 THEN WRITELN('File not found');
  UNTIL LEN>0;

  WRITE('Kontroll-Listing auf LST: [Y/N] (N) ');
  READLN(CH); CONTROLLIST:= (CH='Y');


  FOR ADDR:=0 TO ROMSIZE DO
  BEGIN
    ROM0[ADDR]:=CHR(0B) {reset};
    ROM1[ADDR]:=CHR(0B) {reset};
    ROM2[ADDR]:=CHR(0B) {reset};
    ROM3[ADDR]:=CHR(0B) {reset};
  END;

  IF CONTROLLIST THEN REWRITE(OUTFILE,'LST:');

  REPEAT
    REPEAT READ(INFILE,CH) UNTIL (CH=';') OR EOF(INFILE);
    READ(INFILE,TWONIBBLES);
    BYTECOUNT:=HEXBIN(TWONIBBLES);
    IF CONTROLLIST THEN WRITE(OUTFILE,'BYTECOUNT =',BYTECOUNT:4,'.');
    IF BYTECOUNT#0 THEN
    BEGIN
      READ(INFILE,HBT); READ(INFILE,LBT);
      ADDR := HEXBIN(LBT) + 256*HEXBIN(HBT);
      IF CONTROLLIST THEN  WRITELN(OUTFILE,',  ADDR = ',HBT,LBT,' (hex)');
      FOR J:=1 TO BYTECOUNT DO
      BEGIN
        READ(INFILE,TWONIBBLES);
        VALUE:=HEXBIN(TWONIBBLES);

        IF (ADDR>=ROMLOWADR0) AND (ADDR<=ROMHIGHADR0)
          THEN ROM0[ADDR-ROMLOWADR0]:=CHR(VALUE);

        IF (ADDR>=ROMLOWADR1) AND (ADDR<=ROMHIGHADR1)
          THEN ROM1[ADDR-ROMLOWADR1]:=CHR(VALUE);

        IF (ADDR>=ROMLOWADR2) AND (ADDR<=ROMHIGHADR2)
          THEN ROM2[ADDR-ROMLOWADR2]:=CHR(VALUE);

        IF (ADDR>=ROMLOWADR3) AND (ADDR<=ROMHIGHADR3)
          THEN ROM3[ADDR-ROMLOWADR3]:=CHR(VALUE);

     IF CONTROLLIST THEN WRITELN(OUTFILE,ADDR:-6,TWONIBBLES:3,' =',VALUE:-4);

        ADDR:=ADDR+1;

      END {LOOP BYTECOUNT};

    END{BYTECOUNT#0};
    READLN(INFILE) {flush checksum and newline};

  UNTIL BYTECOUNT=0;

  CLOSE(INFILE);
  CLOSE(OUTFILE);
  WRITELN;

  WRITEFILENAME(0); SIZE:=5 {2 K Bytes}; {nur 4 Bloecke effektiv gebraucht}
  REWRITE(ROMFILE,FILENAME,'.RO0/SEEK',SIZE);
  IF SIZE<0
    THEN WRITELN('  hat keinen Platz')
    ELSE
    BEGIN
     ROMFILE^:=ROM0; PUT(ROMFILE);
     WRITE('  von',ROMLOWADR0:-7,'  bis',ROMHIGHADR0:-7,' (oktal)');
    END;
  CLOSE(ROMFILE);  WRITELN;

  WRITEFILENAME(1); SIZE:=5 {2 K Bytes}; {nur 4 Bloecke effektiv gebraucht}
  REWRITE(ROMFILE,FILENAME,'.RO1/SEEK',SIZE);
  IF SIZE<0
    THEN WRITELN('  hat keinen Platz')
    ELSE
    BEGIN
     ROMFILE^:=ROM1; PUT(ROMFILE);
     WRITE('  von',ROMLOWADR1:-7,'  bis',ROMHIGHADR1:-7,' (oktal)');
    END;
  CLOSE(ROMFILE);  WRITELN;

  WRITEFILENAME(2); SIZE:=5 {2 K Bytes}; {nur 4 Bloecke effektiv gebraucht}
  REWRITE(ROMFILE,FILENAME,'.RO2/SEEK',SIZE);
  IF SIZE<0
    THEN WRITELN('  hat keinen Platz')
    ELSE
    BEGIN
     ROMFILE^:=ROM2; PUT(ROMFILE);
     WRITE('  von',ROMLOWADR2:-7,'  bis',ROMHIGHADR2:-7,' (oktal)');
    END;
  CLOSE(ROMFILE);  WRITELN;

  WRITEFILENAME(3); SIZE:=5 {2 K Bytes}; {nur 4 Bloecke effektiv gebraucht}
  REWRITE(ROMFILE,FILENAME,'.RO3/SEEK',SIZE);
  IF SIZE<0
    THEN WRITELN('  hat keinen Platz')
    ELSE
    BEGIN
     ROMFILE^:=ROM3; PUT(ROMFILE);
     WRITE('  von',ROMLOWADR3:-7,'  bis',ROMHIGHADR3:-7,' (oktal)');
    END;
  CLOSE(ROMFILE);  WRITELN;

  WRITELN; WRITELN('R65ROM fertig',CHR(7B));

END{R65ROM}.
                                                                                                                         