	PROGRAM BITOAS
C
C	BInary TO AScii conversion routine:
C		Converts a binary file into ASCII form.
C
	BYTE      FILE(40),   OUTPUT(768)
	INTEGER*2 INPUT(256)
C
C------- Get the file name to convert and open it ----------------------------
C
	WRITE (5,10)
10	FORMAT (' Binary to ASCII conversion routine.'/)
20	WRITE (5,30)
30	FORMAT (' Name of binary file to convert to ASCII: ',$)
	READ (5,40) N,FILE
40	FORMAT (Q,40A1)
	FILE(N+1) = 0
	OPEN (UNIT=2,NAME=FILE,TYPE='OLD',FORM='UNFORMATTED',
     1		ACCESS='DIRECT',RECORDSIZE=128)
C
C------- Get the destination file name and open it ---------------------------
C
	WRITE (5,50)
50	FORMAT (' Name of output file for ASCII code: ',$)
	READ (5,60) N,FILE
60	FORMAT (Q,40A1)
	FILE(N+1) = 0
	OPEN (UNIT=3,NAME=FILE,TYPE='NEW',FORM='FORMATTED',
     1		ACCESS='SEQUENTIAL',CARRIAGECONTROL='LIST')
C
C------- Generate internal tables to speed conversion ------------------------
C
D	WRITE (5,100)
D100	FORMAT (' Generating internal tables.  Please wait a moment.')
C
	CALL TABLES
C
C------- Process the records -------------------------------------------------
C
	NREC = 1
200	CONTINUE
C
D	WRITE (5,210) NREC
D210	FORMAT (' Reading record 'I4)
C
	READ (2'NREC,END=2000) INPUT
	CALL PACK (INPUT,OUTPUT)
C
D	WRITE (5,220) INPUT,OUTPUT
D220	FORMAT ('   Input:'/32(1X,8O9/)/,'   Output:'/12(1X,64A1/)/)
C
	WRITE (3,230,END=1000) OUTPUT
230	FORMAT (12(64A1/))
	NREC = NREC + 1
	GO TO 200
C
C------- Finish up -----------------------------------------------------------
C
1000	WRITE (5,1010)
1010	FORMAT (' Ran out of room in the output file.')
C
2000	CLOSE (UNIT=2)
	CLOSE (UNIT=3)
	END
C******************************************************************* TABLES **
	SUBROUTINE TABLES
C
	COMMON /PACK/ TABLE1(256),TABLE2(256)
	BYTE TABLE1,TABLE2
C
	DO 100 I=0,255
	  MASK = 1
	  IP = "4
	  DO 10 J=1,8
	    IF ((MASK.AND.I) .NE. 0) IP = "4 - IP
	    MASK = MASK * 2
10	  CONTINUE
	  TABLE1(I+1) = I/64 .OR. IP
	  TABLE2(I+1) = TABLE1(I+1) * "10
100	CONTINUE
C
D	WRITE (5,200) TABLE1,TABLE2
D200	FORMAT (' TABLE 1:'/16(1X,16O4/)/' TABLE 2:'/16(1X,16O4/)/)
	RETURN
	END
C******************************************************************* PACK ****
	SUBROUTINE PACK (INPUT,OUTPUT)
C
C	Convert the binary data in INPUT to ASCII data in OUTPUT
C
	COMMON /PACK/ TABLE1(256), TABLE2(256)
	BYTE TABLE1, TABLE2
C
	BYTE OUTPUT(768), BYTE(2)
	INTEGER*2 INPUT(256), WORD
	EQUIVALENCE (WORD,BYTE(1))
C
	N = 1
	DO 10 I=1,256
	   WORD = INPUT(I)
	   J = BYTE(1)
	   K = BYTE(2)
	   J = J .AND. "377
	   K = K .AND. "377
	   OUTPUT(N)   = (J.AND."77) + "40
	   OUTPUT(N+1) = TABLE1(J+1) + TABLE2(K+1) + "40
	   OUTPUT(N+2) = (K.AND."77) + "40
	   N = N + 3
10	CONTINUE
C
	RETURN
	END
                                                                                                                                                                                                                                                             