      SUBROUTINE OPNFLS

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  91f04a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Open the input and output files.
C
C	Open the input file.  If an error condition develops, set the
C	error flag, display an error message, and exit this subroutine.
C	Open the output file.  If an error condition develops, set the
C	error flag, display an error message, and exit this subroutine.
C
C
C Edit Record:
C
C	30-Apr-91:  Original creation started.
C	04-Jun-91:  Original creation completed.
C
C
C Calling sequence:
C
C	FilNam = <string>
C	InLun = <integer>
C	OutLun = <integer>
C	CALL OPNFLS
C
C
C Returns:
C
C	Error
C
C
C Called By:
C
C	CRINIT
C
C***********************************************************************

      INCLUDE 'CVRCDS.DAT'		!Common & variables declarations

      OPEN				!Input file.
     *    (
     *    ACCESS = 'DIRECT',
     *    ASSOCIATEVARIABLE = IRcdNm,
     *    ERR = 800,
     *    FILE = FilNam,
     *    FORM = 'UNFORMATTED',
     *    ORGANIZATION = 'SEQUENTIAL',
     *    READONLY,
     *    RECL = 512/4,
     *    RECORDTYPE = 'FIXED',
     *    STATUS = 'OLD',
     *    UNIT = InLun
     *    )

      OPEN				!Output file.
     *    (
     *    ACCESS = 'DIRECT',
     *    ASSOCIATEVARIABLE = ORcdNm,
     *    ERR = 850,
     *    FILE = FilNam,
     *    FORM = 'UNFORMATTED',
     *    INITIALSIZE = -1,
     *    ORGANIZATION = 'SEQUENTIAL',
     *    RECL = 512/4,
     *    RECORDTYPE = 'FIXED',
     *    STATUS = 'NEW',
     *    UNIT = OutLun
     *    )

      GOTO 900

800   CONTINUE
      Error = .TRUE.
      TYPE *, 'OPNFLS:  Open error on input file, ',FilNam
      GOTO 900

850   CONTINUE
      Error = .TRUE.
      TYPE *, 'OPNFLS:  Open error on the output file, ',FilNam

900   CONTINUE
      RETURN
      END				!OPNFLS.FOR.
          