      SUBROUTINE CVTRCD

C***********************************************************************
C
C Author:  Nick Bourgeois			Version:  91f04a
C	   9605 Giddings Ave. NE
C	   Albuquerque, NM 87109
C		(505) 828-9566
C
C
C Description:
C
C	Convert a VMS ASCII record to an RT-11 ASCII record.
C
C	Go into a loop.  Obtain the length of the input ASCII record.
C	If the end of the input buffer is reached, call a routine to
C	read the next block.  If the record length is zero, loop back
C	for another pass.
C
C	Enter another loop and transfer the bytes (characters) from the
C	input buffer to the output buffer.  If the end of the input
C	buffer is reached, call a routine to read the next block.  If
C	the end-of-file flag is set, exit this subroutine.  If the end
C	of the output buffer is reached, call a routine to write the
C	buffer to the output file.  If the error flag is set, exit this
C	subroutine.
C
C	Append carriage return and line feed characters to the ASCII
C	record.  Write the output buffer out to the output file if
C	necessary.
C
C	If the record length is odd, increment the input buffer pointer
C	to skip past the null byte filler.
C
C
C Edit Record:
C
C	07-May-91:  Original creation started.
C	04-Jun-91:  Original creation completed.
C
C
C Calling sequence:
C
C	IBfPtr = <integer>
C	InBufB() = <bytes>
C	OBfPtr = <integer>
C	CALL CVTRCD
C
C
C Returns:
C
C	EOFFlg
C	Error
C	OBfPtr
C
C
C Called By:
C
C	CRWORK
C
C
C Routines Called:
C
C	RDRCD
C	WTRCD
C
C***********************************************************************

      INCLUDE 'CVRCDS.DAT'		!Common & variables declarations

100   CONTINUE
          RcdLnB(1) = InBufB(IBfPtr)	!Get the record length value.
          RcdLnB(2) = InBufB(IBfPtr+1)
          IBfPtr = IBfPtr + 2
          IF (IBfPtr .GT. 512) THEN
              CALL RDRCD
              IF (EOFFlg) GOTO 900
          ELSE
              IF (RcdLen .LE. 0) GOTO 100
          END IF
      CONTINUE

      DO 300 BytPtr = 1,RcdLen		!Transfer the characters.
          OtBufB(OBfPtr) = InBufB(IBfPtr)
          IBfPtr = IBfPtr + 1
          IF (IBfPtr .GT. 512) THEN
              CALL RDRCD
              IF (EOFFlg) GOTO 900
          END IF          
          OBfPtr = OBfPtr + 1
          IF (OBfPtr .GT. 512) THEN
              CALL WTRCD
              IF (Error) GOTO 900
          END IF
300   CONTINUE

      OtBufB(OBfPtr) = CrRtB		!Append a carriage return.
      OBfPtr = OBfPtr + 1
      IF (OBfPtr .GT. 512) THEN
          CALL WTRCD
          IF (Error) GOTO 900
      END IF
      OTBufB(OBfPtr) = LnFdB		!Append a line feed.
      OBfPtr = OBfPtr + 1
      IF (OBfPtr .GT. 512) THEN
          CALL WTRCD
          IF (Error) GOTO 900
      END IF

      IF (MOD(RcdLen,2) .EQ. 1) IBfPtr = IBfPtr + 1

900   CONTINUE
      RETURN
      END				!CVTRCD.FOR.
                                                                                                                                            