/* server.c */

#define	TCPIPMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vtcpip.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "prodat.h"
#include "tcpdat.h"
#include "server.h"
#include "srvutl.h"
#include "termio.h"
#include "inisrv.h"
#include "suspnd.h"
#include "datime.h"

#define DBUGTRUE	-1

static char *usetxt[] = {
	"",
#ifdef	DEBUGOPTION
	"  TCPIP [?] [-d level] [-f filename] [-v]",
	"	?               List this Help Text and Exit TCPIP",
	"	d  level        Debug Level",
	"		1 -	enable event printing",
	"		2 -	enable packet type printing",
	"		4 -	enable general packet dumping to disk",
	"		8 -	enable ntsleep process printing",
	"	       16 -	enable transq sequence printing",
	"	       32 -	enable arp/rarp packet dumping to disk",
	"	       64 -	enable udp packet dumping to disk",
	"	      128 -	enable icmp packet dumping to disk",
	"	      256 -	enable tcp packet dumping to disk",
	"			Enter level as sum of debug values",
#else
	"  TCPIP [?] [-f filename] [-v]",
	"	?               List this Help Text and Exit TCPIP",
#endif
	"	f  filename     Configuration File",
	"	v		Verbose Mode",
	"",
	0
	};

extern	Sreadhosts();
extern	fndbrk;

static FILE *logfp = NULL;

/*
 * main - main procedure.  Displays opening message, parses arguments,
 *	  initializes network, reads user commands and executes them, and
 *	  cleans up.
 */
main(argc,argv)
int argc;
char *argv[];
{
	int c;
	register int i,j,k;

	/*
	 * Initialize for TSX+ servers
	 */
	inisrv();

	/*
	 * Initialize tt handler
	 * Set the break character to ^C
	 */
	tt_init(0x03);

	/*
	 * Verbose Mode Off
	 */
	tt_prnt = 0;

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0]=='?') {
		    tt_prnt = 1;
		    printtxt(usetxt);
		    exit(0);
		} else
		if(argv[i][0]=='-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
#ifdef	DEBUGOPTION
			case 'd':	/* debug, optional level */
				if(sscanf(argv[++i],"%d",&debug) <= 0)
					debug = DBUGTRUE;
				break;
#endif
			case 'f':	/* configuration file name */
				strcpy(Smachfile,argv[++i]);
				break;

			case 'v':	/* verbose mode on */
				tt_prnt = 1;
				break;

			default:	/* unknown option */
				printf("Unrecognized option -%c ignored\r\n",c);
				break;
			}
			k++;
		    }
		}
	}

#ifdef	DEBUGOPTION
	printf("Debug = %d\r\n", debug);
	if (debug)
		tt_prnt = 1;
#endif

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 * Read configuration file
	 */
	i = Sreadhosts();
	if(i) {
		printf("Sreadhosts() configuration error %d\r\n", i);
		exit(IO_ERROR);
	}
	/*
	 * Set IP to value from configuration
	 */
	ntstip(Scon.myipnum);
	/*
	 * Initialize the network
	 */
	i = Snetinit();
	if (i) {
		switch(i) {
			case -1:
				printf("netinit() failed\r\n");
				break;
			case -2:
				printf("RARP failed\r\n");
				break;
			case -3:
				printf("BOOTP failed\r\n");
				break;
			default:
				printf("Snetinit() failed\r\n");
				break;
		}
		exit(IO_FATAL);
	}

	do {
		if(dosess()==0) {
			suspnd(0);
		}
	} while (fndbrk==0);

	/*
	 * close connections
	 */
	for(i=0; i<GSCKTS; i++)
		ntclose(i);

	/*
	 * terminate network stuff
	 */
	ntshut();

	printf("TCPIP Server Terminating\r\n");
	exit(0);
}

/*
 *  dosess
 *
 *  dosess is an infinite loop serving three sources
 *  of external input in order of precedence:
 *   - USER -> TCPIP message events
 *   - SYSTEM -> TCPIP job terminations
 *   - network events
 */
int dosess()
{
	register struct socket *skt;
	register struct machinfo *mp;
	struct tasker *tp;
	char s[80];
	register int i;
	int cl,ev,dat,jobnum,sknum;

	/*
	 * Check for any relevant events
	 * that need to be handled by me
	 */
	ev =  Sgetevent(USERCLASS  | CONCLASS  | SCKTCLASS |
			TCPCLASS   | MSGCLASS  | ERRCLASS  |
			ABORTCLASS | SCKTABORT | SRVCCLASS |
			SRVCATTACH | SRVCABORT | TASKCLASS,
			&cl, &dat);
	if(ev!=0) {
	  switch(cl) {
	    case SCKTCLASS:
	      switch(ev) {
		case REQSCKT:		/* request a TCPIP socket */
		  sknum = makesocket(dat);
		  if(sknum<0) {
			ntptevent(ERRCLASS,503,-1);
			sv_xmit(dat,ERRCLASS,503,-1);
		  }
		  sv_xmit(dat,SCKTCLASS,USRSCKT,sknum);
		  break;

		default:
		  break;
	      }
	      break;

	    case SCKTABORT:		/* abort the socket connection */
	      sknum = sksocket(dat);
	      skt = (struct socket *) skvalid(sknum);
	      if(skt==-1)
		break;
	      if(ev == sktlist[sknum].jobnum) {
		sktlist[sknum].inport =
		sktlist[sknum].outport =
		sktlist[sknum].jobnum = 0;
		for(i=0; i<4; i++)
		  sktlist[sknum].remoteip[i] = '\0';
		skt->jobnum = 0;
		skt->state = SCLOSED;
	      }
	      break;

	    case TCPCLASS:
	      sknum = sksocket(dat);
	      skt = (struct socket *) skvalid(sknum);
	      if(skt==-1)
		break;
	      jobnum = sktlist[sknum].jobnum;
	      if(jobnum>0) {
		switch(ev) {
		  case REQCONNECT:	/* request a connection */
		    addsess(sknum,skt->request);
		    break;

		  case REQLISTEN:	/* request to listen */
		    ntlisten(sknum);
		    break;

		  case CLOSING:		/* closing connection */
		    ntclose(sknum);
		    if(skt->state==SCLOSED) {
		      skt->jobnum = 0;
		      sktlist[sknum].jobnum = 0;
		    }
		    break;

		  case DEQUEUE:		/* read activated */
		    skt->in.rdptr = skt->in.queue;
		    if(skt->in.rdptr==skt->in.wtptr ||
		      (skt->in.size<=HIWATER && inroom(skt)>=HIWATER)) {
			    skt->out.lasttime = 0L;
		    }
		    break;

		  case ENQUEUE:		/* write activated */
		    skt->out.wtptr = skt->out.queue;
		    if(outqpsh(skt)) {
		      skt->out.lasttime = 0L;
		    }
		    break;

		  case LOGSESSION:	/* log the session */
		    if(logfp != NULL) {
		      logprocess(skt);
		    }
		    break;

		  default:
		    break;
		}
	      }
	      break;

	    case SRVCATTACH:		/* attach to a service */
	      skt = -1;
	      jobnum = -dat;
	      for(i=0; i<GSCKTS && sktlist[i].region; i++) {
		if(sktlist[i].jobnum == dat && sktlist[i].inport == ev) {
		  Stmrunset(SRVCABORT,ev,dat);
		  sktlist[i].jobnum = jobnum;
		  skt = (struct socket *) mapskt(i);
		  skt->jobnum = jobnum;
		  sv_xmit(jobnum,SRVCCLASS,ATTACHED,i);
		  if(skt->state == SEST) {
		    ntptuev(CONCLASS,CONOPEN,i);
		    ntptuev(CONCLASS,CONDATA,i);
		  }
		  break;
		}
	      }
	      if(skt==-1)
		sv_xmit(jobnum,SRVCCLASS,ATTACHED,-1);
	      break;

	    case SRVCABORT:		/* abort attach request */
	      jobnum = -dat;
	      for(i=0; i<GSCKTS && sktlist[i].region; i++) {
		if(sktlist[i].jobnum == dat && sktlist[i].inport == ev) {
		  sv_clear(jobnum);
		  sktlist[i].jobnum = 0;
		  skt = (struct socket *) mapskt(i);
		  skt->jobnum = 0;
		  ntclose(i);
		  break;
		}
	      }
	      break;

	    case CONCLASS:		/* connection class */
	      skt = (struct socket *) skvalid(dat);
	      if(skt==-1)
		break;
	      jobnum = sktlist[dat].jobnum;
	      if(jobnum>0)
		sv_xmit(jobnum,cl,ev,dat);
	      break;

	    case USERCLASS:		/* domain class */
	      skt = (struct socket *) skvalid(dat);
	      if(skt==-1)
		break;
	      jobnum = sktlist[dat].jobnum;
	      if(jobnum>0) {
		switch(ev) {
		  case DOMFAIL:
		    ntptevent(ERRCLASS,16,dat);
		    sv_xmit(jobnum,CONCLASS,CONFAIL,dat);
		    break;

		  case DOMOK:
		    mp = skt->mpp;
		    if(mp) {
		      ntptevent(MSGCLASS,17,dat);
		      if(mp->sname) {
			if(mp->port!=skt->sktport) {
			  sprintf(s,"%s #%u",mp->sname,mp->port);
			  mp->port = skt->sktport;
			  addsess(dat,s);
			} else {
			  addsess(dat,mp->sname);
			}
		      } else {
			if(mp->port!=skt->sktport) {
			  sprintf(s,"%s #%u",mp->hname,mp->port);
			  mp->port = skt->sktport;
			  addsess(dat,s);
			} else {
			  addsess(dat,mp->hname);
			}
		      }
		    } else {
		      ntptevent(ERRCLASS,16,dat);
		      sv_xmit(jobnum,CONCLASS,CONFAIL,dat);
		    }
		    break;

		  default:
		    break;
		}
	      }
	      break;

	    case TASKCLASS:		/* task class */
	      switch(ev) {
		case STARTJOB:
		  if ((tp = Scon.task) != NULL) {
		    do {
		      if (tp->taskid == dat) {
			Stmrunset(TASKCLASS,STARTJOB,dat);
			if (tp->jobnum) {
			  Stmrset(TASKCLASS,STARTJOB,dat,15);
			} else {
			  if (tp->jobnum = strtdj(tp->cmdfil)) {
			    if (tp->timer) {
			      Stmrset(TASKCLASS,STARTJOB,dat,tp->timer);
			    }
			  } else {
			    Stmrset(TASKCLASS,STARTJOB,dat,15);
			  }
			}
			break;
		      }
		    } while ((tp = tp->next) != NULL);
		  }
		  break;

		default:
		  break;
	      }
	      break;

	    case MSGCLASS:		/* message class */
	      kbprintf("MSGCLASS #%s\r\n", nterrstring(ev));
	      break;

	    case ERRCLASS:		/* error class */
	      kbprintf("ERRCLASS #%s\r\n", nterrstring(ev));
	      break;

	    case ABORTCLASS:		/* abort class */
	      kbprintf("ABORTCLASS:  ");
	      switch(ev) {
		case CLIENT:
		  printf("Terminating Client Session(s)\r\n");
		  ntabort(dat);
		  break;

		case SERVER:
		  fndbrk = 1;
		  break;

		default:
		  break;
	      }
	      break;

	    default:
	      break;
	  }
	}
	return(ev);
}

/*
 *  addsess
 *
 *  Add a session to a named machine
 */
int addsess(sknum,st)
register int sknum;
register char *st;
{
	struct machinfo *mp;
	register int i;
	int jobnum,new,pflag,port;

	jobnum = sktlist[sknum].jobnum;

	if(st==NULL) {
		ntptevent(ERRCLASS,10,sknum);
		sv_xmit(jobnum,CONCLASS,CONFAIL,sknum);
		return(-1);
	}

	pflag = 0;
	port = 0;

	/*
	 *	Find out what port to open to
	 */
	for (i=0; (st[i]!=' ') && (st[i]!='#') && (st[i]!='\0'); i++);

	if((st[i]==' ') || (st[i]=='#')) {
		st[i++] = '\0';
		for( ; (st[i]==' ') || (st[i]=='#') ; i++);
		new = i;
		for( ; (st[i]!='\0') && isdigit(st[i]) ; i++);
 		if((st[i]=='\0') && (new!=i)) {
			pflag = 1;
			port = (unsigned int)atoi(&st[new]);
		}
	}
	mp = Sgethost(sknum,st);	/* gain access to host information */
	errhandle(sknum);
	if(!mp) {
		if(pflag)	/* Append port number */
			sprintf(&st[strlen(st)]," #%u",port);
		i = Sdomain(sknum,st);
		if(i>=0) {
			/* Querying the DOMAIN name server */
			ntptevent(MSGCLASS,11,sknum);
		} else {
			/* Some error */
			ntptevent(ERRCLASS,-i,sknum);
			sv_xmit(jobnum,CONCLASS,CONFAIL,sknum);
			return(-1);
		}
	  } else {
		/*
		 * Trying to open TCP connection
		 */
		ntptevent(MSGCLASS,14,sknum);
		if(!pflag) 
			port = mp->port;
		/*
		 * try to serve the request
		 */
		if(0>Snetopen(sknum,port)) {
			/*
			 * Could not open new connection
			 */
			ntptevent(ERRCLASS,15,sknum);
			sv_xmit(jobnum,CONCLASS,CONFAIL,sknum);
			errhandle(sknum);
			return(-1);
		}
	}
	return(0);
}

/*
 *  errhandle
 *
 *  check for error messages
 */
VOID errhandle(sknum)
register int sknum;
{
	register char *errmsg;
	register int ev;
	int cl,dat;

	while((ev = Sgetevent(ERRCLASS|MSGCLASS,&cl,&dat))!=0) {
	  switch(cl) {	
	    case MSGCLASS:		/* message class */
	      kbprintf("MSGCLASS #%s\r\n", nterrstring(ev));
	      break;

	    case ERRCLASS:		/* error class */
	      kbprintf("ERRCLASS #%s\r\n", nterrstring(ev));
	      break;

	    default:
	      break;
	  }
  	}
	/*
	 * Restore the socket mapping after Sgetevent
	 */
	mapskt(sknum);
}

/*
 * Open the TCPIP LOG file
 */
VOID tcplog(fname)
register char *fname;
{
	logfp = fopen(fname,"w");
}

/*
 * Log the Process
 */
VOID logprocess(skt)
register struct socket *skt;
{
	register char *xxip;

	/*
	 * Get Current Date and Time
	 */
	fprintf(logfp,"%s    ", datime());

	/*
	 * Machines Communicating
	 */
	xxip = skt->tcpout.i.ipsource;
	fprintf(logfp,"[%d.%d.%d.%d] <<-",
		*(xxip+0)&0xFF, *(xxip+1)&0xFF,
		*(xxip+2)&0xFF, *(xxip+3)&0xFF);
	xxip = skt->tcpout.i.ipdest;
	fprintf(logfp,"->> [%d.%d.%d.%d]\r\n",
		*(xxip+0)&0xFF, *(xxip+1)&0xFF,
		*(xxip+2)&0xFF, *(xxip+3)&0xFF);

	/*
	 * Logging String
	 */
	fprintf(logfp,"%s\n\n", &skt->request);
}

/*
 *  printout text
 */
VOID printtxt(txt)
register char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}
                                                                                                                                                                                       