/* net.c */

/*
 *  Includes
 */

#include <stdio.h>
#include <string.h>

#include "vtcpip.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "prodat.h"
#include "tcpdat.h"
#include "endrvr.h"
#include "termio.h"

/*
 *  demux
 *
 *  find the packets in the buffer, determine their lowest level
 *  packet type and call the correct interpretation routines
 *
 *  the 'all' parameter tells demux whether it should attempt to empty
 *  the input packet buffer or return after the first packet is dealt with.
 *
 *  returns the number of packets demuxed
 */
#ifdef	DEBUGOPTION
static int dlook;
#endif
int demux(all)
int all;
{
	register unsigned int getcode;
	register int nmuxed;
	register DLAYER *firstlook;

	nmuxed = 0;
	/*
	 * while all flag is on
	 */
	do {
		/*
		 * where packet is
		 */
		firstlook = (DLAYER *) enrecv();
		if(firstlook!=NULL) {
#ifdef	DEBUGOPTION
			dlook++;
			if(dlook != 1) {
				printf("demux(%d) reentry\r\n", dlook);
			}
#endif
			nmuxed++;
			/*
			 * where does it belong?
			 */
			getcode = firstlook->type;
			/*
			 * what to do with it?
			 */
			switch(getcode) {
				case EARP:
				case ERARP:
#ifdef	DEBUGOPTION
if(debug&0x02) {
					if(getcode==EARP) {
						tt_puts("<a>");
					} else {
						tt_puts("<r>");
					}
}
#endif
					/*
					 * handle ARP packet
					 */
					arpinterpret((ARPKT *)firstlook);
					break;

				case EIP:
#ifdef	DEBUGOPTION
if(debug&0x02) {
					tt_puts("<i>");
}
#endif
					ipinterpret((IPKT *)firstlook);
					break;

				default:
#ifdef	DEBUGOPTION
if(debug&0x02) {
					tt_puts("<g>");
}
#endif
					break;
			}
			/*
			 * free packet
			 */
			enupdate();
#ifdef	DEBUGOPTION
			--dlook;
#endif
		}
		else 
			all = 0;
	}	while(all);
	return(nmuxed);		/* no packets anymore */
}

/*
 *  dlsend
 *
 *  usage:
 *	err = dlsend(ptr,size)
 *	err=0 for successful, non-zero error code otherwise
 *	ptr is to a dlayer packet header
 *	size is the number of bytes total
 *
 *  Ethernet addresses are resolved at higher levels because they will only
 *  need to be resolved once per logical connection, instead of once per
 *  packet.  Not too layer-like, but hopefully modular.
 *
 */

int dlsend(ptr,size)
register DLAYER *ptr;
register unsigned size;
{
	register int ret;
	
	/*
	 * send it out, pass back return code
	 * etxmit checks for   64 < size < 1518
	 */
	ret = enxmit((char *)ptr,size);
	/*
	 * automatic, immediate retry once
	 */
	if(ret) {
		if(ret = enxmit((char *)ptr,size))
			ntposterr(100);
	}
	return(ret);
}

/*
 * dlinit
 *
 * Do machine dependent initializations
 */
int dlinit()
{
	engetaddr(nnmyaddr);
	return(enopen());
}

VOID dlshut()
{
	enclose();
}
                                                                                                                                                                                                                        