/* usrblk.h */

/*
 *  The struct userblock contains entries for:
 *		username
 *		password
 *		userflag[2]
 *		default directory   / access rights
 *		enabled directories / access rights
 *		mailbox directory path
 *		message directory path / file
 *
 *  The structures size is 512 bytes (1 block per user entry).
 *
 *
 *  The username entry allows upto a 16 character name.
 *
 *  The password entry allows upto a 16 character password.
 *	The password is required if the PASSREQUIRED
 *	bit is set in the userflag word, otherwise
 *	any password is accepted.
 *
 *  A user specific login message may be sent by specifying a
 *  message file entry. This filespec may include subdirectories
 *  and is not subject to any access rights.
 *  
 *  The directory path may be specified for the users' incoming
 *  mail.  A NULL path indicates this user may not receive mail.
 *
 *  The defdir entry contains the default directory
 *  for this particular user and the users access
 *  rights to this directory (including all its subdirectories
 *  unless an access directory specifies other defaults).
 *
 *  The access directories (upto 10) are optional entries
 *  for specific directories or subdirectories allowed to this user.
 *  A specific file / directory may also be made inaccessable
 *  by specifying the path and filespec with no access.
 *
 *  If the user is allowed access to only the default
 *  and specifically enabled directories / subdirectories
 *  then the DIRRESTRICTED bit must be set in the userflag word.
 *
 *  If the DIRRESTRICTED bit is not set in the userflag word
 *  then access to a particular directory or subdirectory
 *  may be denied by specifying the exact path and not
 *  setting the ACCESSABLE flag bit.
 *
 *	Each directory / subdirectory entry has a set of
 *	access rights:
 *
 *		ACCESSABLE	file access enable
 *
 *		FILERENAME	file rename enable
 *					requires ACCESSABLE
 *					may require FILEDELETE
 *
 *		FILEPROTECT	set file protected enable
 *					requires ACCESSABLE
 *		FILEUNPROTECT	set file unprotected enable
 *					requires ACCESSABLE
 *
 *		FILECREATE	file creation enable
 *					requires ACCESSABLE
 *					may require FILEDELETE
 *		FILEDELETE	file deletion enable
 *					requires ACCESSABLE
 *					may require FILEUNPROTECT
 *
 *		DIRCREATE	directory creation enable
 *					requires ACCESSABLE
 *					requires FILECREATE
 *		DIRDELETE	directory deletion enable
 *					requires ACCESSABLE
 *					requires FILEUNPROTECT
 *					requires FILEDELETE
 *
 *		It is assumed that if access to a particular
 *		directory / subdirectory is allowed then
 *		any file in the directory or its subdirectories
 *		may be read.  Specific subdirectories may be
 *		denied access by a restricted option entry.
 *
 *
 *  The following example illustrates how the restricted
 *  directory / subdirectory option functions.  Directories are
 *  enclosed in /'s or \'s, trailing names are assumed to be
 *  a filespec (or partial filespec).  The directory specifications
 *  are scanned from access[0] -->> access[10] then default.
 *  The first matching filespec provides the access rights to
 *  the specified files / directories.
 *
 *
 *  Note:	Directory specifications must not contain logical
 *		names such as sy:, dk:, or src: nor logical device
 *		specifications such as ld0: or ld7:.
 *		Only real physical device specifications are supported.
 *		If the subdirectories have an extension other than the
 *		default '.dsk', specify the full filespec.
 *
 *
 *	default =	du0:/usera/	ACCESSABLE  | FILERENAME |
 *					FILEPROTECT | FILEUNPROTECT |
 *					FILECREATE  | FILEDELETE |
 *					DIRCREATE   | DIRDELETE
 *				is the default directory for usera who may
 *				read / write / delete any file / subdirectory
 *				in his own directory / subdirectoies.
 *	access[0] =	du1:/cdoc/file.ext	(no flags set)
 *				usera may not access this file
 *				(this access must be before the more
 *				general du1:/cdoc/ directory specification)
 *	access[1] =	du1:/cdoc/comnts/	ACCESSABLE | FILECREATE
 *				usera may access this directory and write
 *				files into the directory
 *				(this access must be before the more
 *				general du1:/cdoc/ directory specification)
 *	access[2] =	du1:/cdoc/		ACCESSABLE
 *				usera may read any documentation but
 *				may not delete any file or create
 *				any files or subdirectories in this
 *				directory or its subdirectories.
 *				(unless superseded by a previous
 *				access specification)
 *
 *	Note:	The parser for the directory path and file specification
 *		expands the path to the full filespec e.g.:
 *
 *		du0:/data/	-->> du0:/data.dsk		directory and
 *								file spec
 *
 *		du0:/work/data/ -->> du0:/work.dsk/data.dsk	directory and
 *								file spec
 *
 *		du0:/work/user  -->> du0:/work.dsk/user		file spec
 *		
 *
 *		The first two cases will check access for either the
 *		directory data.dsk or the file data.dsk, thus if
 *		access is not enabled this file cannot be read nor
 *		will a change directory be allowed.
 *
 *		The third case will check access for any directory or
 *		file du0:/work.dsk/user...........,  i.e. it performs
 *		similiar to a wild card specification.
 */

#define	DIRPATHLEN	32
#define	USERPASSLEN	16
#define	DIRLSTSIZE	11

struct entry {
	char	path[DIRPATHLEN];
	int	flags;
};

struct userblock {
	char		username[USERPASSLEN];
	char		password[USERPASSLEN];
	int		userflag[2];
	struct	entry	defdir;
	struct	entry	dirlst[DIRLSTSIZE];
	struct	entry	mailbox;
	struct	entry	msgfil;
};

#define	ACCESSABLE	0x0001		/* allow access to files */
#define	FILERENAME	0x0002		/* rename file enable */
#define	FILEPROTECT	0x0004		/* set file protected enable */
#define	FILEUNPROTECT	0x0008		/* set file unprotected enable */
#define	FILECREATE	0x0010		/* file creation enable */
#define	FILEDELETE	0x0020		/* file deletion enable */
#define	DIRCREATE	0x0040		/* directory creation enable */
#define	DIRDELETE	0x0080		/* directory deletion enable */

#define	DIRUNRESTRICTED	0x0001		/* access unrestricted flag */

#define	PASSNOTREQUIRED	0x0001		/* password not required flag */
#define LTELNET_PRIV	0x0100		/* local telnet enabled */
#define RTELNET_PRIV	0x0200		/* remote telnet enabled */
#define	LFTP_PRIV	0x0400		/* local ftp enabled */
#define RFTP_PRIV	0x0800		/* remote ftp enabled */
#define	LSMTP_PRIV	0x1000		/* send mail enabled */
#define RSMTP_PRIV	0x2000		/* receive mail enabled */
#define	LCNCT_PRIV	0x4000		/* local cnct enabled */
#define	RCNCT_PRIV	0x8000		/* remote cnct enabled */

#define	CWD_PRIV	(ACCESSABLE)
#define	LIST_PRIV	(ACCESSABLE)
#define	RNFR_PRIV	(ACCESSABLE|FILERENAME)
#define	RNTO_PRIV	(ACCESSABLE|FILERENAME)
#define	RETR_PRIV	(ACCESSABLE)
#define	STOR_PRIV	(ACCESSABLE|FILECREATE)
#define	DELE_PRIV	(ACCESSABLE|FILEDELETE)
#define	PCLR_PRIV	(ACCESSABLE|FILEUNPROTECT)
#define	PSET_PRIV	(ACCESSABLE|FILEPROTECT)
#define	MKD_PRIV	(ACCESSABLE|DIRCREATE|FILECREATE)
#define RMD_PRIV	(ACCESSABLE|DIRDELETE|FILEDELETE|FILEUNPROTECT)

#define	ALL_PRIV	0xFFFF		/* all operations */

                                                                                                                                                                                                                                                                                                                                                                                                                                                           