#module string
type
  string = array [1..stringlength+1] of char;
  relation = (lt, le, eq, ge, gt, ne);

#end string

#module radix50
type
  radix50 = array [1..radix50length] of integer;

#end radix50

#module compare
function compare(s1:string; r:relation; s2:string):boolean; external;

#end compare

#module concatenate
procedure concatenate(var s1:string; s2:string; m:integer); external;

#end concatenate

#module date
procedure date(var s:string); external;

#end date

#module dates
procedure dates(d:integer; var s:string); external;

#end dates

#module delete
procedure delete(var s:string; st, sp:integer); external;

#end delete

#module gval
function gval(o:integer):integer; external;

#end gval

#module insert
procedure insert(s1:string; var s2:string; st, m:integer); external;

#end insert

#module itos
procedure itos(n:integer; var s:string; b:integer; si:boolean; m:integer); external;

#end itos

#module left
procedure left(s1:string; var s2:string; sp:integer); external;

#end left

#module length
function length(s:string):integer; external;

#end length

#module match
function match(s1, s2:string):relation; external;

#end match

#module pad
procedure pad(var s:string; sp, max:integer); external;

#end pad

#module padleft
procedure padleft(var s:string; sp, max:integer); external;

#end padleft

#module padright
procedure padright(var s:string; sp, max:integer); external;

#end padright

#module position
function position(s1, s2:string; st:integer):integer; external;

#end position

#module pval
procedure pval(o,v:integer); external;

#end pval

#module right
procedure right(s1:string; var s2:string; sp:integer); external;

#end right

#module r50tos
procedure r50tos(r:radix50; l:integer; var s:string; m:integer); external;

#end r50tos

#module stoi
function stoi(s:string; b, st:integer; var so:integer):integer; external;

#end stoi

#module stor50
procedure stor50(s:string; var r:radix50; l:integer); external;

#end stor50

#module substring
procedure substring(s1:string; var s2:string; st, sp:integer); external;

#end substring

#module time
procedure time(var s:string); external;

#end time

#module trim
procedure trim(var s:string); external;

#end trim

#module trimleft
procedure trimleft(var s:string); external;

#end trimleft

#module trimright
procedure trimright(var s:string); external;

#end trimright

#module verify
function verify(s1, s2:string):integer; external;

#end verify

#module chain
procedure chain(f:string); external;

#end chain

#module chained
function chained:boolean; external;

#end chained

#module error
procedure error(p, m:string); external;

#end error

#module fatal
procedure fatal(p, m:string); external;

#end fatal

#module gtlin
procedure gtlin(p:string;var s:string); external;

#end gtlin

#module iand
function iand(i, j:integer):integer; external;

#end iand

#module inform
procedure inform(p, m:string); external;

#end inform

#module inot
function inot(i:integer):integer; external;

#end inot

#module ior
function ior(i, j:integer):integer; external;

#end ior

#module isdigit
function isdigit(ch:char):boolean; external;

#end isdigit

#module islowercase
function islowercase(c:char):boolean; external;

#end islowercase

#module isuppercase
function isuppercase(c:char):boolean; external;

#end isuppercase

#module ixor
function ixor(i, j:integer):integer; external;

#end ixor

#module jsw
function jsw:integer; external;

#end jsw

#module jswreset
procedure jswreset(bit:integer); external;

#end jswreset

#module jswset
procedure jswset(bit:integer); external;

#end jswset

#module lowercase
procedure lowercase(var c:char); external;

#end lowercase

#module peek
function peek(a:integer):integer; external;

#end peek

#module peekb
function peekb(a:integer):integer; external;

#end peekb

#module poke
procedure poke(a, d:integer); external;

#end poke

#module pokeb
procedure pokeb(a, d:integer); external;

#end pokeb

#module rerun
procedure rerun; external;

#end rerun

#module rnd
function rnd(s:integer):real; external;

#end rnd

#module scca
procedure scca(var f:integer; e:boolean); external;

#end scca

#module setcmd
procedure setcmd(d:char); external;

#end setcmd

#module uppercase
procedure uppercase(var c:char); external;

#end uppercase

#module warn
procedure warn(p, m:string); external;

#end warn

                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               