program wordcount;

const
  stringlength = 20;

type
  string = array [1..stringlength+1] of char;
  relation = (lt, le, eq, ge, gt, ne);
  w = record
        w : string
      end;
  freq = record
           wor : @w;
           occ : integer;
           left, right : @freq
         end;

var
  words : integer;
  word : string;
  tree : @freq;
  inp, out : text;

procedure rerun; external;

function match(s1, s2 : string):relation; external;

function length(s:string):integer; external;

function getword(var inp:text; var word : string):boolean;

var
  ch : char;
  more : boolean;
  i : integer;

function getchar(var ch : char):boolean;

begin
  if eof(inp) then
    getchar := false
  else begin
    getchar := true;
    if (inp@ >= 'A') and (inp@ <= 'Z') then
      inp@ := chr(ord(inp@) + 32);
    ch := inp@;
    get(inp)
  end
end;

begin {getword}
  more := true;
  repeat
    if not getchar(ch) then
      more := false
  until ((ch >= 'a') and (ch <= 'z')) or not more;

  getword := false;
  if more then begin
    getword := true;
    i := 0;
    repeat
      i := i+1;
      word[i] := ch;
      more := getchar(ch)
    until not more or (ch < 'a') or (ch > 'z') or (i = stringlength);
    word[i+1] := chr(0)
  end
end;


procedure insert(var item : string; var root : @freq; var count : integer);

var
  len : integer;
  rel : relation;

begin
  if root = nil then begin
    new(root);
    with root@ do begin
      left := nil;
      right := nil;
      len := length(item)+1;
      new(wor, len);
      repeat
	wor@.w[len] := item[len];
	len := len-1
      until len=0;
      occ := 1
    end;
    count := count+1
  end
  else
    with root@ do begin
      rel := match(item, wor@.w);
      if rel = eq then
	occ := occ+1
      else if rel = lt then
	insert(item, left, count)
      else
	insert(item, right, count)
    end
end;

procedure print(root : @freq; count : integer);

procedure printtree(r : @freq);

begin
  if r <> nil then
    with r@ do begin
      printtree(left);
      writeln(out, wor@.w, ' ':(stringlength+1)-length(wor@.w), occ:6);
      printtree(right)
    end
end;

begin
  printtree(root);
  writeln;
  writeln('Unique Words : ', words)
end;


begin
  if argc <> 3 then begin
    writeln('Word Counter');
    writeln;
    writeln('	$input output');
    rerun
  end
  else begin
    reset(inp, argv[1]@);
    rewrite(out, argv[2]@);
    words := 0;
    tree := nil;
    while getword(inp, word) do
      insert(word, tree, words);
    print(tree, words)
  end
end.
                                                                                                                                                                                                                                                                                                                                                                                                                                 