c	Demonstration Fortran Programme for SORT
c
c	This programme is designed to be run from a copy of the SORT
c	distribution disc, with that disc assigned as device DK:
c
	double precision area
	byte cmd(200),crlf(4)
	data area/12RDK SORT  SAV/
	if(ipeek("44).and."400)go to 100
c
c	Here we were not chained to.  Commence generation of the data
c	Generate three files from SORT.DAT - FTN2.DAT, FTN3.DAT, and
c	FTN4.DAT.  These units correspond to the Fortran DK: units.
c
	type 1
1	format(' Generating Data'//
	*' In this demonstration SORT should produce an error,'/
	*' as there is no file ERROR.DAT provided on the SORT'/
	*' distribution disc.'//)
c
	call scopy('ftn2=sort\ftn3=sort/k:d:1:80.\ftn4=sort/a\
	*tt:=error\!dk:demo\\',cmd)
	call chain(area,cmd,(len(cmd)+1)/2)
	stop 'Chain to SORT failed'
c
c	Here we were chained to - ie return from SORT
c
100	if(ipeek("510).ne.0)go to 200
c
c	Error returned from SORT
c
c	Read the bytes returned commencing at location 510,
c	null terminated.
	type 101
101	format('0Error reported from SORT:')
	i="512
	ii=1
102	j=ipeekb(i)
	if(j.eq.0)go to 120
	cmd(ii)=j
	i=i+1
	ii=ii+1
	go to 102
120	type 121,(cmd(i),i=1,ii)
121	format(x80a1)
	type 122
122	format(/)
c
c
c	Type the sorted files
c
200	type 2
2	format('0Ascending Sort:'//)
	call filprn(2)
	type 3
3	format('0Descending Sort:'//)
	call filprn(3)
	type 4
4	format('0Alphabetic Sort:'//)
	call filprn(4)
	call exit
	end
	subroutine filprn(ifile)
c	Print the contents of a file on unit IFILE
c
	byte line(82)
	data ispace/'  '/
c
10	read(ifile,20,end=30)line
20	format(82a1)
	line(82)=0
	call trim(line)
	type 20,ispace,(line(i),i=1,len(line))
	go to 10
c
30	type 40
40	format(/)
	return
	end
                                                                                                                                                                                                                                                                                    