/* sesutl.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "sesutl.h"
#include "sktlib.h"
#include "mapskt.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"

/*
 *  opensess
 *  Open a session to a named machine.
 */
int opensess(st,port)
char *st;
int port;
{
	register struct socket *skt;
	register int sknum;

	/*
	 * Request a TCPIP socket
	 */
	sknum = socket();
	if(sknum<0) {
		return(-1);
	}
	
	/*
	 * Specify the connection type
	 */
	skt = (struct socket *) mapskt(sknum);
	skt->sktport = port;

	/*
	 * Make Connection
	 */
	connect(sknum,st);

	return(sknum);
}

/*
 *  connect
 *
 *  Request a connection
 */
VOID connect(sknum,st)
int sknum;
char *st;
{
	register struct socket *skt;

	/*
	 * Verify the socket parameter
	 */
	skt = (struct socket *) skvalid(sknum);
	if(skt==-1)
		return(-1);

	/*
	 * Add the Session.
	 */
	addsess(sknum,st);
}

/*
 *  addsess
 *
 *  Add a session to a named machine
 */
int addsess(sknum,st)
register int sknum;
register char *st;
{
	struct machinfo *mp;
	register int i;
	int new,pflag,port;

	if(st==NULL) {
		skptevent(ERRCLASS,10,sknum);
		skptevent(CONCLASS,CONFAIL,sknum);
		return(-1);
	}

	pflag = 0;
	port = 0;

	/*
	 *	Find out what port to open to
	 */
	for (i=0; (st[i]!=' ') && (st[i]!='#') && (st[i]!='\0'); i++);

	if((st[i]==' ') || (st[i]=='#')) {
		st[i++] = '\0';
		for( ; (st[i]==' ') || (st[i]=='#') ; i++);
		new = i;
		for( ; (st[i]!='\0') && isdigit(st[i]) ; i++);
 		if((st[i]=='\0') && (new!=i)) {
			pflag = 1;
			port = (unsigned int)atoi(&st[new]);
		}
	}
	mp = Sgethost(sknum,st);	/* gain access to host information */
	errhandle();
	if(!mp) {
		if(pflag)	/* Append port number */
			sprintf(&st[strlen(st)]," #%u",port);
		i = Sdomain(sknum,st);
		if(i>=0) {
			/* Querying the DOMAIN name server */
			skptevent(MSGCLASS,11,sknum);
		} else {
			/* Some error */
			skptevent(ERRCLASS,-i,sknum);
			skptevent(CONCLASS,CONFAIL,sknum);
			return(-1);
		}
	  } else {
		/*
		 * Trying to open TCP connection
		 */
		skptevent(MSGCLASS,14,sknum);
		if(!pflag) 
			port = mp->port;
		/*
		 * try to serve the request
		 */
		if(0>Snetopen(sknum,port)) {
			/*
			 * Could not open new connection
			 */
			skptevent(ERRCLASS,15,sknum);
			skptevent(CONCLASS,CONFAIL,sknum);
			errhandle();
			return(-1);
		}
	}
	return(0);
}

/*
 *  listen
 *
 *  Request to listen
 */
int listen(sknum,port)
register int sknum;
register int port;
{
	register struct socket *skt;

	/*
	 * Verify the socket parameter
	 */
	skt = (struct socket *) skvalid(sknum);
	if(skt==-1)
		return(-1);

	skt->sktport = port;
	/*
	 * Request to listen
	 */
	ntlisten(sknum);

	return(skt->sktport);
}

/*
 *  socket
 *
 *  Send a request for a socket to TCPIP.
 *  If TCPIP responds with a TCPIP socket number,
 *  then the socket has been allocated space in the
 *  specified global region and has been initialized
 *  for a TCP connection.
 */

int socket()
{
	register int sknum;

	/*
	 * Request a TCPIP socket
	 */
	sknum = makesocket();
	if(sknum<0) {
		skptevent(ERRCLASS,503,-1);
	}
	
	return(sknum);
}

/*
 *  errhandle
 *
 *  write error messages to the console window
 */
VOID errhandle()
{
	int cl,ev,dat;

	while((ev = Sgetevent(ERRCLASS | MSGCLASS,&cl,&dat)) != 0) {
	  if( ev<100 || errmsg) {
	    kb_puts(skerrstring(ev));
	    kb_nline();
	  }
  	}
}
                                                                                                                                                                                                                                                                                                                                                                                                                