/* ftpprt.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"

extern	ftppol();

/*
 * ftpport
 *
 * Open a connection (PASV mode) or setup a
 * Listen connection (ACTV mode).
 *
 * Returns socket number
 * or -1 on error.
 */
int ftpport()
{
	int sknum;

	/*
	 * If PASV mode is enabled then get port number
	 * from Server and open connection.
	 */
	if(passive) {
		sknum = (int) ovrlay(ftppol,ftpcnct,0);
	} else {
		sknum = -1;
	}
	/*
	 * If PASV mode is not selected
	 * or refused by server then allow
	 * server to do an ACTIVE open.
	 */
	if(sknum == -1) {
		sknum = (int) ovrlay(ftppol,ftplstn,0);
	}
#ifdef	DEBUGOPTION
if(debug&0x08) {
	printf("ftpport(): sknum = %d\r\n", sknum);
}
#endif
	/*
	 * socket number
	 */
	if(sknum == -1) {
		kb_puts("FTP Data Connection Failed to Open\r\n");
	}
	return(sknum);
}

                                                                                                                                                                                                                                                                                                                         