/* confgs.h */

extern struct machinfo *Smadd();/* (sknum,mname) machine information */
extern	VOID	Scopyfrom();	/* (s) copy data from machine */
extern struct machinfo *Sgethost();/* (sknum,machine) get host information */
extern struct machinfo *Shostlook();/* (sknum,hname) machine lookup */
extern	VOID	Snewns();	/* name server select */
extern	VOID	Ssetgates();	/* gateway select */
extern	VOID	ntstmask();	/* set mask */
extern	int	ncstrcmp();	/* no case string compare */

/*
 *   States for config file reading state machine.
 *   One for each type of keyword and some for controlling.
 */

#define NUMSPECS 114	/* last CON option for a machine specific option */

#define	CONNAME		101
#define CONHOST		102
#define CONIP		103
#define CONPORT 	104
#define CONNS		105
#define CONGATE		106
#define CONRETR		107
#define CONTO		108
#define CONWIND		109
#define CONSEG		110
#define CONMTU		111
#define CONDELETE	112
#define CONCRMAP	113
#define CONDUP  	114
/*
 *  above this line are per machine entries
 */
#define CONFROM		115
/*
 *  below this line are configuration entries
 */
#define	CONMASK		116
#define CONMYIP		117
#define CONME		118
#define CONDEF  	119
#define CONDOMTO	120
#define CONNDOM		121
#define CONARPTO 	122
#define	CONDTO		123
#define	CONNWIND	124
#define	CONNPKT		125
#define	CONNSEG		126
#define	CONNMTU		127
#define CONSRVC		128
#define	CONTASK		129
#define	CONLOGSESSION	130

/*
 * Configuration Data
 */
#ifdef	GLOBALDATA

struct machinfo *Sns = NULL;
struct config Scon = {
		0,0,0,0,	/* subnet mask */
		0,		/* do we have a net mask */
		0,0,0,0,	/* ip num */
		"",		/* my name */
		NULL,		/* pointer to default domain */
		1		/* name server type */
};

char *Smachfile = {"TCP:tcpip.cfg"};
struct machinfo *Smachlist,*Smptr;
int	mno = 0;		/* how many machines in host file */
char	Sflags[NUMSPECS-95];	/* which parms we have or have not */

#else

extern struct machinfo *Sns;
extern struct config Scon;
extern	char *Smachfile;
extern	struct machinfo *Smachlist,*Smptr;
extern	int	mno;
extern	char	Sflags[NUMSPECS-95];

#endif
                                                                                                                                                                                                                                                                                                                                                                                                                                