/* frags.h */

/*
 *	IP Fragment Assembler
 *
 *	Thanks to Svyatoslov Ws. Mironov for the
 *	IP Fragment Assembler coding.
 *
 *	Svyatoslav Ws. Mironov
 *	Institute of Physiology SPbUniversity
 *	papa@svyat.usr.pu.ru
 *
 *****
 *
 *	The coding has been slightly modified to use a
 *	mapped region for the packet reassembly buffers.
 *
 *	1.	maprgn() and clrrgn() routines added to GBLSKT.MAC
 *
 *	2.	Module IP.C modified to call frgasm()
 *
 */

/*
 *  IP Fragmentation Reassembly Definitions
 */
#define	FRAGREGION	0	/* fragmentation reassembly region */
#define	MAXBFN		5	/* fragmentation reassembly buffers */
				/* allowed in a single 8K region */
#define	IMAXSIZE	1480	/* maximum ip data packet size */

/*  
 *  TCP/IP fragmentation reassembly packet, with data and ip header
 */
typedef struct ipx {
	DLAYER	d;
	IPLAYER	i;
	union {
		char data[IMAXSIZE];		/* maximum */
		char options[40];		/* options */
	} x;
} XPKT;

typedef struct ipasmb {
	DLAYER	d;
	IPLAYER	i;
	union {
		char data[IMAXSIZE];		/* maximum */
		char options[40];		/* options */
	} x;
        char bitmap[IMAXSIZE/64+2];
        unsigned int length;
        long time;
} ASMB;

typedef struct fragbf {
	ASMB	asmbuf[MAXBFN];
} FRGN;


/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	int	frgasm();	/* (pkt) assemble fragmented packets */
extern	int	copdat();	/* (buff,pkt) copy packet to buffer */
extern	int	asmchk();	/* (buff) check packet complete */
#endif

extern	ASMB	*idnsch();	/* (pkt) search for fragment buffer */
extern	ASMB	*allocb();	/* (pkt) allocate a fragment buffer */
                                                                                                                                                                                                                                                                           