/* rptlnt.c */

#define	RPTLNTMASTER

/*
 *  Includes
 */
#include <string.h>
#include <stdio.h>

#include "os.h"
#include "vrsion.h"
#include "vrptln.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "kbkeys.h"
#include "cliutl.h"
#include "cticks.h"
#include "tsxutl.h"
#include "rtfile.h"
#include "kbdutl.h"
#include "inicli.h"
#include "usrblk.h"
#include "suspnd.h"
#include "linset.h"

/*
 * Internal routines
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	VOID	printtxt();
extern	int	cltsxline();
extern	int	setrtel();
extern	int	dosess();
extern	VOID	rctresp();
extern	VOID	transfer();
extern	VOID	lsterr();
extern	int	rtresp();
extern	VOID	strlwr();
extern	int	getword();
extern	VOID	rportd();
extern	VOID	initsession();
extern	int	parse();
extern	int	cparse();
extern	int	Scheckpass();
extern	int	Scompass();
#endif

extern	char	*stptok();
extern	char	*stpblk();

/*
 * debug -
 *
 *	bit 0	(0x01)	enable printing of internal events
 *	bit 1	(0x02)	enable printing of telnet negotiations
 */
#define DBUGTRUE	-1	/* all debuggers */


#if ts$sys
char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  RPTLNT [?] [-d level] [-hmp filespec] [-aceklqrtvyz] [parameters]",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "	?		List the Help Text and Exit RPTLNT",
#else
       "  RPTLNT [?] [-hmp filespec] [-aceklqrtvyz] [parameters]",
       "	?		List the Help Text and Exit RPTLNT",
#endif
       "	a		Attach to Service",
       "	c  i		CL line number",
       "	e		Enable Monitoring of all Transactions",
       "	h		Specify the Help Filespec",
       "	k  c		Break Character",
       "	l  n		Number of CL lines to scan",
       "	m		Specify the Message Filespec",
       "	p		Specify the Password Filespec",
       "	q       	Specify the Connection Port",
       "	r		Restart RPTLNT after Disconnect",
       "	t  j		Terminal line parameters",
       "	v		Verbose Mode",
       "	y  s		Login Timeout in seconds",
       "	z  s		Inactivity Timeout in seconds",
       "",
       0
       };
#endif

#if rt$sys
char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       "  RPTLNT [?] [-d level] [-hmp filespec] [-cekqrtvyz] [parameters]",
       "	d level	Debug Level",
       "	   1 -	enable event printing",
       "	?       List the Help Text and Exit RPTLNT",
#else
       "  RPTLNT [?] [-hmp filespec] [-cekqrtvyz] [parameters]",
       "	?       List the Help Text and Exit RPTLNT",
#endif
       "	c  i	Connection Line number",
       "	e	Enable Monitoring of all Transactions",
       "	h	Specify the Help Filespec",
       "	k  c	Break Character",
       "	m	Specify the Message Filespec",
       "	p	Specify the Password Filespec",
       "	q       Specify the Connection Port",
       "	r	Restart RPTLNT after Disconnect",
       "	t  j	Terminal Line Parameters",
       "	v	Verbose Mode",
       "	y  s	Login Timeout in seconds",
       "	z  s	Inactivity Timeout in seconds",
       "",
       0
       };
#endif


/* Definitions for telnet protocol */

#define	ABORT			(-3)

#define SE			240	/* \360 */
#define NOP			241	/* \361 */
#define DM			242	/* \362 */
#define BREAK			243	/* \363 */
#define IP			244	/* \364 */
#define AO			245	/* \365 */
#define AYT			246	/* \366 */
#define EC			247	/* \367 */
#define EL			248	/* \370 */
#define GOAHEAD 		249	/* \371 */
#define SB			250	/* \372 */
#define WILLTEL 		251	/* \373 */
#define WONTTEL 		252	/* \374 */
#define DOTEL		 	253	/* \375 */
#define DONTTEL 		254	/* \376 */
#define IAC		 	255	/* \377 */


/* Assigned Telnet Options */
#define BINARY			0
#define ECHO			1
#define RECONNECT		2
#define SGA 			3
#define AMSN			4
#define STATUS			5
#define TIMING			6
#define RCTAN			7
#define OLW			8
#define OPS			9
#define OCRD			10
#define OHTS			11
#define OHTD			12
#define OFFD			13
#define OVTS			14
#define OVTD			15
#define OLFD			16
#define XASCII			17
#define LOGOUT			18
#define BYTEM			19
#define DET			20
#define SUPDUP			21
#define SUPDUPOUT		22
#define SENDLOC			23
#define TERMTYPE 		24
#define EOR			25
#define TACACSUID		26
#define OUTPUTMARK		27
#define TERMLOCNUM		28
#define REGIME3270		29
#define X3PAD			30
#define NAWS			31
#define TERMSPEED		32
#define TFLOWCNTRL		33
#define LINEMODE 		34
#define	    MODE		1
#define		EDIT    	1
#define		TRAPSIG 	2
#define 	MODE_ACK	4

#define	    FORWARDMASK		2

#define	    SLC			3
#define		NO_SUPPORT	0
#define		CANTCHANGE	1
#define		SLC_VALUE	2
#define		SLC_DEFAULT	3
#define		SLC_LEVELBITS	3
#define		SLC_AWK		128
#define		SLC_SYNCH	1
#define		SLC_BRK		2
#define		SLC_IP		3
#define		SLC_AO		4
#define		SLC_AYT		5
#define		SLC_EOR		6
#define		SLC_ABORT	7
#define		SLC_EOF		8
#define		SLC_SUSP	9
#define		SLC_EC		10
#define		SLC_EL   	11
#define		SLC_EW   	12
#define		SLC_RP		13
#define		SLC_LNEXT	14
#define		SLC_XON		15
#define		SLC_XOFF	16
#define		SLC_FORW1	17
#define		SLC_FORW2	18

#define XDISPLOC		35
#define XOPTIONS		255
	
#define IACFOUND		6
#define	CRFOUND			3
#define	WILLSB			2
#define NEGOTIATE		1
#define STNORM			0



#ifdef	DEBUGOPTION
char *telstates[4]={
	"Will",
	"Won't",
	"Do",
	"Don't"
};

char *teloptions[256]={
	"Binary",				/* 0 */
	"Echo",
	"Reconnection",
	"Supress Go Ahead",
	"Message Size Negotiation",
	"Status",				/* 5 */
	"Timing Mark",
	"Remote Controlled Trans and Echo",
	"Output Line Width",
	"Output Page Size",
	"Output Carriage-Return Disposition",	/* 10 */
	"Output Horizontal Tab Stops",
	"Output Horizontal Tab Disposition",
	"Output Formfeed Disposition",
	"Output Vertical Tabstops",
	"Output Vertical Tab Disposition",	/* 15 */
	"Output Linefeed Disposition",
	"Extended ASCII",
	"Logout",
	"Byte Macro",
	"Data Entry Terminal",			/* 20 */
	"SUPDUP",
	"SUPDUP Output",
	"Send Location",
	"Terminal Type",
	"End of Record",			/* 25 */
	"TACACS User Identification",
	"Output Marking",
	"Terminal Location Number",
	"3270 Regime",
	"X.3 PAD",				/* 30 */
	"Negotiate About Window Size",
	"Terminal Speed",
	"Toggle Flow Control",
	"Linemode",
	"X Display Location",			/* 35 */
	"36","37","38","39",
	"40","41","42","43","44","45","46","47","48","49",
	"50","51","52","53","54","55","56","57","58","59",
	"60","61","62","63","64","65","66","67","68","69",
	"70","71","72","73","74","75","76","77","78","79",
	"80","81","82","83","84","85","86","87","88","89",
	"90","91","92","93","94","95","96","97","98","99",
	"100","101","102","103","104","105","106","107","108","109",
	"110","111","112","113","114","115","116","117","118","119",
	"120","121","122","123","124","125","126","127","128","129",
	"130","131","132","133","134","135","136","137","138","139",
	"140","141","142","143","144","145","146","147","148","149",
	"150","151","152","153","154","155","156","157","158","159",
	"160","161","162","163","164","165","166","167","168","169",
	"170","171","172","173","174","175","176","177","178","179",
	"180","181","182","183","184","185","186","187","188","189",
	"190","191","192","193","194","195","196","197","198","199",
	"200","201","202","203","204","205","206","207","208","209",
	"210","211","212","213","214","215","216","217","218","219",
	"220","221","222","223","224","225","226","227","228","229",
	"230","231","232","233","234","235","236","237","238","239",
	"240","241","242","243","244","245","246","247","248","249",
	"250","251","252","253","254",
	"Extended Options List"		/* 255 */
};

char *LMoptions[]={
	"None",
	"SYNCH",
	"BREAK",
	"IP",
	"ABORT OUTPUT",
	"AYT",
	"EOR",
	"ABORT",
	"EOF",
	"SUSP",
	"EC",
	"EL",
	"EW",
	"RP",
	"LNEXT",
	"XON",
	"XOFF",
	"FORW1",
	"FORW2"
};

char *LMflags[]={
	"NOSUPPORT",
	"CANTCHANGE",
	"VALUE",
	"DEFAULT"
};
#endif


/*
 *	Global Buffers / Pointers
 */

char	pathname[94],		/* path */
	username[80],		/* username */
	password[80],		/* password */
	command[80],		/* command string */
	rsp[256],		/* response string */
	scratch[256];		/* scratch string */

struct userblock
	user;			/* usernames / passwords / mailboxes */

char	xs[2];			/* dumby buffer required by TSXUTL.C */

int	aflag = 0,		/* attach flag */
	rflag = 0,		/* restart flag */
	mflag = 0,		/* monitor flag */
	pswdreqd = 1,		/* password required */
	clunit = -1,		/* CL unit number */
	tparams = -1,		/* Terminal line parameters */
	ctlines = 1,		/* CL lines */
	cline = -1,		/* CLn line in use */
	tline = -1,		/* TSX line in use */
	cltl = -1,		/* CL/TSX line error */
	cport = -1,		/* Connection Port */
	cbreak = 5,		/* Default 'BREAK' character is ^E */
	rprtskt = -1,		/* RPTLNT socket number */
	rfstate = 0,		/* current process state */
	retstate = 0,		/* return state */
	waitpos = 0,		/* incoming command index */
	echo = 1,		/* echo flag */
	cnctopen = 0,		/* connection open flag */
	cnctclose = 0,		/* connection to be closed flag */
	logincnt = 0;		/* login retry counter */

int	yflag = 0,		/* login timeout flag */
	zflag = 0;		/* inactivity timeout flag */

long	lzaptime = 0L,		/* login zap time in ticks */
	izaptime = 0L;		/* inactivity zap time in ticks */

struct	socket			/* socket structure */
	*skt = NULL;

struct	twin			/* window structure */
	*tw  = NULL;

char	parsedat[80];		/* Telnet parsing */
int	pindex;			/* parsing index */

char	outbuffer[512];

int	outcnt = 0,		/* count to transfer */
	outotal = 0,		/* count left to transfer */
	outidx = 0,		/* array index */
	outdly = 0;		/* output delay parameter */

char	inpbuffer[256];

int	inpcnt = 0,		/* count to transfer */
	rdidx = 0,		/* read array index */
	wrtidx = 0;		/* write array index */

char	*pass = "PAS:paswrd.fil";	/* password file */
char	*mesg = "TCP:rptlnt.msg";	/* message file */
char	*help = "TCP:rptlnt.hlp";	/* help file */


/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}

main(argc,argv)
int argc;
char *argv[];
{
	int ev,i,j,k,c;

	/*
	 * Initialize for TSX+ clients
	 */
	inicli();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * Verbose Mode Off
	 */
	kb_prnt = 0;

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '?') {
		    kb_prnt = 1;
		    printtxt(usetxt);
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
#if ts$sys
			case 'a':	/* attach to service */
				aflag = 1;
				break;
#endif
			/*
			 * This is a 'hidden' option for bypassing
			 * password requirements for rptlnt.
			 */
			case 'b':	/* bypass password processing */
				pswdreqd = 0;
				break;

			case 'c':	/* CLn unit select */
				sscanf(argv[++i],"%d",&clunit);
				break;
#ifdef	DEBUGOPTION
			case 'd':	/* debug, optional level */
				if(sscanf(argv[++i],"%d",&debug) <= 0)
					debug = -1;
				break;
#endif
			case 'e':	/* enable RPTLNT monitoring */
				mflag = 1;
				break;

			case 'h':	/* help file */
				help = argv[++i];
				break;

			case 'k':	/* 'BREAK' Key Code */
				sscanf(argv[++i],"%d",&cbreak);
				break;
#if ts$sys
			case 'l':	/* CL lines */
				sscanf(argv[++i],"%d",&ctlines);
				break;
#endif
			case 'm':	/* message file */
				mesg = argv[++i];
				break;

			case 'q':	/* Connection Port */
				sscanf(argv[++i],"%d",&cport);
				break;

			case 'p':	/* password file */
				pass = argv[++i];
				break;

			case 'r':	/* enable RPTLNT restarting */
				rflag = 1;
				break;
#if ts$sys
			/*
			 * This is a 'hidden' option for setting the
			 * the default subdirectory base 'ld' unit
			 * and setting the maximum subdirectory nesting
			 *	note:	subdbase + subdnest <= 8
			 */
			case 's':
				sscanf(argv[++i],"%d",&subdbase);
				sscanf(argv[++i],"%d",&subdnest);
				break;
#endif
			case 't':	/* terminal line parameters */
				sscanf(argv[++i],"%d",&tparams);
				break;

			case 'v':	/* verbose mode on */
				kb_prnt = 1;
				break;

			case 'y':	/* login timeout flag */
				sscanf(argv[++i],"%d",&yflag);
				lzaptime = 60L * yflag;
				break;

			case 'z':	/* inactivity timeout flag */
				sscanf(argv[++i],"%d",&zflag);
				izaptime = 60L * zflag;
				break;

			default:	/* unknown option */
				printf(
				"Unrecognized option -%c ignored\r\n", c);
				break;
			}
			k++;
		    }
		}
	}

#ifdef	DEBUGOPTION
	if (debug)
		kb_prnt = 1;
#endif

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 *  Get the CL line and associated TSX line
	 */

	cltl = cltsxline();
	if(cltl) {
		fndbrk = 1;
	}

	/*
	 *  Start listening to the RPTLNT port
	 */
	while(!fndbrk && (setrtel()<0)) {
		/*
		 * Could not get a socket, wait 5 seconds
		 */
		suspnd(300);
	}

	while(!fndbrk && ev != -1) {
		ev = dosess();
		if(ev==0)
			suspnd(0);
	}

	cd("dk:");

	if(fndbrk) 
		kb_puts("\r\n^C\r\n");

	if(!cltl) {
		skclose(rprtskt);
		skrelease(rprtskt,1);

		suspnd(0);
		errhandle();

		sl_abort();
	}

	kb_puts("\r\nEscaping from RPTLNT\r\n");
	exit(0);
}

/*
 *	try to get a CL line
 */
int cltsxline()
{
	int i;

	if(clunit == -1) {
		return(-1);
	}

	for(i=0,cline=clunit; i<ctlines; i++,cline++) {
		if(!sl_init(cline)) {
			linset(cline,tparams);
			return(0);
		}
	}
	return(-1);
}

/*
 *	set up to receive a rptlnt connection
 */
int setrtel()
{
	int sknum;

	rfstate = 0;		/* state of the control channel */
	retstate = 0;		/* to emulate a subroutine call */
	logincnt = 0;		/* reset login counter */

	/*
	 * Initialize various things
	 */
	Snetinit();

	/*
	 * Empty CL unit buffer
	 */
	while(sl_gets(outbuffer,1)) {
		suspnd(1);
	}

	/*
	 * aflag = 1	indicates attach mode
	 * aflag = 0	indicates listen mode
	 */
	if(aflag) {
		/*
		 * Attach job to connection opened by TCPIP
		 */
		sknum = attach(0,cport);
		if(sknum==-1) {
			fndbrk++;
			return(-1);
		} else {
			Stmrset(ABORTCLASS,CLIENT,sknum,CONNWAITTIME);
		}
	} else {
		/*
		 * Create socket for control connection
		 */
		sknum = socket(0);
		if(sknum==-1)
			return(-1);
		/*
		 * default port
		 */
		listen(sknum,cport);
	}

	rprtskt = sknum;
	skt = (struct socket *) mapskt(sknum);
	tw = &(skt->session);

	return(sknum);

}

/*
 *  dosess
 *
 *  dosess is an infinite loop serving
 *  incoming messages from TCPIP
 */
int dosess()
{
	int  cl,ev,dat;

	/*
	 * Check for any relevant messages
	 * that need to be handled by me
	 */
	ev = Sgetevent(SCKTCLASS | CONCLASS | USERCLASS |
			ERRCLASS | MSGCLASS | ABORTCLASS, &cl, &dat);
	if(ev!=0) {
	  switch(cl) {
	    case CONCLASS:
	      /*
	       * RPTLNT Connection Socket
	       */
	      rportd(ev);
	      break;

	    case MSGCLASS:	/* messages */
	    case ERRCLASS:	/* error message */
	      kb_puts(skerrstring(ev));
	      kb_nline();
	      break;

	    case ABORTCLASS:	/* abort */
	      switch(ev) {
		case CLIENT:
		  kbprintf("\r\nRPTLNT session aborted by TCPIP\r\n");
		  Stmrset(ABORTCLASS,EXITABORT,dat,5);

		case USERABORT:
		  if(skrelease(dat,0) < 0) {
		    skptuev(CONCLASS,CONDATA,dat);
		  } else {
		    skclose(dat);
		    Stmrset(ABORTCLASS,USERABORT,dat,1);
		  }
		  break;

		case EXITABORT:
		  return(-1);
		  break;

		default:
		  break;
	      }
	      break;

	    default:
	      break;
	  }
	} else {
	  rportd(0);
	}

	return(ev);
}

/*
 * Dump response to client
 */
VOID rctresp(s)
register char *s;
{
	skwrite(rprtskt, s, strlen(s));
	skenque(rprtskt, 1);
	if(mflag) {
		kbprintf(" {%d} ", strlen(s));
		kb_puts(s);
	}
}

/*
 * transfer
 *
 * Transfer Message File
 */
transfer(fp)
FILE *fp;
{
	int fini;

	fini = FALSE;
	sprintf(rsp,"    ");
	do {
		if(skroom(rprtskt) > LOWWATER) {
			if(fgetss(rsp+4,sizeof(rsp)-7,fp) != NULL) {
				strcat(rsp,"\r\n");
				rctresp(rsp);
			} else {
				fini = TRUE;
			}
		} else {
			suspnd(6);
		}
	} while(fini != TRUE);
}

/*
 * This is the error print routine for TSXUTL.C
 * It will be called only if there is an internal error
 */
VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_nline();
		errstr[0] = '\0';
	}
}

/*
 * This routine is a dumby routine for TSXUTL.C
 * It should never be called, but returns a 1 [ABORT]
 */
int rtresp()
{
	kb_puts("rtresp: This dumby routine should never be called");
	return(1);
}

char *stptok( p, toword, ilen, delim)
register char *p;
char *toword;
int ilen;
char *delim;
{
	register char *adv;
	register int i;
	int j,end;
 
	adv = toword;
	end = 0;
	j = strlen(delim);

 	do { 
 		for(i=0; i<j; i++)
 			if(*p == delim[i] || (!*p))
				end++;
 		if(!end) {
 			if(adv >= (toword+ilen-1)) 
				end++;
 			*adv++=*p++;
 		}
 	} while(!end);
 	*adv='\0';
 	return(p);
}
 
char *stpblk(ch)
register char *ch;
{
 	while(*ch == ' ' || *ch == '\t') ch++;
 	return(ch);
}

VOID strlwr(st)
register char *st;
{
	while(*st) {
		*st = tolower(*st);
		*st++;
	}
}

/*
 * getword: remove a word from a string.  Things within quotes are
 * assumed to be one word.
 * return TRUE on success, FALSE on end of string
 */

int getword(string,word)
char *string;
register char *word;
{
	register char *p;
	register int i;
	char *q;

	i = 0;

	/*
	 * skip leading blanks
	 */
	p = stpblk(string);
	if(!(*p)) {
		/*
		 * no words in string
		 */
		word[0] = '\0';
		return(FALSE);
	}
	if(*p == '\"') {
		/*
		 * word delimited by quotes
		 */
		while(p[++i] && p[i] != '\"')
			word[i-1] = p[i];
		word[i-1] = '\0';
		if(!p[i]) {
			/*
			 * Missing \". Assumed at end of string.
			 */
		} else {
			i++;
		}
		q = p+i;
	} else {
		/*
		 * get word, max len 79
		 */
		q = stptok(p, word, 79, " \t\r\n");
	}
     	/*
	 * remove trailing blanks
	 */
	p = stpblk(q);
	/*
	 * remove extracted stuff
	 */
	strcpy(string,p);
	return(TRUE);
}

/*
 *	Remote PORT Server
 */
VOID rportd(code)
int code;
{
	register int c,cnt,i;
	char word[80],*p,s[80];
	FILE *fp;

	if(rprtskt < 0)
		return;

	/* 
	 * Take incoming data and process it.
	 */
	if(cnctopen) {
		cnt = skread(rprtskt,s,80);
		if(cnt > 0) {
			skdeque(rprtskt);
			for(p=s,i=0; i<cnt; i++,p++) {
				c = parse(*p);
				if(c && (inpcnt < sizeof(inpbuffer))) {
					inpbuffer[wrtidx] = c;
					wrtidx += 1;
					inpcnt += 1;
					if(wrtidx >= sizeof(inpbuffer)) {
						wrtidx = 0;
					}
				}
			}
		}
		if(cnt < 0) {
			cnctclose = 1;
		}
		if((rfstate == 3) && (retstate == 3)) {
			/*
			 * Process Inactivity Timeout
			 */
			if((zflag != 0) &&
			   (skquetime != 0L) &&
			   (elapsed(skquetime) > izaptime)) {
				rctresp(
	/*Net*/
	"\r\n\r\nInactivity Timeout\r\n"
	/*Net*/
					);
				cnctclose = 1;
			}
		} else {
			/*
			 * Process Login Timeout
			 */
			if((yflag != 0) &&
			   (skquetime != 0L) &&
			   (elapsed(skquetime) > lzaptime)) {
				rctresp(
	/*Net*/
	"\r\n\r\nLogin Timeout\r\n"
	/*Net*/
					);
				cnctclose = 1;
			}
		}
	}

	/*
	 * close this session, if over
	 */
	if((code == CONCLOSE) || (code == CONFAIL) || cnctclose) {
		/*
		 * Connection not open
		 */
		cnctopen = 0;
		cnctclose = 0;

		if(rprtskt >= 0) {
			sksendwait(rprtskt,(long) SENDWAIT);
			skclose(rprtskt);
			rprtskt = skrelease(rprtskt,1);
		}
		if(rflag && !aflag) {
			/*
			 *  Start listening to the remote CNCT port
			 */
			while((setrtel()<0) && !fndbrk) {
				/*
				 * Could not get a socket, wait 5 seconds
				 */
				suspnd(300);
			}
		} else {
			fndbrk = 1;
		}
	}

	switch(rfstate) {
	case 0:
		if(code!=CONOPEN)
			break;

		Stmrunset(ABORTCLASS,CLIENT,rprtskt);

		/*
		 * Enable Timeout
		 */
		cticks(&skquetime);

		/*
		 * Connection open
		 */
		cnctopen = 1;

		initsession(rprtskt);

		p = skt->tcpout.i.ipsource;

		sprintf(rsp,
	/*Net*/
	"    %s%s\r\n", vrstxt[1]+1, vrstxt[2]
	/*Net*/
			);
		rctresp(rsp);
		sprintf(rsp,
	/*Net*/
	"    Remote TELNET PORT Server @%s [%d.%d.%d.%d]\r\n", skt->hostname,
		*(p+0)&0xFF, *(p+1)&0xFF, *(p+2)&0xFF, *(p+3)&0xFF
	/*Net*/
			);
		rctresp(rsp);

		p = skt->tcpout.i.ipdest;

		sprintf(rsp,
	/*Net*/
	"    Initiated from host: %d.%d.%d.%d\r\n",
		*(p+0)&0xFF, *(p+1)&0xFF, *(p+2)&0xFF, *(p+3)&0xFF
	/*Net*/
			);
		rctresp(rsp);

		if((fp = rtopen(mesg,"r",0,0)) != NULL) {
			transfer(fp);
			rtclose(fp);
		}

		if(pswdreqd) {
			/*
			 * Request Username
			 */
			rctresp(
	/*Net*/
	"Username> "
	/*Net*/
			);
			rfstate = 50;
			retstate = 1;
			echo = 1;
		} else {
			if((fp = rtopen(help,"r",0,0)) != NULL) {
				transfer(fp);
				rtclose(fp);
			}
			/*
			 * Log Session
			 */
			sprintf(rsp,"RPTLNT(%d):", cport);
			logsession(rprtskt,rsp);
			sl_putc('\r');
			rfstate = 3;
			retstate = 3;
			echo = 0;
		}

		waitpos = 0; 
		break;

	case 1:
		if(getword(command,word) == FALSE) {
			/*
			 * Request Username Again
			 */
			rctresp(
	/*Net*/
	"Username> "
	/*Net*/
			);
			rfstate = 50;  
			retstate = 1;
			waitpos = 0;  
			echo = 1;
			break;
		}

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("rportd(%d): %s %s\r\n", code,word,command);
}
#endif

		logincnt += 1;
		/*
		 * keep user name
		 */
		username[0] = '\0';
		strncat(username,word,USERPASSLEN);
		strlwr(username);

		/*
		 * Request Password
		 */

		rctresp(
	/*Net*/
	"Password> "
	/*Net*/
			);

		rfstate = 50;  
		retstate = 2;
		waitpos = 0;  
		echo = 0;
		break;

	case 2:
		/*
		 * keep password
		 */
		password[0] = '\0';
		strncat(password,command,USERPASSLEN);
		strlwr(password);

		if(Scheckpass(username,password)) {
	/*
	 * User Specific Message File
	 */
	if(user.msgfil.path[0] != '\0' &&
		(fp = rtopen(&user.msgfil.path,"r",0,0)) != NULL) {
		sprintf(rsp,
	/*Net*/
	"    Message to User %s\r\n", username
	/*Net*/
			);
		rctresp(rsp);
		transfer(fp);
		rtclose(fp);
	}
			/*
			 * Help File
			 */
			if((fp = rtopen(help,"r",0,0)) != NULL) {
				transfer(fp);
				rtclose(fp);
			}
			/*
			 * Log Session
			 */
			sprintf(scratch,
	/*Log*/
	"RPTLNT: %s", username
	/*Log*/
				);
			logsession(rprtskt,scratch);
			sl_putc('\r');
			rfstate = 3;
			retstate = 3;
			waitpos = 0;  
		} else {
			if(logincnt >= 3) {
				cnctclose = 1;
				rfstate = 0;
				retstate = 0;
				break;
			}				
			/*
			 * Request Username Again
			 */
			rctresp(
	/*Net*/
	"Invalid Username/Password\r\n\r\nUsername> "
	/*Net*/
			);
			rfstate = 50;  
			retstate = 1;
			waitpos = 0;  
			echo = 1;
		}
		break;

	case 3:
		/*
		 * transfer incoming characters to the CL line
		 */
		while(inpcnt) {
			if(sl_putc(inpbuffer[rdidx]) != EOF) {
				rdidx  += 1;
				if(rdidx >= sizeof(inpbuffer)) {
					rdidx = 0;
				}
				inpcnt -= 1;
				if(inpcnt == 0) {
					suspnd(6);
				}
			} else {
				break;
			}
		}
		/*
		 * transfer CL line characters
		 * to the other host via the NET
		 */
		if(outotal <= outidx) {
			/*
			 * need to read again
			 */
			outcnt = sl_gets(outbuffer,sizeof(outbuffer));
			outotal = outcnt;
			outidx = 0;
		}
		outcnt = outotal - outidx;
		if(outcnt>0) {
			outcnt = skwrite(rprtskt,&outbuffer[outidx],outcnt);
		}
		if(outcnt>0) {
			/*
			 * send successful, adjust counts
			 */
			outidx += outcnt;
			skenque(rprtskt,1);
		}
		outdly = (outcnt + outdly + outdly + outdly) >> 2;
		if(outdly > 15) {
			suspnd(12);
			suspnd(-1);
		}
		break;

	case 50:
		/*
		 * subroutine to wait
		 * for a particular character
		 */
		while(inpcnt) {
			c = inpbuffer[rdidx];
			command[waitpos] = c;
			rdidx  += 1;
			inpcnt -= 1;
			if(rdidx >= sizeof(inpbuffer)) {
				rdidx = 0;
			}
			if((c == '\177') || (c == '\010')) {
				if(echo && waitpos) {
					skwrite(rprtskt,"\010\040\010",3);
					skenque(rprtskt,1);
				}
				if(waitpos) {
					--waitpos;
				}
				continue;
			} else {
				if(echo) {
					skwchar(rprtskt,c);
					skenque(rprtskt,1);
				}
			}
			if(command[waitpos] == '\r') {
				skwrite(rprtskt,"\r\n",2);
				skenque(rprtskt,1);
				rfstate = retstate;
				/*
				 * find end of string
				 */
				while (	(command[waitpos] < 33) &&
					(waitpos >= 0) )
					waitpos--;
				/*
				 * put in terminator
				 */
				command[++waitpos] = '\0';
				break;
			} else {
				if(waitpos < sizeof(inpbuffer)-1)
					waitpos += 1;
			}
		}
		break;

	default:
		break;
	}
}

/*
 *  initsession
 *
 *  initializes the session within the socket
 */
VOID initsession(sknum)
int sknum;
{
	int i;

	/*
	 * All parameters were zeroed when the socket
	 * was allocated in TCPIP.
	 */

	tw->pnum = sknum;

	/*
	 * clear the machine string
	 */

	for(i=1; i<19; i++)
		tw->slc[i] = -1;

	tw->echo = 1;
	tw->igoahead = 1;

	tw->slc[SLC_IP] = 3;
	tw->slc[SLC_EC] = 127;
	tw->slc[SLC_EL] = 21;
	tw->slc[SLC_EOF] = 4;
	tw->slc[SLC_ABORT] = 3;

	/* Start negotiation on network */
	/* IAC, WILLTEL, ECHO, IAC, WILLTEL, SGA */
	skwrite(rprtskt,"\377\373\001\377\373\003",6);
	/* IAC, DONTTEL, ECHO */
	skwrite(rprtskt,"\377\376\001",3);
	skenque(rprtskt,1);

#ifdef	DEBUGOPTION
if(debug&0x02) {
	/* Print to the console what we just did */
	printf("SEND: %s %s\r\n",
		telstates[WILLTEL-WILLTEL],teloptions[ECHO]);
	printf("SEND: %s %s\r\n",
		telstates[WILLTEL-WILLTEL],teloptions[SGA]);
	printf("SEND: %s %s\r\n",
		telstates[DONTTEL-WILLTEL],teloptions[ECHO]);
}
#endif

}

/*
 *  parse
 *
 *  Do the telnet negotiation parsing.
 *
 *  look at the character which has just come in from outside and
 *  check for special sequences that we are interested in.
 *
 */
int parse(c)
int c;
{
	c = cparse(c);
	if(pushsk) {
		skenque(tw->pnum,1);
	}
	return(c);
}

int cparse(c)
register int c;
{
	register char *ss;
	register int i;
	long time;
	char s[80];

	c &= 0xFF;
	switch(tw->telstate) {
	  case CRFOUND:
	    tw->telstate = STNORM;
	    if(c == '\012') {
		break;
	    }

	  case STNORM:
	    if(c == IAC) {
		tw->telstate = IACFOUND;
		break;
	    } else
	    if(c == '\015') {
		tw->telstate = CRFOUND;
	    } else
	    if(c == cbreak) {
		/*
		 * Set BAUD Rate to 75
		 */
		linset(cline,1);
		/*
		 * Send Two Characters to Cause a Framing Error
		 */
		while(sl_putc(0xFF) == EOF) { ; }
		while(sl_putc(0x00) == EOF) { ; }
		/*
		 * Wait 1/2 Second
		 */
		time = cticks(NULL);
		while(elapsed(time) < 30) {
			suspnd(15);
		}
		/*
		 * Reset Line Parameters
		 */
		linset(cline,tparams);
		break;
	    }
	    return(c);

	  case IACFOUND:		/* telnet option negotiation */
	    switch(c) {
	      case IAC:			/* real data=255 */
		tw->telstate = STNORM;
		return('\377');

	      case IP:
		tw->telstate = STNORM;
		return(tw->slc[SLC_IP]);

	      case AO:
		tw->telstate = STNORM;
		return('O' & 0x1F);

	      case AYT:
		rctresp(
	/*Net*/
	"\r\nRemote RPTLNT Running\r\n"
	/*Net*/
			);
		tw->telstate = STNORM;
		break;

	      default:
		if(248<c) {
		  tw->telstate = c;	/* by what the option is */
		  break;
		}

		kbprintf("\r\n strange telnet option %d\r\n", c & 0xFF);
		tw->telstate = STNORM;
		break;
	    }
	    break;

	  case DOTEL:
#ifdef	DEBUGOPTION
if(debug&0x02) {
	    printf("RECV: %s %s\r\n",
	    telstates[tw->telstate-WILLTEL],teloptions[c]);
}
#endif
	    switch(c) {
		case ECHO:
		  break;

		case SGA:
		  if(!tw->igoahead) {		/* suppress go-ahead */
		    /* IAC, WILLTEL, c */
		    skwrite(tw->pnum,"\377\373",2);
		    skwchar(tw->pnum,c);
		    tw->igoahead = 1;
#ifdef	DEBUGOPTION
if(debug&0x02) {
		    printf("SEND: %s %s\r\n",
		    telstates[WILLTEL-WILLTEL],teloptions[c]);
}
#endif
		  } else {
#ifdef	DEBUGOPTION
if(debug&0x02) {
		    printf("NO REPLY NEEDED: %s %s\r\n",
		    telstates[WILLTEL-WILLTEL],teloptions[c]);
}
#endif
		  }
		  break;

		case LINEMODE:
		  /* IAC, WILLTEL, LINEMODE, IAC, SB, LINEMODE, SLC */
		  skwrite(tw->pnum,"\377\373\042\377\372\042\003",7);
#ifdef	DEBUGOPTION
if(debug&0x02) {
		  printf("SEND: SB LINEMODE SLC\r\n");
}
#endif
		  for (i=1; i<19; i++) {
		    ss = s;
		    *ss++ = i;
		    if (tw->slc[i]==-1) {
		      *ss++ = NO_SUPPORT; *ss++ = 0;
		    } else {
		      *ss++ = CANTCHANGE; *ss++ = tw->slc[i];
		    }
		    skwrite(tw->pnum,s,3);
#ifdef	DEBUGOPTION
if(debug&0x02) {
		    if(tw->slc[i]==-1) {
		      printf("     %s NO_SUPPORT 0\r\n",
		      LMoptions[i]);
		    } else {
		      printf("     %s CANTCHANGE %d\r\n",
		      LMoptions[i], tw->slc[i]);
		    }
}
#endif
		  }

		  /* IAC, SE */
		  skwrite(tw->pnum,"\377\360",2);
		  break;

		default:		/* refuse it */
		  /* IAC, WONTTEL, c */
		  skwrite(tw->pnum,"\377\374",2);
		  skwchar(tw->pnum,c);
#ifdef	DEBUGOPTION
if(debug&0x02) {
		  printf("SEND: %s %s\r\n",
		  telstates[WONTTEL-WILLTEL],teloptions[c]);
}
#endif
		  break;

	    }
	    tw->telstate = STNORM;
	    break;

	  case DONTTEL:
#ifdef	DEBUGOPTION
if(debug&0x02) {
	    printf("RECV: %s %s\r\n",
	    telstates[tw->telstate-WILLTEL],teloptions[c]);
}
#endif
	    switch(c) {		/* which option? */
		case ECHO:	/* will always echo */
		  /* IAC, WILLTEL, ECHO */
		  skwrite(tw->pnum,"\377\373\001",3);
		  break;

		default:
		  break;

	    }
	    tw->telstate = STNORM;
	    break;

	  case WILLTEL:
#ifdef	DEBUGOPTION
if(debug&0x02) {
	    printf("RECV: %s %s\r\n",
	    telstates[tw->telstate-WILLTEL],teloptions[c]);
}
#endif
	    switch(c) {
		case SGA:		/* suppress go-ahead */
		  if(tw->ugoahead)
		    break;

		  /* IAC, DOTEL, SGA */
		  skwrite(tw->pnum,"\377\375\003",3);
		  tw->ugoahead = 1;
#ifdef	DEBUGOPTION
if(debug&0x02) {
		  printf("SEND: %s %s\r\n",
		  telstates[DOTEL-WILLTEL],teloptions[c]);
}
#endif
		  break;

		case TIMING:
		  break;

		default:		/* refuse it */
		  /* IAC, DONTTEL, c */
		  skwrite(tw->pnum,"\377\376",2);
		  skwchar(tw->pnum,c);
#ifdef	DEBUGOPTION
if(debug&0x02) {
		  printf("SEND: %s %s\r\n",
		  telstates[DONTTEL-WILLTEL],teloptions[c]);
}
#endif
		  break;

	    }
	    tw->telstate = STNORM;
	    break;
		    
	  case WONTTEL:
#ifdef	DEBUGOPTION
if(debug&0x02) {
	    printf("RECV: %s %s\r\n",
	    telstates[tw->telstate-WILLTEL],teloptions[c]);
}
#endif
	    tw->telstate = STNORM;
	    break;

	  case SB:
	    tw->telstate = NEGOTIATE;
	    tw->substate = 0;
	    pindex = 0;
	    break;

	  case NEGOTIATE:
	    if(tw->substate <200) {
		switch(c) {
		  case IAC:
		    parsedat[pindex] = 0;
		    tw->substate = c;
		    break;

		  default:
		    parsedat[pindex++] = c;
		    break;
		}
	    } else {
		switch( tw->substate) {
		  case IAC:
		    tw->substate = c;
		    break;

		  case SE:
		      switch( parsedat[0]) {
			case LINEMODE:
			  switch( parsedat[1] ) {
			    case DOTEL:
			      /* IAC, SB, LINEMODE */
			      /* WONTTEL, TRAPSIG */
			      /* IAC, SE */
			      skwrite(tw->pnum,
				"\377\372\042\374\002\377\360",7);
			      break;

			    case WILLTEL:
			      /* IAC, SB, LINEMODE */
			      /* DONTTEL, TRAPSIG */
			      /* IAC, SE */
			      skwrite(tw->pnum,
				"\377\372\042\376\002\377\360",7);
			      break;

			    case SLC:
#ifdef	DEBUGOPTION
if(debug&0x02) {
			      printf("RECV: SB LINEMODE SLC\r\n");
			      for(i=2;(parsedat[i]!=0) &&
				(parsedat[i]!=IAC); i+=3) {
			      	if(parsedat[i+1] & SLC_AWK) {
				  printf("     %s %s|AWK %d\r\n",
				    LMoptions[parsedat[i]],
				    LMflags[parsedat[i+1] &
				      SLC_LEVELBITS],
				    parsedat[i+2]);
			      	} else {
				  printf("     %s %s %d\r\n",
				    LMoptions[parsedat[i]],
				    LMflags[parsedat[i+1] &
				      SLC_LEVELBITS],
				    parsedat[i+2]);
				}
			      }
}
#endif
			      /* First check to see if we need to reply */
			      for(i=2;(parsedat[i]!=0) &&
				(parsedat[i]!=IAC); i+=3) {
			      	if(!(parsedat[i+1] & SLC_AWK))
				  break;
			      }	
			      /* if we do then send a reply */
#ifdef	DEBUGOPTION
if(debug&0x02) {
			      printf("SEND: SB LINEMODE SLC\r\n");
}
#endif
			      if ((parsedat[i]!=IAC) && (parsedat[i]!=0)) {
				/* IAC, SB, LINEMODE, SLC */
			      	skwrite(tw->pnum,"\377\372\042\003",4);

			      	for (i=2; (parsedat[i]!=0) &&
				  (parsedat[i]!=IAC); i+=3) {
				  if (!(parsedat[i+1] & SLC_AWK)) {
				    ss = s;
				    *ss++ = i;
				    if (tw->slc[parsedat[i]]==-1) {
				      *ss++ = NO_SUPPORT;
				      *ss++ = 0;
				    } else {
				      *ss++ = CANTCHANGE;
				      *ss++ = tw->slc[parsedat[i]];
				    }
				    skwrite(tw->pnum,s,3);
#ifdef	DEBUGOPTION
if(debug&0x02) {
				    if(tw->slc[parsedat[i]]==-1) {
				      printf("    %s NO_SUPPORT 0\r\n",
					LMoptions[parsedat[i]]);
				    } else {
				      printf("    %s CANTCHANGE %d\r\n",
					LMoptions[parsedat[i]],
					tw->slc[parsedat[i]]);
				    }
}
#endif
				  }
			      	}
				/* IAC, SE */
				skwrite(tw->pnum,"\377\360",2);
			      }

			      /* otherwise just exit */
			      break;

			    default:
			      break;
			  }
			  break;
			
			default:
			  break;
		    }
		    tw->telstate = STNORM;
		    break;

		  default:
		    tw->telstate = STNORM;
		    break;
		}
	    }
	    break;

	  default:
	    tw->telstate = STNORM;
	    break;

	}
	return('\0');
}

/*
 *  Scheckpass ( us, ps )
 *
 *  Check the password file for the user/password
 *  combination. An inaccessable password file
 *  results in an invalid return.
 *
 *  If the user/password is invalid or the
 *  default directory is not accessable
 *  Scheckpass returns invalid.
 *
 *  Returns valid(1)/invalid(0)
 */
int Scheckpass(us,ps)
char *us,*ps;
{
	FILE *fp;
	
	if(NULL==(fp = rtopen(pass,"rn",0,0))) {
		return(0);
	}
	while (NULL != fread(&user,sizeof(struct userblock),1,fp)) {
		/*
		 * does password check ?
		 */
		if(!strncmp(us,&user.username,USERPASSLEN) &&
			(PASSNOTREQUIRED & user.userflag[0]  ||
				Scompass(ps,&user.password))) {
			rtclose(fp);
			if(!(RTELNET_PRIV & user.userflag[1])) {
				sprintf(rsp,
	/*Net*/
	"User '%s' does not have remote TELNET privilege\r\n", username
	/*Net*/
					);
				rctresp(rsp);
				return(0);
			}

			/*
			 * Verify Users default directory
			 */
			getpath(pathname);
			if(cd(&user.defdir.path)) {
				/*
				 * failed
				 */
				sprintf(rsp,
	/*Net*/
	"%s\r\n", errstr
	/*Net*/
					);
				rctresp(rsp);
				cd(pathname);
				errstr[0] = '\0';
				return(0);
			} else {
				/*
				 * success
				 */
				cd(pathname);
				return(1);
			}
		}
	}
	rtclose(fp);
	return(0);
}

/*
 *  Scompass ( ps, en )
 *
 *  Compute and check the encrypted password
 */
int Scompass(ps,en)
char *ps,*en;
{
	int i,ck;
	char *p,c;

	ck = 0;
	p = ps;
	/*
	 * checksum the string
	 */
	while (*p)
		ck += *p++;
	c = ck;
	/*
	 * XOR with checksum
	 */
	i = USERPASSLEN;
	while (i--) {
		if((((*ps ^ c)|32)&127)!=*en)
			return(0);
		/*
		 * increment checksum to hide length
		 */
		if(*ps) {
			ps++;
		} else {
			c++;
		}
		en++;
	}
	return(1);
}

                                                                                                                                                    