/* scrnDI.c */

/*
 * Includes
 */
#include <stdio.h>
#include <string.h>

#include "vtcpip.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "prodat.h"
#include "tcpdat.h"
#include "bytprc.h"
#include "suspnd.h"
#include "termio.h"

#include "fmtdat.h"
#include "vt1xx.h"

extern	char *cstate[];

scrnD(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register TCPKT *tl;
	register DLAYER *dl;
	int row,state;
	char *ea;

	skt = (struct socket *) mapskt(sknum);
	tl = &skt->tcpout;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #D)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	row = 2;
	sprintf(s,
	"TCPKT	tcpout		[%06.6o]	size = %4.4d bytes",
		&skt->tcpout, sizeof(struct tcp));
	fmtplc(s,row++);

	sprintf(s,
	"    DLAYER	d	[%06.6o]	size = %4.4d bytes",
		&tl->d, sizeof(struct ether));
	fmtplc(s,row++);

	sprintf(s,
	"    IPLAYER	i	[%06.6o]	size = %4.4d bytes",
		&tl->i, sizeof(struct iph));
	fmtplc(s,row++);

	sprintf(s,
	"    TCPLAYER	t	[%06.6o]	size = %4.4d bytes",
		&tl->t, sizeof(struct tcph));
	fmtplc(s,row++);

	sprintf(s,
	"    TCPKT	data	[%06.6o]	size = %4.4d bytes",
		&tl->x.data[0], sizeof(skt->tcpout.x.data));
	fmtplc(s,row++);

	dl = &tl->d;
	row++;

	sprintf(s,
	"	DLAYER	d");
	fmtplc(s,row++);

	sprintf(s,
	"	iostat . . . . . . . . = 0x%04.4X", dl->iostat);
	fmtplc(s,row++);

	sprintf(s,
	"	iolen  . . . . . . . . = 0x%04.4X", dl->iolen);
	fmtplc(s,row++);

	sprintf(s,
	"	type . . . . . . . . . = 0x%04.4X", dl->type);
	fmtplc(s,row++);

	ea = &dl->dest;
	row++;
	sprintf(s,
	"	dest = %02X-%02X-%02X-%02X-%02X-%02X",
		*ea     & 0xFF, *(ea+1) & 0xFF, *(ea+2) & 0xFF,
		*(ea+3) & 0xFF, *(ea+4) & 0xFF, *(ea+5) & 0xFF);
	fmtplc(s,row++);

	ea = &dl->me;
	row++;
	sprintf(s,
	"	me   = %02X-%02X-%02X-%02X-%02X-%02X",
		*ea     & 0xFF, *(ea+1) & 0xFF, *(ea+2) & 0xFF,
		*(ea+3) & 0xFF, *(ea+4) & 0xFF, *(ea+5) & 0xFF);
	fmtplc(s,row++);
}

scrnE(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register TCPKT *tl;
	register IPLAYER *il;
	int row,state;
	char *ea;

	skt = (struct socket *) mapskt(sknum);
	tl = &skt->tcpout;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #E)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	row = 2;
	sprintf(s,
	"TCPKT	tcpout		[%06.6o]	size = %4.4d bytes",
		&skt->tcpout, sizeof(struct tcp));
	fmtplc(s,row++);

	sprintf(s,
	"    DLAYER	d	[%06.6o]	size = %4.4d bytes",
		&tl->d, sizeof(struct ether));
	fmtplc(s,row++);

	sprintf(s,
	"    IPLAYER	i	[%06.6o]	size = %4.4d bytes",
		&tl->i, sizeof(struct iph));
	fmtplc(s,row++);

	sprintf(s,
	"    TCPLAYER	t	[%06.6o]	size = %4.4d bytes",
		&tl->t, sizeof(struct tcph));
	fmtplc(s,row++);

	sprintf(s,
	"    TCPKT	data	[%06.6o]	size = %4.4d bytes",
		&tl->x.data[0], sizeof(skt->tcpout.x.data));
	fmtplc(s,row++);

	il = &tl->i;
	row++;

	sprintf(s,
	"	IPLAYER	i");
	fmtplc(s,row++);

	sprintf(s,
	"	versionandhdrlen . . . = 0x__%02.2X",
		il->versionandhdrlen & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	service  . . . . . . . = 0x__%02.2X", il->service & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	tlen . . . . . . . . . = %6.6u", intswap(il->tlen));
	fmtplc(s,row++);

	sprintf(s,
	"	identity . . . . . . . = 0x%04.4X", intswap(il->identity));
	fmtplc(s,row++);

	sprintf(s,
	"	frags  . . . . . . . . = 0x%04.4X", intswap(il->frags));
	fmtplc(s,row++);

	sprintf(s,
	"	ttl  . . . . . . . . . = %6.6u", il->ttl & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	protocol . . . . . . . = 0x__%02.2X", il->protocol & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	check  . . . . . . . . = 0x%04.4X", intswap(il->check));
	fmtplc(s,row++);

	ea = &il->ipsource;
	row++;
	sprintf(s,
	"	ipsource = %d.%d.%d.%d",
		*ea     & 0xFF, *(ea+1) & 0xFF,
		*(ea+2) & 0xFF,	*(ea+3) & 0xFF);
	fmtplc(s,row++);

	ea = &il->ipdest;
	row++;
	sprintf(s,
	"	ipdest   = %d.%d.%d.%d",
		*ea     & 0xFF, *(ea+1) & 0xFF,
		*(ea+2) & 0xFF,	*(ea+3) & 0xFF);
	fmtplc(s,row++);
}

scrnF(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register TCPKT *tl;
	register TCPLAYER *tcl;
	int row,state;

	skt = (struct socket *) mapskt(sknum);
	tl = &skt->tcpout;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #F)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	row = 2;
	sprintf(s,
	"TCPKT	tcpout		[%06.6o]	size = %4.4d bytes",
		&skt->tcpout, sizeof(struct tcp));
	fmtplc(s,row++);

	sprintf(s,
	"    DLAYER	d	[%06.6o]	size = %4.4d bytes",
		&tl->d, sizeof(struct ether));
	fmtplc(s,row++);

	sprintf(s,
	"    IPLAYER	i	[%06.6o]	size = %4.4d bytes",
		&tl->i, sizeof(struct iph));
	fmtplc(s,row++);

	sprintf(s,
	"    TCPLAYER	t	[%06.6o]	size = %4.4d bytes",
		&tl->t, sizeof(struct tcph));
	fmtplc(s,row++);

	sprintf(s,
	"    TCPKT	data	[%06.6o]	size = %4.4d bytes",
		&tl->x.data[0], sizeof(skt->tcpout.x.data));
	fmtplc(s,row++);

	tcl = &tl->t;
	row++;

	sprintf(s,
	"	TCPLAYER t");
	fmtplc(s,row++);

	sprintf(s,
	"	source . . . . . . . . =     %6u", intswap(tcl->source));
	fmtplc(s,row++);

	sprintf(s,
	"	dest . . . . . . . . . =     %6u", intswap(tcl->dest));
	fmtplc(s,row++);

	sprintf(s,
	"	seq  . . . . . . . . . = 0x%08.8lX", longswap(tcl->seq));
	fmtplc(s,row++);

	sprintf(s,
	"	ack  . . . . . . . . . = 0x%08.8lX", longswap(tcl->ack));
	fmtplc(s,row++);

	sprintf(s,
	"	hlen . . . . . . . . . =       %4.4d", tcl->hlen & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	flags  . . . . . . . . =     0x__%02.2X", tcl->flags & 0xFF);
	fmtplc(s,row++);

	sprintf(s,
	"	window . . . . . . . . =     %6u", intswap(tcl->window));
	fmtplc(s,row++);

	sprintf(s,
	"	check  . . . . . . . . =     0x%04.4X", intswap(tcl->check));
	fmtplc(s,row++);

	sprintf(s,
	"	urgent . . . . . . . . =     0x%04.4X", intswap(tcl->urgent));
	fmtplc(s,row++);
}

scrnG(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register TCPKT *pkt;
	register int row,state;

	skt = (struct socket *) mapskt(sknum);
	pkt = &skt->tcpout;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #G)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	tcpchar(pkt);
}

scrnH(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register TCPKT *pkt;
	register int row,state;

	skt = (struct socket *) mapskt(sknum);
	pkt = &skt->tcpout;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #H)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	tcpdata(pkt,0);
}

scrnI(sknum)
int sknum;
{
	char s[80];
	register struct socket *skt;
	register TCPKT *pkt;
	register int row,state;

	skt = (struct socket *) mapskt(sknum);
	pkt = &skt->tcpout;

	row = 0;
	state = skt->state;
	if(state<SCLOSED || SLAST<state)
		state = 0;
	sprintf(s,"SCKT%02.2d   (Screen #I)       state = %2.2d = %s",
		sknum, skt->state, cstate[state]);
	fmtplc(s,row++);

	tcpdata(pkt,256);
}

tcpchar(pkt)
register TCPKT *pkt;
{
	register int c,j;
	register char *t;
	int i,row;
	char s[80];
	char *pos;

	row = 2;
	sprintf(s,
	"TCPKT data	[%06.6o]	size = %4.4d bytes",
		&pkt->x.data, sizeof(pkt->x.data));
	fmtplc(s,row++);

	row = 5;
	for(pos=pkt->x.data, i=0; i<16; i++) {
		sprintf(s,"[%06.6o]    ", pos);
		for(t=s+12, j=0; j<64; j++) {
			c = *pos++;
			if(c<=31 || c>=127)
				c = '.';
			*t++ = c;
		}
		*t = 0;
		fmtplc(s,row+i);
	}
}

tcpdata(pkt,offset)
register TCPKT *pkt;
int offset;
{
	register int c,j;
	int i,row;
	char s[80],t[8];
	char *pos;

	row = 2;
	sprintf(s,
	"TCPKT data	[%06.6o]	size = %4.4d bytes",
		&pkt->x.data, sizeof(pkt->x.data));
	fmtplc(s,row++);

	row = 4;
	pos = pkt->x.data;
	for(pos+=offset, i=0; i<16; i++) {
		sprintf(s,"[%06.6o]  ", pos);
		for(j=0; j<16; j++) {
			sprintf(t,"  %02.2X", *pos++ & 0xFF);
			strcat(s,t);
		}
		fmtplc(s,row+i);
	}
}

                                                                                                                                                                                        