/* sktl44.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "sesutl.h"
#include "sktlib.h"
#include "mapskt.h"
#include "bytprc.h"
#include "cticks.h"
#include "suspnd.h"


/*
 *  skgtftp
 *
 *  This routine provides the information needed to open an ftp connection
 *  back to the originator of the command connection.  The other side's IP
 *  number and the port numbers are returned in an INTEGER array ( convenient
 *  for use in PORT commands ).
 */
int skgtftp(sknum,a)
int sknum,a[];
{
	register struct socket *skt;
	register unsigned int i;

	/*
	 * check validity
	 */
	skt = (struct socket *) skvalid(sknum);
	if(skt==-1)
		return(-2);

	a[0] = skt->tcpout.i.ipdest[0] & 0xFF;
	a[1] = skt->tcpout.i.ipdest[1] & 0xFF;
	a[2] = skt->tcpout.i.ipdest[2] & 0xFF;
	a[3] = skt->tcpout.i.ipdest[3] & 0xFF;
	i = intswap(skt->tcpout.t.source);
	a[4] = i>>8 & 0xFF;
	a[5] = i    & 0xFF;
	i = intswap(skt->tcpout.t.dest);
	a[6] = i>>8 & 0xFF;
	a[7] = i    & 0xFF;

	return(0);
}
                                                                                                                                                                                                                                                                                                                                                                                            