/* shost3.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "mapskt.h"
#include "bytprc.h"
#include "confgs.h"

extern	shost3();

/*
 *  Scopyfrom
 *
 *  Look at the Sflags array to determine which elements to copy from
 *  a previous machine's entries.  If a machine name has been given as
 *  "default", the state machine will fill in the fields from that
 *  machine's entries.
 *
 *  If the machine name to copyfrom is not present in the list, set the
 *  program default values for each field.
 */
VOID Scopyfrom(s)
register char *s;
{
	register struct machinfo *m;
	register int i;

	/*
	 * search list through list of parms
	 */
	m = (struct machinfo *) ovrlay(shost3,Shostlook,2,-1,s);

	for(i=3; i<=NUMSPECS-100; i++) {
		if(!Sflags[i]) {
		    if(m) {
			/*
			 * copy old value
			 */
			switch(100+i) {
				case CONHOST:
					Smptr->hname = m->hname;
					break;

				case CONIP:
					movebytes(Smptr->hostip,m->hostip,4);
					Smptr->mstat = m->mstat;
					break;

				case CONGATE:
					/*
					 * gateways cannot be copied from
					 */
					Smptr->gateway = 0;
					break;

				case CONNS:
					/*
					 * can't copy nameservers either
					 */
					Smptr->nameserv = 0;
					break;

				case CONRETR:
					Smptr->retrans = m->retrans;
					break;

				case CONWIND:
					Smptr->window = m->window;
					break;

				case CONSEG:
					Smptr->maxseg = m->maxseg;
					break;

				case CONMTU:
					Smptr->mtu = m->mtu;
					break;

				case CONDELETE:
					Smptr->delete = m->delete;
					break;

				case CONCRMAP:
					Smptr->crmap = m->crmap;
					break;

				case CONDUP:
					Smptr->halfdup = m->halfdup;
					break;

				case CONTO:
					Smptr->conto = m->conto;
					break;

				case CONPORT:
					Smptr->port = m->port;
					break;

				default:
					break;
			}
		    } else {
			/*
			 * m=NULL, install default values
			 */
			switch(100+i) {
				case CONHOST:
					Smptr->hname = NULL;
					break;

				case CONIP:
					Smptr->mstat = NOIP;
					break;

				case CONGATE:
					/*
					 * gateways cannot be copied from
					 */
					Smptr->gateway = 0;
					break;

				case CONNS:
					/*
					 * can't copy nameservers either
					 */
					Smptr->nameserv = 0;
					break;

				case CONRETR:
					Smptr->retrans = MINRTO;
					break;

				case CONWIND:
					Smptr->window = DEFWINDOW;
					break;

				case CONSEG:
					Smptr->maxseg = DEFSEG;
						break;
				case CONMTU:
					Smptr->mtu = TSENDSIZE;
					break;

				case CONTO:
					Smptr->conto = CONNWAITTIME;
					break;

				case CONDELETE:
					Smptr->delete = 127;
					break;

				case CONCRMAP:
					Smptr->crmap = 0;
					break;

				case CONDUP:
					Smptr->halfdup = 0;
					break;

				case CONPORT:
					/*
					 * the default port
					 */
					Smptr->port = 0;
					break;

				default:
					break;
			}
		    }
		}
	}
	/*
	 * set that this machine was copied
	 */
	Sflags[0] = 1;
}

                                                                                                                                                                                                                                                                                                                                                                                                      