/* ipchk.c */

/*
 *	Includes
 */

#include <stdio.h>

#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "tcpdat.h"
#include "bytprc.h"
#include "hdrchk.h"

/*
 *  ipinterpret
 *
 *  Called by the packet demuxer to interpret a new ip packet.  Checks the
 *  validity of the packet (checksum, flags) and then passes it on to the
 *  appropriate protocol handler.
 *
 */
int ipinterpret(pkt)
register IPKT *pkt;
{
	register int iplen,i;

	/*
	 *  Check to make sure that the packet is for me.
	 *  Accepts packets if my IP address is 0.0.0.0 (not yet defined)
	 *  or the packets are directed to my IP address.
	 *
	 *  Throws out all other packets.
	 */
	if(!comparen(nnipnum,pkt->i.ipdest,4) &&
		nnipnum[0]|nnipnum[1]|nnipnum[2]|nnipnum[3]) {
		return(1);
	}

	/*
	 *  Check IP version and IP options.
	 *  We don't understand IP options,
	 *  post a warning to the user and drop the packet.
	 */
	if (pkt->i.versionandhdrlen != 0x45) {
		skposterr(300);
		return(1);
	}

	/*
	 *  checksum verification of IP header
	 *  no IP checksumming if check=0
	 */
	if (pkt->i.check) {
		if(ipcheck(&pkt->i.versionandhdrlen, sizeof(IPLAYER)/2)) {
			skposterr(301);		/* bad IP checksum */
			return(1); 		/* drop packet */
		}
	} 

	/*
	 *  Process fragmented IP packets
	 */
	if(pkt->i.frags&~0x40) {
		skposterr(302);
		return(1);
	}

	/*
	 *  Extract total length of packet
	 */
	iplen = intswap(pkt->i.tlen) - sizeof(IPLAYER);

	/*
	 *  which protocol to handle this packet?
	 */
	switch (pkt->i.protocol) {
		case PROTUDP:
			return(udpinterpret((UDPKT *)pkt,iplen));

		case PROTTCP:
			return(tcpinterpret((TCPKT *)pkt,iplen));

		default:
			skposterr(303);
			return(1);
	}
	return(0);
}	
                                                                                                                                                                                                                                    