/* ftppi7.c */

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vftpsb.h"
#include "debug.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "ftppi.h"
#include "rtfile.h"
#include "sesutl.h"
#include "sktlib.h"
#include "kbdutl.h"
#include "inierr.h"
#include "cticks.h"
#include "suspnd.h"
#include "ftpsb.h"

int ftppi7(cmdno,command)
register int cmdno;
register char *command;
{
	register int i;
	char cmndline[82];
	char word[50];

	switch(cmdno) {
	case RMDIR:		/* remove remote dir */
		if(askq(command,79,"Directory: "))
			return;
		/*
		 * try XRMD
		 */
		sprintf(cmndline,"XRMD %s",command);
		if(ftpdo(cmndline) != ERROR)
			return;
		kb_puts("Trying again...\r\n");
		/*
		 * try RMD
		 */
		sprintf(cmndline,"RMD %s",command);
		ftpdo(cmndline);
		return;
	
	case SYSTEM:		/* get remote system type */
		i = verbose;
		verbose = TRUE;
		ftpdo("SYST");
		verbose = i;
		return;

	case TYPE:		/* type a remote file */
		if(askq(command,79,"File: "))
			return;
		getword(command,word);
		sprintf(cmndline,"RETR %s tt:tt.tt",word);
		ftpdo(cmndline);
		return;		

	case USER:		/* login to remote machine */
		if(askq(command,79,"Username: "))
			return;
		/*
		 * username
		 */
		sprintf(cmndline,"USER %s",command);
		if(ftpdo(cmndline) == TRUE)
			return;
		/*
		 * password
		 */
		kb_puts("Password: ");
		if(ftpgets(command,100,0) == ABORT)
			return;
		sprintf(cmndline,"PASS %s",command);
		if(ftpdo(cmndline) == INCOMPLETE) {
			/*
			 * if account needed
			 */
			*command = '\0';
			if(askq(command,79,"Account: "))
				return;
			sprintf(cmndline,"ACCT %s",command);
			ftpdo(cmndline);
		}
		return;
		
	default:
		return;
	}
}
                                                                                                                                                                                                                     