/* btpdat.h */

/*
 * Bootstrap Protocol (BOOTP).  RFC 951.
 */

typedef struct { char addr[4]; } iaddr_t;

#define	BPREQUEST	1
#define	BPREPLY		2

struct bootp {
	char	bp_op;		/* packet opcode type */
	char	bp_htype;	/* hardware addr type */
	char	bp_hlen;	/* hardware addr length */
	char	bp_hops;	/* gateway hops */
	long	bp_xid;		/* transaction ID */
	unsigned
	int	bp_secs;	/* seconds since boot began */	
	unsigned
	int	bp_unused;
	iaddr_t	bp_ciaddr;	/* client IP address */
	iaddr_t	bp_yiaddr;	/* 'your' IP address */
	iaddr_t	bp_siaddr;	/* server IP address */
	iaddr_t	bp_giaddr;	/* gateway IP address */
	char	bp_chaddr[16];	/* client hardware address */
	char	bp_sname[64];	/* server host name */
	char	bp_file[128];	/* boot file name */
	char	bp_vend[64];	/* vendor-specific area */
};

/*
 * UDP port numbers, server and client.
 */
#define	IP_BPS		67
#define	IP_BPC		68

/*
 * "vendor" data permitted for Stanford boot clients.
 */
struct vend {
	char	v_magic[4];	/* magic number */
	long	v_flags;	/* flags/opcodes, etc. */
	char	v_unused[56];	/* currently unused */
};

#define	VM_STANFORD	"STAN"	/* v_magic for Stanford */
#define VM_RFC1048      "\143\202\123\143"

/* v_flags values */
#define	VF_BOOT			1	/* wants environment info */
#define	VF_HELP			2	/* help me, I'm not registered */
#define TAG_BOOTFILE_SIZE       13     /* tag used by vend fields rfc 1048 */

#define BTP_RETRIES   10

                                                                    