/* sktmon.c */

/*
 * Includes
 */
#include <stdio.h>
#include <string.h>

#include "vrsion.h"
#include "vtcpip.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "prodat.h"
#include "tcpdat.h"
#include "bytprc.h"
#include "suspnd.h"
#include "termio.h"

#include "fmtdat.h"
#include "vt1xx.h"

char *cstate[] = {
	"illegal",
	"SCLOSED",
	"SLISTEN",
	"STWAIT",
	"SSYNR",
	"SSYNS",
	"SEST",
	"SFW1",
	"SFW2",
	"SCLOSING",
	"SCWAIT",
	"SLAST"
};

routine[] = {
	&scrn1,	&scrn2,
	&scrn3, &scrn4,
	&scrnA,	&scrnB,	&scrnC,
	&scrnD,	&scrnE,	&scrnF,
	&scrnG,	&scrnH,	&scrnI,
	&scrnJ,	&scrnK,	&scrnL,
	&scrnM,	&scrnN,	&scrnO,
	&scrnP,	&scrnQ,	&scrnR,
	&scrnS,	&scrnT,	&scrnU,
	&scrnV,	&scrnW, &scrnX,
	&scrn1,	&scrnZ
};

char filstr[80];

extern int fndbrk;

main(argc,argv)
int argc;
char *argv[];
{
	register struct socket *skt;
	register int c,newsel,sel;
	char s[80];
	int sknum;
	int (*r) ();

	if(argc!=2) {
		printf("Usage: sktmon socket#\r\n");
		return(0);
	}

	sscanf(argv[1],"%d",&sknum);

	skt = (struct socket *) mapskt(sknum);
	if(skt==-1) {
		printf("SCKT%02.2d not defined\r\n", sknum);
		suspnd(120);
	}

	strcpy(filstr,"[NoFile]");

	tt_init(0x03);
	outekp();
	outclr();
	fmtrow = SCRNBT-SCRNTP;
	fmtcol = 0;
	outpos(0,SCRNBT-SCRNTP);
	fmtclr();
	sel = 0;
	do {
		r = routine[sel];
		skt = (struct socket *) mapskt(sknum);
		if(skt==-1) {
			if ((r == &scrn1) || (r == &scrn2) ||
			    (r == &scrn3) || (r == &scrn4) ||
			    (r == &scrnZ)) {
				(*r) (sknum);
			} else {
				sprintf(s,"SCKT%02.2d not defined", sknum);
				fmtplc(s,SCRNBT-SCRNTP-1);
			}
		} else {
			(*r) (sknum);
		}
		outscan();
		suspnd(120);
		c = toupper(syscin());
		newsel = -1;
		if(c==CR || c==ENTER) {
			c = tt_sckt(sknum);
			if(c>=0 && c!=sknum) {
				sknum = c;
				newsel = sel;
			}
		} else 
		if(c==SELECT) {
			c = tt_file(sknum);
			if(c>=0 && c!=sknum) {
				sknum = c;
				newsel = sel;
			}
		}
		if('1'<=c && c<='4') {
			newsel = c - '1';
		}
		if('A'<=c && c<='Z') {
			newsel = 4 + c - 'A';
		}
		if(c==CTRLW) {
			newsel = sel;
		}
		if(newsel>=0) {
			sel = newsel;
			outclr();
			fmtclr();
		}
	} while(!fndbrk);

	outdkp();
	return(0);
}


int tt_sckt(sknum)
int sknum;
{
	register struct socket *skt;
	char c,s[80];
	int num;


	num = -1;
	outpos(0,SCRNBT-SCRNTP);
	outdeol();
	outpos(0,SCRNBT-SCRNTP-1);
	outdeol();
	tt_puts("Enter SCKT number -> ");

	s[0] = '\0';
	do {
		suspnd(0);
		c = tt_gets(s,80,1);
	} while((c!=CR) & (c!=ENTER) & !fndbrk);

	if((c==CR || c==ENTER) && s[0] != '\0') {
		sscanf(s,"%d",&num);
		if(num>=0) {
			skt = (struct socket *) mapskt(num);
			if(skt==-1) {
				sprintf(s,"SCKT%02.2d not defined", num);
				outpos(0,SCRNBT-SCRNTP);
				tt_puts(s);
				num = -1;
			}
		} else {
			c = ESCAPE;
		}			
	} else {
		c = ESCAPE;
	}
	if(num>=0 && num<MSCKTS) {
		sknum = num;
		c = ESCAPE;
	}
	if(c == ESCAPE) {
		outpos(0,SCRNBT-SCRNTP-1);
		outdeol();
		outpos(0,SCRNBT-SCRNTP);
		outdeol();
	}
	return(sknum);
}

int tt_file(sknum)
int sknum;
{
	char c,filnam[80],s[80];
	register struct socket *skt;
	FILE *fp;

	sknum = -1;
	outpos(0,SCRNBT-SCRNTP);
	outdeol();
	outpos(0,SCRNBT-SCRNTP-1);
	outdeol();
	tt_puts("Enter PKT file name -> ");

	filnam[0] = '\0';
	do {
		suspnd(0);
		c = tt_gets(filnam,80,1);
	} while((c!=CR) & (c!=ENTER) & !fndbrk);

	if((c==CR || c==ENTER) && filnam[0] != '\0') {
		skt = (struct socket *) makskt(MSCKTS-1);
		if(skt!=-1) {
			clrskt(skt);

			fp = (FILE *) fopen(filnam,"rn");
			if(fp!=NULL) {
				fread(&skt->tcpout, sizeof(TCPKT), 1, fp);
				fclose(fp);
				strcpy(filstr,filnam);
				sknum = MSCKTS - 1;
			} else {
				sprintf(s,"File %s not found", filnam);
				outpos(0,SCRNBT-SCRNTP);
				tt_puts(s);
				strcpy(filstr,"[NoFile]");
				sknum = -1;
			}
		}
	} else {
		c = ESCAPE;
	}
	if(sknum == (MSCKTS-1)) {
		c = ESCAPE;
	}
	if(c == ESCAPE) {
		outpos(0,SCRNBT-SCRNTP-1);
		outdeol();
		outpos(0,SCRNBT-SCRNTP);
		outdeol();
	}
	return(sknum);
}

/*
 *  tt_gets()
 *
 *  This routine will continually add to a string that is re-submitted
 *  until a special character is hit.  It never blocks.
 *
 *  As long as editing characters (bksp, delete, Ctrl-U) and printable
 *  characters are pressed, this routine will update the string.
 *  When any other special character is hit, that character is discarded.
 */

int tt_gets(s,lim,echo)
register char *s;
char echo;
int lim;
{
	register int c,count;
	int i;
	char *save;

	count = strlen(s);
	save = s;
	s += count;
	while((c = syscin()) != 0) {
		/* allow certain editing chars */
		switch (c) {
		case 8:		/* backspace */
		case 127:	/* delete */
			if(count) {
				if (echo) {
					tt_out(8);
					tt_out(' ');
					tt_out(8);
				}
				/* one less character */
				count--;
				/* move pointer backward */
				s--;
			}
			break;

		case 9:		/* HT */
			*s++ = ' ';
			break;

		case 13:	/* CR */
		case ENTER:	/* ENTER */
			/* terminate the string */
			*s = '\0';
			return(c);

		case 21:	/* ^U */
			if (echo)
				for(i=0; i<s-save; i++) {
					tt_out(8);
					tt_out(' ');
					tt_out(8);
				}
			s = save;
			break;

		default:
			/* to length limit */
			if(count==lim) {
				tt_out(7);
				/* terminate */
				*s = '\0';
				return(0);
			}
			if(c>31 && c<127) {
				if (echo)
					tt_out(c);
				/* add to string */
				*s++ = (char)c;
				/* length of string */
				count++;
			}
		break;
		}
	}
	/* terminate the string */
	*s = '\0';
	return(c);
}
                                                                                                                                                                                                                                                                                                                                                                         