/* rhttp.c */

#define	RHTTPMASTER

/*
 *  Includes
 */
#include <stdio.h>
#include <string.h>

#include "os.h"
#include "vrsion.h"
#include "vrhttp.h"
#include "dfault.h"
#include "evtdef.h"
#include "hstdef.h"
#include "prodef.h"
#include "cliutl.h"
#include "cticks.h"
#include "tsxutl.h"
#include "kbdutl.h"
#include "rtfile.h"
#include "inicli.h"
#include "suspnd.h"

/*
 * Internal routines
 */

/*
 * Due to DECUS C aborts from lack of space
 * all functions/subroutines of type 'int'
 * are no longer explicitly defined.
 *
 * DECUS C defaults to 'int', VOID == int
 */

#if 0
extern	int	dosess();	/* rhttp spinner */
extern	int	getword();	/* (string,word) extract a word */
extern	int	hcequal();	/* (s,t) compare string */
extern	int	hcmnds();	/* (s) return command index */
extern	VOID	printtxt();	/* (txt) print text */
extern	int	sethttp();	/* setup to receive incoming HTTP request */
extern	VOID	strlwr();	/* (st) convert string to lower case */
extern	VOID	rhttpresp();	/* (s) send response to net */
extern	VOID	rhttpd();	/* (code) rhttp function decoder */
#endif

extern	char	*stptok();	/* (p,t,i,d) stop on token */
extern	char	*stpblk();	/* (ch) skip to chars */

/*
 * HTTP Commands
 */

#define	H_GET	0
#define H_HEAD	1
#define H_POST	2
#define H_NULL	3	/* NO MATCH */

static
char *h_clist[] = {
	"GET",	"HEAD",	"POST"
};

/*
 * HTTP Modes
 */

#define	HASCII		0
#define	HBINARY		1

/*
 *	Defines
 */

/*
 * READSIZE is the system BLOCK SIZE
 * BUFFERS must be an integral multiple of READSIZE
 */

#define BUFFERS		8192
#define	READSIZE	512
#define	RSPSTRING	200
#define GENBUFR		128

/*
 * Transfer Delay Time Limits
 */

#define	MINTFRDLY	3
#define	MAXTFRDLY	15

/*
 *	Global Variables For RHTTP Control Channel
 */

static int
	aflag = 0,		/* Attach to Service Flag */
	rflag = 0,		/* RHTTP restart flag */
	httpcskt = -1,		/* socket for incoming http */
	tfrdly = 0,		/* transfer suspend time */
	mflag = 0,		/* monitor processing */
	waitpos = 0,		/* marker for gathering strings from net */
	rfstate = 0,		/* state of the control channel */
	retstate = 0,		/* to emulate a subroutine call */
	rcnt = 0,		/* transfer count */
	finished = TRUE,	/* file transfer flag */
	httpfh = 0,		/* file handle for http data */
	httpfilemode = HBINARY,	/* file transfer mode */
	xp = 0,			/* general array index */
	towrite = 0;		/* file -> net  counter */

int	zflag = 0;		/* inactivity timeout flag */

long	izaptime = 0L;		/* inactivity zap time in ticks */


/*
 *	Global Buffers / Pointers
 */

char	xs[BUFFERS];		/* buffer space for file transfer */

static char
	command[GENBUFR],	/* command string */
	rsp[RSPSTRING],		/* response string */
	scratch[GENBUFR];	/* scratch string */

static char *
	httppath = NULL;	/* HTTP path and HOME file */

static char
	filespec[GENBUFR],	/* file specification string */
	homefile[GENBUFR];	/* HOME HTML file name */

/*
 * Debugging options
 *
 *	bit 0	(0x01)	debug internal events
 *	bit 1	(0x02)	debug dosess
 *	bit 2	(0x04)	debug rhttpd()
 */

#if ts$sys
static char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       " RHTTP [?] [-d level] [-p filespec] [-z s] [-aerv]",
       "	?		List the Help Text and Exit RHTTP",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable dosess() printing",
       "		4 -	enable rhttpd() printing",
#else
       " RHTTP [?] [-p filespec] [-z s] [-aerv]",
       "	?		List the Help Text and Exit RHTTP",
#endif
       "	a		Attach to Service",
       "	e		Enable Monitoring of all RHTTP Transactions",
       "	p		Specify the HTTP Directory and Home File",
       "	r		Restart RHTTP after Disconnect",
       "	v		Verbose Mode",
       "	z  s		Inactivity Timeout in seconds",
       "",
       0
       };
#endif

#if rt$sys
static char *usetxt[] = {
       "",
#ifdef	DEBUGOPTION
       " RHTTP [?] [-d level] [-p filespec] [-z s] [-erv]",
       "	?		List the Help Text and Exit RHTTP",
       "	d  level	Debug Level",
       "		1 -	enable event printing",
       "		2 -	enable dosess() printing",
       "		4 -	enable rhttpd() printing",
#else
       " RHTTP [?] [-p filespec] [-z s] [-erv]",
       "	?		List the Help Text and Exit RHTTP",
#endif
       "	e		Enable Monitoring of all RHTTP Transactions",
       "	p		Specify the HTTP Directory and Home File",
       "	r		Restart RHTTP after Disconnect",
       "	v		Verbose Mode",
       "	z  s		Inactivity Timeout in seconds",
       "",
       0
       };
#endif

/*
 *  printout text
 */
VOID printtxt(txt)
char **txt;
{
	register char **dp;

	for (dp = txt; *dp; dp++) {
		if (**dp == '_') {
			kb_puts(*dp + 1);
		} else {
			kb_puts(*dp);
			kb_nline();
		}
	}
}


main(argc,argv)
int argc;
char *argv[];
{
	int ev,i,j,k;
	register char c;
	register struct socket *skt;

	/*
	 * Initialize for TSX+ clients
	 */
	inicli();

	/*
	 * Initialize kb handler
	 * Set the break character to ^C
	 */
	kb_init(0x03);

	/*
	 * Verbose Mode Off
	 */
	kb_prnt = 0;

	/*
	 * parse arguments
	 */
	for(i=1; i<argc; i++) {
		if(argv[i][0] == '?') {
		    kb_prnt = 1;
		    printtxt(usetxt);
		    exit(0);
		} else
		if(argv[i][0] == '-') {
		    j = i;
		    k = 1;
		    while((c = argv[j][k]) != '\0') {
			switch(tolower(c)) {
#if ts$sys
			case 'a':	/* attach to service */
				aflag = 1;
				break;
#endif
#ifdef	DEBUGOPTION
			case 'd':	/* debug, optional level */
				if(sscanf(argv[++i],"%d",&debug) <= 0)
					debug = -1;
				break;
#endif
			case 'e':	/* enable RHTTP monitoring */
				mflag = 1;
				break;

			case 'p':	/* HTTP Directory */
				httppath = argv[++i];
				break;

			case 'r':	/* enable RHTTP restarting */
				rflag = 1;
				break;
#if ts$sys
			/*
			 * This is a 'hidden' option for setting the
			 * the default subdirectory base 'ld' unit
			 * and setting the maximum subdirectory nesting
			 *	note:	subdbase + subdnest <= 8
			 */
			case 's':
				sscanf(argv[++i],"%d",&subdbase);
				sscanf(argv[++i],"%d",&subdnest);
				break;
#endif
			case 'v':	/* verbose mode on */
				kb_prnt = 1;
				break;

			case 'z':	/* inactivity timeout flag */
				sscanf(argv[++i],"%d",&zflag);
				izaptime = 60L * zflag;
				break;

			default:	/* unknown option */
				printf(
				"Unrecognized option -%c ignored\r\n", c);
				break;
			}
			k++;
		    }
		}
	}

#ifdef	DEBUGOPTION
	if (debug)
		kb_prnt = 1;
#endif

	/*
	 * identify self
	 */
	printtxt(vrstxt);

	/*
	 *  Start listening to the HTTP port
	 */
	while(((httpcskt = sethttp()) < 0) && !fndbrk) {
		/*
		 * Could not get a socket, wait 5 seconds
		 */
		suspnd(300);
	}

	while(!fndbrk && ev != -1) {
		ev = dosess();
		if(ev==0)
			suspnd(0);
	}

	if(fndbrk) 
		kb_puts("\r\n^C\r\n");

	skclose(httpcskt);
	skrelease(httpcskt,1);

	suspnd(0);
	errhandle();

	cd("dk:");

	kb_puts("\r\nEscaping from RHTTP\r\n");
	exit(0);
}

/*
 *  dosess
 *
 *  dosess is an infinite loop serving message events
 */
int dosess()
{
	int  cl,ev,dat;

	/*
	 * Check for any relevant messages
	 * that need to be handled by me
	 */
	ev = Sgetevent(SCKTCLASS | CONCLASS | USERCLASS |
			ERRCLASS | MSGCLASS | ABORTCLASS, &cl, &dat);
	if(ev!=0) {

#ifdef	DEBUGOPTION
if(debug&0x02) {
	printf("dosess(): cl = %d, ev = %d, dat = %u\r\n", cl,ev,dat);
}
#endif

	  switch(cl) {
	    case CONCLASS:
	      /*
	       * RHTTP Connection socket
	       */
	      rhttpd(ev);
	      break;

	    case MSGCLASS:	/* messages */
	    case ERRCLASS:	/* error message */
	      kb_puts(skerrstring(ev));
	      kb_nline();
	      break;

	    case ABORTCLASS:	/* abort */
	      switch(ev) {
		case CLIENT:
		  /*
		   * disable automatic restart
		   */
		  rflag = 0;
		  kb_puts("\r\nRHTTP session aborted by TCPIP\r\n");
		  Stmrset(ABORTCLASS,EXITABORT,dat,5);

		case USERABORT:
		  if(skrelease(dat,0) < 0) {
		    return(-1);
		  } else {
		    skclose(dat);
		    Stmrset(ABORTCLASS,USERABORT,dat,1);
		  }
		  break;

		case EXITABORT:
		  return(-1);
		  break;

		default:
		  break;
	      }
	      break;

	    default:
	      break;
	  }
	} else {
	  rhttpd(0);
	}

	return(ev);
}

/*
 *	set up to receive connection for http commands
 */
int sethttp()
{
	int sknum;

	rfstate = 0;		/* state of the control channel */
	retstate = 0;		/* to emulate a subroutine call */
	rcnt = 0;		/* number of characters from control */

	/*
	 * Set the default directory
	 */
	cd("dk:");

	/*
	 * Initialize various things
	 */
	Snetinit();

	/*
	 * aflag = 1	indicates attach mode
	 * aflag = 0	indicates listen mode
	 */
	if(aflag) {
		/*
		 * Attach job to connection opened by TCPIP
		 */
		sknum = attach(0,HHTTP);
		if(sknum==-1) {
			fndbrk++;
			return(-1);
		} else {
			Stmrset(ABORTCLASS,CLIENT,sknum,CONNWAITTIME);
		}
	} else {
		/*
		 * Create socket for control connection
		 */
		sknum = socket(0);
		if(sknum==-1)
			return(-1);
		/*
		 * default port
		 */
		listen(sknum,HHTTP);
	}
	return(sknum);
}

/*
 * Dump response to client
 */
VOID rhttpresp(s)
register char *s;
{
	skwrite(httpcskt, s, strlen(s));
	skwrite(httpcskt, "\r\n", 2);
	skenque(httpcskt, 1);
	if(mflag) {
		kb_puts(s);
		kbprintf("  {%d}\r\n", strlen(s)+2);
	}
}

/*
 * This is the error print routine for TSXUTL.C
 * It will be called only if there is an internal error
 */
VOID lsterr()
{
	if(*errstr) {
		kb_puts(errstr);
		kb_nline();
		errstr[0] = '\0';
	}
}

/*
 * This routine is a dumby routine for TSXUTL.C
 * It should never be called, but returns a 1 [ABORT]
 */
int rtresp()
{
	kb_puts("rtresp: This dumby routine should never be called");
	return(1);
}

/*
 *	Remote HTTP Server
 */
VOID rhttpd(code)
int code;
{
	char *p,*q;
	char word[80];
	int i,icnt,rhttpcmnd;

	if(httpcskt < 0)
		return;

	switch(rfstate) {
		case 0:
			switch(code) {
			case CONOPEN:
				Stmrunset(ABORTCLASS,CLIENT,httpcskt);

				/*
				 * Enable Timeout
				 */
				cticks(&skquetime);

				/*
				 * Verify HTTP Path
				 */
				if((httppath == NULL) ||
				  ((p = setpath(httppath)) == NULL)) {
					sprintf(rsp,
	/*Net*/
	"500 Internal Server Error"
	/*Net*/
						);
					rhttpresp(rsp);
					rcnt = -1;
					break;
				}
				/*
				 * Save HTTP Path and HOME File Name
				 */
				strcpy(homefile,p);
				getpath(filespec);

				retstate = 1;
				rfstate = 50;
				waitpos = 0; 
				rcnt = 0;
				break;

			case CONCLOSE:
				rcnt = -1;
				break;

			case CONFAIL:
				rcnt = -1;
				break;

			default:
				break;
			}
			break;

		case 1:
			/*
			 * interpret HTTP command
			 */
			if(getword(command,word) == FALSE) {
				sprintf(rsp,
	/*Net*/
	"400 Bad Request"
	/*Net*/
					);
				rhttpresp(rsp);
				rcnt = -1;
				break;
			}

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("rhttpd(%d): %s %s\r\n", code,word,command);
}
#endif

			strlwr(command);
			rhttpcmnd = hcmnd(word);
			switch(rhttpcmnd) {
			case H_GET:
				getword(command,word);
				/*
				 * Skip /
				 */
				if(strlen(word) <= 1) {
					strcpy(filespec,homefile);
					/*
					 * Log Session
					 */
					sprintf(scratch,
	/*Log*/
	"RHTTP"
	/*Log*/
						);
					logsession(httpcskt,scratch);
				} else
				if(strchr(word,':')) {
					sprintf(rsp,
	/*Net*/
	"401 Unauthorized [%s]", word
	/*Net*/
						);
					rhttpresp(rsp);
					rcnt = -1;
				} else
				if(strchr(word+1,'/')) {
					strcat(filespec,word);
				} else {
					strcpy(filespec,word+1);
				}
				/*
				 * Trim off trailing '/'
				 */
				p = filespec + strlen(filespec) - 1;
				while(*p=='/') {
					*p = 0;
					--p;
				}
				/*
				 * Open file
				 */
				if((httpfh=rtopen(filespec,"rn",0,0))==NULL) {
					sprintf(rsp,
	/*Net*/
	"404 Not Found [%s]", filespec
	/*Net*/
						);
					rhttpresp(rsp);
					rcnt = -1;
				} else {
					/*
					 * check file type
					 */
					rmtfile(filespec);
					p = rtext();
					if(streq(p,"htm") ||
					   streq(p,"txt") ||
					   streq(p,"doc") ||
					   streq(p,"lst")) {
						httpfilemode = HASCII;
					} else {
						httpfilemode = HBINARY;
					}
					/*
					 * ready for data
					 */
					rfstate = 20;
				}
				break;

			case H_HEAD:
				sprintf(rsp,
	/*Net*/
	"200 OK"
	/*Net*/
					);
				rhttpresp(rsp);
				rcnt = -1;
				break;

			case H_POST:
			default:
				/*
				 * unimplemented commands
				 */
				sprintf(rsp,
	/*Net*/
	"501 Not Implemented [%s]", h_clist[rhttpcmnd]
	/*Net*/
					);
				rhttpresp(rsp);
				rcnt = -1;
				break;
			}
			break;

		case 20:
			/*
			 * Initialize parameters
			 */
			finished = FALSE;
			towrite = 0;
			xp = 0;
			tfrdly = MINTFRDLY;
			rfstate = 21;

		case 21:
			/*
			 * transfer file to the
			 * other host via http request
			 * file is already open=httpfh
			 */

			if(skqued(httpcskt)) {
				if(tfrdly<MAXTFRDLY) tfrdly++;
			} else {
				if(tfrdly>MINTFRDLY) --tfrdly;
			}

			if(towrite <= xp && finished == FALSE) {
				/*
				 * need to read again
				 */
				for(p=xs,i=0; i<BUFFERS; i+=READSIZE) {
				    if(rcnt = fread(p,1,READSIZE,httpfh)) {
					p += rcnt;
				    } else {
					finished = TRUE;
					break;
				    }
				}
				rcnt = p - xs;
				if(httpfilemode == HASCII) {
				    for (p=q=xs,i=0; i<rcnt; i++) {
					if (!(*p++ = *q++)) {
					    --p;
					}
				    }
				    rcnt = p - xs;
				}
				towrite = rcnt;
				xp = 0;
			}
			rcnt = towrite - xp;
			if(rcnt > 0) {
				rcnt = skwrite(httpcskt,&xs[xp],rcnt);
			}
			if(rcnt > 0) {
				/*
				 * write successful
				 * adjust counts and queue data
				 */
				xp += rcnt;
				skenque(httpcskt,0);
			}
			/*
			 * done if:  the file
			 * is all read from disk
			 * and all sent or other side
			 * has ruined connection
			 */
			if((towrite <= xp && finished == TRUE) ||
				sktest(httpcskt)) {
				if(httpfh != NULL) {
					rtclose(httpfh);
					httpfh = NULL;
				}
				rfstate = 22;
			} else {
				if(skqued(httpcskt)) {
					suspnd(tfrdly);
				}
				suspnd(-1);
				break;
			}

		case 22:
			/* send done
			 * wait for other side to accept
			 * everything and then start close
			 */
			if(0 >= skenque(httpcskt,1) || sktest(httpcskt)) {
				rcnt = -1;
			}
			break;

		case 50:
			/*
			 * subroutine to wait
			 * for a particular character
			 */
			icnt = 0;
			while(0<(rcnt=skread(httpcskt,&command[waitpos],1))) {
				icnt = 1;
				if(command[waitpos] == '\n') {
					rfstate = retstate;
					/*
					 * find end of string
					 */
					while (	(command[waitpos] < 33) &&
						(waitpos >= 0) )
						waitpos--;
					/*
					 * put in terminator
					 */
					command[++waitpos] = '\0';
					/*
					 * want upper case
					 */
					for(i=0; i<4; i++)
					    command[i] = toupper(command[i]);
					/*
					 * Empty Input Quueue
					 */
					while(0<skread(httpcskt,word,80)) {
						;
					}
					break;
				} else {
					if(waitpos < GENBUFR-1)
						waitpos += rcnt;
				}
			}
			if (icnt) {
				skdeque(httpcskt);
				suspnd(-1);
			}
			break;

		default:
			break;
	}

	/*
	 * Process Inactivity Timeout
	 */
	if((rfstate != 0) &&
	   (zflag != 0) &&
	   (skquetime != 0L) &&
	   (elapsed(skquetime) > izaptime)) {
		rcnt = -1;
	}

	if(rcnt < 0) {

#ifdef	DEBUGOPTION
if(debug&0x04) {
	printf("rhttpd(%d): rfstate = %d, rcnt = %d\r\n",
		code,rfstate,rcnt);
}
#endif
		if(httpfh != NULL) {
			rtclose(httpfh);
			httpfh = NULL;
		}
		if(httpcskt >= 0) {
			sksendwait(httpcskt,(long) SENDWAIT);
			skclose(httpcskt);
			httpcskt = skrelease(httpcskt,1);
		}
		if(rflag && !aflag) {
			/*
			 *  Start listening to the HTTP port
			 */
			while((httpcskt = sethttp()) < 0 && !fndbrk) {
				/*
				 * Could not get a socket, wait 5 seconds
				 */
				suspnd(300);
			}
		} else {
			fndbrk = 1;
		}
	}
}

/*
 * Find Matching Command
 */
int hcmnd(s)
char *s;
{
	register int i;

	for (i=0; i<H_NULL; i++) {
		if (hcequal(s,h_clist[i])) {
			return(i);
		}
	}
	return(H_NULL);
}

/*
 * Command Compare Routine
 */
int hcequal(s,t)
register char *s,*t;
{
	register int i,l;

	l = strlen(t);
	for(i=0; i<l; s++,t++,i++) {
		if(toupper(*s) != *t) {
			return(0);
		}
	}
	return(1);
}

/*
 * getword: remove a word from a string.  Things within quotes are
 * assumed to be one word.
 * return TRUE on success, FALSE on end of string
 */

static int getword(string,word)
char *string;
register char *word;
{
	register char *p;
	register int i;
	char *q;

	i = 0;

	/*
	 * skip leading blanks
	 */
	p = stpblk(string);
	if(!(*p)) {
		/*
		 * no words in string
		 */
		word[0] = '\0';
		return(FALSE);
	}
	if(*p == '\"') {
		/*
		 * word delimited by quotes
		 */
		while(p[++i] && p[i] != '\"')
			word[i-1] = p[i];
		word[i-1] = '\0';
		if(!p[i]) {
			/*
			 * Missing \". Assumed at end of string.
			 */
		} else {
			i++;
		}
		q = p+i;
	} else {
		/*
		 * get word, max len 79
		 */
		q = stptok(p, word, 79, " \t\r\n");
	}
     	/*
	 * remove trailing blanks
	 */
	p = stpblk(q);
	/*
	 * remove extracted stuff
	 */
	strcpy(string,p);
	return(TRUE);
}

static char *stptok( p, toword, ilen, delim)
register char *p;
char *toword;
int ilen;
char *delim;
 
{
	register char *adv;
	register int i;
	int j,end;
 
	adv = toword;
	end = 0;
	j = strlen(delim);

 	do { 
 		for(i=0; i<j; i++)
 			if(*p == delim[i] || (!*p))
				end++;
 		if(!end) {
 			if(adv >= (toword+ilen-1)) 
				end++;
 			*adv++=*p++;
 		}
 	} while(!end);
 	*adv='\0';
 	return(p);
}
 
char *stpblk(ch)
register char *ch;
 
{
 	while(*ch == ' ' || *ch == '\t') ch++;
 	return(ch);
}

static VOID strlwr(st)
register char *st;
{
	while(*st) {
		*st = tolower(*st);
		*st++;
	}
}
                                                                            