/*
 * Stdio header file.	Version of 01-Jul-82
 *
 * Edit history
 * 01 13-Aug-79 MM	Defined IOV to match the RSX package
 * 02 18-Mar-80	MM	Redefined everything for the new library
 * 03 14-May-80 MM	Do not define things twice
 * 04 13-Jun-80 MM	Define fwild stuff
 * 05 01-Aug-80 MM	Flag changes (IOV Version 08)
 * 06 15-Sep-80 RBD	Add cell for UIC under RSX.
 * 07 22-Sep-80 MM	Added VF$WLD
 * 08 25-Sep-80 MM	Removed VF$BAD
 * 09 17-Feb-81 MM	Added VMS runoff hack flag
 * 10 08-Oct-81 MM	Nothing special
 * 11 10-Mar-82 MM	Added documentation header
 * 12 14-Apr-82 JLB	Add RSTS stuff
 * 13 13-May-82 MM	Moved $$luns[] definition
 * 14 24-Jul-82	MM	Really redone
 * 15 02-Nov-82 MM	io_fdb is now a char array
 * 16 06-Dec-82 MM	More RSTS specific stuff
 */

#ifdef	DOCUMENTATION

title	stdio	Definitions for standard i/o library
index		Definitions for standard i/o library

Synopsis

	#include <stdio.h>

Description

	<stdio.h> should be included in the assembly of all C programs
	that use the standard i/o library (fopen(), getc(), printf(), etc.)
	.s
	It defines the following:
	.s
	  FILE	The  i/o  routines  use  and  return pointers to
		objects of this type.
	.s
	  NULL	I/O routines signal "rejection" by  returning  a
		null pointer.
	.s
	  EOF	The get character routine returns this value  to
		signal end of file.
	.s								
	  TRUE	The value 1.
	.s
	  FALSE	The value 0.
	.s
	  EOS	The "end of string" marker: '\0'.
	.s
	.br;##IO__SUCCESS#Normal exit to operating system.
	.s
	.br;##IO__WARNING#"Warning error" exit to operating system.
	.s
	.br;##IO__ERROR###"Error" exit to operating system.
	.s
	.br;##IO__FATAL###"Severe error" exit to operating system.
	.s
	stdin	The "standard" input file.  Normally the  user's
		terminal; it may be redirected.
	.s
	stdout	The "standard" output file.  Normally the user's
		terminal; it may be redirected.
	.s
	stderr	The "error" output file.  It will  always  write
		to the user's terminal.

Differences from Unix

	FILE is defined as a "typedef struc", rather than a #define.
	The i/o structure is considerably different from Unix.
	It is, however, arranged so that reasonable compatibility
	may be attained.  Specifically, things which have the same
	name are used for the same purpose, and located in the same
	place within the I/O structure.

Accessing the FDB on RSX modes

	The FDB (file data block) is the primary means of communication
	between the C I/O library and the RSX file control services
	modules.  It contains file and record format information as
	well as pointers and counters for accessing data in the file.
	It is highly recommended that you do not access this information
	directly.  Should you need to do so, the following may be done:
	
	  extern char *F_RTYP;	/* F.RTYP (char) in fdb	*/
	  extern char *F_SEQN;	/* F.SEQN  (int) in fdb	*/
	  ...
	  fd = fopen("file.nam", "r");
	  /*
	   * Set rtyp to the record type, stored as a
	   * byte at offset F.RTYP
	   */
	  rtyp = fd->io_fdb[(int) &F_RTYP] & 0377;
	  /*
	   * set seqn to the sequence number (printfile
	   * fixed header), stored as an integer at
	   * offset F.SEQN.
	   */
	  seqn = *((int *) &fd->io_fdb[(int) &F_SEQN]);

	The somewhat messy use of casts and addressing allows
	the program to use the value of F.xxx stored in the
	RSX system library.

Bugs

	TRUE, FALSE, and EOS are not present in <stdio.h> on
	some other C systems.
	.s
	If you compile with the /r switch (-r on RSX modes)
	or #define rsts before #include <stdio.h>, a native RSTS/E
	I/O vector will be defined which is neither fully supported
	nor fully implemented.

#endif

#ifndef	IO_OPN
/*
 * Note: _... is identical to Unix usage, while io_... is for Decus C
 */

typedef struct IOV {
	int	_cnt;		/* Bytes left in buffer	*/
	char	*_ptr;		/* Free spot in buffer	*/
	char	*_base;		/* Base of buffer	*/
	int	_flag;		/* Flag word 		*/
	int	io_wflag;	/* Wild card flags	*/
	char	*io_wild;	/* Wild card buffer	*/
	int	io_rbsz;	/* Record buffer size	*/
#ifdef	rsts
				/*
				 * RSTS native I/O
				 */
	int	io_rsflag;	/* RSTS specific flags	*/
	int	io_recm;	/* Record Modifier	*/
	int	io_wait;	/* Wait time		*/
	struct {		/* Block number		*/
	  unsigned int low;
	  unsigned int high;
	} io_rsbnbr;
#else
#ifdef	rt11
				/*
				 * RT11 specific
				 */
	int	io_lun;		/* RT11 unit number	*/
	int	io_bnbr;	/* Disk block number	*/
	int	io_size;	/* File size in blocks	*/
	char	*io_name;	/* File name pointer	*/
	char	io_dbuf[2];	/* Dummy record buffer	*/
#endif
#ifdef	rsx
				/*
				 * RSX specific
				 */
	char	*io_bbuf;	/* Block buffer start	*/
	int	io_uic;		/* File's UIC in binary	*/
	char	*io_dnam;	/* Directory name ptr.	*/
	char	io_fdb[0];	/* File data block	*/
#endif
#endif
} FILE;

#define	MAXLUN	15
extern	FILE	*$$luns[];	/* Lun table		*/

/*
 * Bits in ((FILE *)fd)->_flag:
 *	_NAME		Compatible with Unix usage
 *	IO_NAME		Decus C specific.
 */

#define	_IOREAD		0000001	/* Open for reading	*/
#define	_IOWRT		0000002	/* Open for writing	*/
#define	_IONBF		0000004	/* Unbuffered "u" mode	*/
#define	_IOMYBUF	0000010	/* io stuff got buffer	*/
#define	_IOEOF		0000020	/* Eof seen if set	*/
#define	_IOERR		0000040	/* Error seen if set	*/
#define	_IOSTRG		0000100	/* for sprintf, sscanf	*/
#define _IORW		0000200	/* Open for read/write	*/

/*
 * Bits in fd->_flag (all in high byte of that word)
 * These are needed for Dec-style i/o.
 */

#define	IO_BZY		0000400	/* Buffer busy (RT11)	*/
#define	IO_APN		0001000	/* Append mode open	*/
#define	IO_NOS		0002000	/* No newlines needed	*/
#define IO_NEWL		0004000 /* RSX TTY newline hack	*/
#define	IO_FIL		0010000	/* Disk file		*/
#define	IO_TTY		0020000	/* Console terminal	*/
#define	IO_REC		0040000	/* Record device	*/
#define	IO_OPN		0100000	/* Open file		*/

/*
 * The following bits are set in fd->io_wflag for wild-card
 * processing.  Note: IO_WLD must be in the low byte.
 */

#define IO_WLD	0000001		/* fwild: wildcard file	*/
#define IO_VM1	0000002		/* fwild: version ;-1	*/
#define IO_VER	0000004		/* fwild: ;0 or ;-1	*/
#define IO_WF1	0000010		/* fwild first flag	*/
#define	IO_NLH	0000020		/* fopen 'n' hack bit	*/

/*
 * Bits in fd->io_rsflag (RSTS native)
 */

#define	IO_ODT2	0100000		/* ODT mode (RSTS only)	*/

/*
 * Common definitions
 */

#define EOF	(-1)		/* End of file by getc	*/
#define NULL	(0)		/* Impossible pointer	*/
/*
 * Warning -- the following definitions are not transportable
 */
#define TRUE	1		/* if (TRUE)		*/
#define FALSE	0		/* if (!TRUE)		*/
#define EOS	0		/* End of string	*/
#ifdef	rsx
#define	IO_SUCCESS	1	/* Normal exit		*/
#define	IO_WARNING	0	/* Warning error	*/
#define	IO_ERROR	2	/* Error		*/
#define	IO_FATAL	4	/* Severe error		*/
#endif
#ifdef	rt11
#define	IO_SUCCESS	1	/* Normal exit		*/
#define	IO_WARNING	2	/* Warning error	*/
#define	IO_ERROR	4	/* Error		*/
#define	IO_FATAL	8	/* Severe error		*/
#endif
 
extern	FILE	*stdin;		/* Standard input file	*/
extern	FILE	*stdout;	/* Standard output file	*/
extern 	FILE	*stderr;	/* Standard error file	*/
extern	char	*fgets();	/* Defined by unix	*/
extern	int	$$ferr;		/* Error codes set here	*/
extern	int	$$exst;		/* Exit status set here	*/
#endif

#define	VOID	int		/* VOID definition */
#define	void	int		/* VOID definition */
                                                                                                                                                                                                                             