
C  include constant definition if not defined
C###############################################################################
C	The following routines implement the basic instruction set of the
C'SYSTEM 19 UNIVERSAL PROGRAMMER'. These routines are described in detail in the
CAPPENDIX on pages 3-4 to page 3-8 of this manual.
C
C	In a few of the subroutines that transfer or compare data between
Ca data vector stored in the host and the data stored in the prom
Cprogrammer RAM, the block limit COUNT is altered. Note this will have an affect
Con future calls to other subroutines that are affected by this value.
C
C	Whenever an ascii hex number is required as a parameter, the ascii
Cstring MUST be terminated by a null byte the ASCII hex string is shorter than
Cthe number of ASCII hex bytes expected by the subroutine, (for details plese
Csee the instruction manual). Most subroutines expect 4 bytes, and for these
Cfunctions, if the ASCII hex argument is less than 4 ascii characters then the
Cstring must be terminated by a null byte, and the subroutines will right fill
Cthe string with the correct number of preceding '0's.
C
C	These routines return status codes. For the corresponding numeric
Cvalues of these codes, see the file PRMDEF.RAT. The description below defines
Cthe meanings of the different codes that are returned from the functions
Cdescribed below in the integer variable ISTS:
C
C	SUCCES : The specified function was successful and the PP echoed
C		 the READY ('>') code on completion of the function.
C	FAIL :	 The specified funtion was executed by the PP, however the
C		 function failed and the PP returned FAILURE ('F'). NOTE:
C		 this return does not necessarily indicate a serious error
C		 in either the PP or the host computer, e.g., the subroutine
C		 BLANK will return FAIL if the PROM being tested contained
C		 programmed bits. Also, if the sum of the block size and the
C		 beginning of PP RAM address is larger than the PP RAM address
C		 space, hen many of the PP functions will return false. Under
C		 many circumstances, most of subroutines will not return a FAIL
C		 status, however those that do (most commonly, but not
C		 exclusively!!) are indicated in the subroutine description.
C	PPERR :  This error should not occur under normal operation, and
C		 may indicate a serious error. This value will be returned
C		 if the PP returned a value of '?' in response to a command.
C		 This may indicate that the PP received a command that it
C		 could not understand. After a PPERR occurs, the user
C		 should call the subroutine ERRSTS to both reset the
C		 error condition and to determine what error occured.
C	RCVERR : This error indicates the host detected a data receive
C		 error. This can occur if there was a UART buffer
C		 overflow, a UART framing error, or a receiver buffer
C		 input overflow in the host driver software. This error
C		 should never occur under normal conditions
C	HEXERR : Hex to binary conversion error caused by an illegal HEX
C	         value.
C###############################################################################
C
      SUBROUTINE BEGRAM ( BEGIN, ISTS )
C
C###############################################################################
C	Set beginning of RAM to the address BEGIN. BEGIN is an ASCII hex value
Cthat is a maximum of four bytes long. BEGIN also determines the source address
Cin a RAM to RAM block data transfer.
C###############################################################################
      BYTE BEGIN ( 4 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( '<', BEGIN, 4, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE BLKSIZ ( COUNT, ISTS )
C
C###############################################################################
C	Set block size of RAM to COUNT. COUNT is an ASCII hex value that is a
Cmaximum of four bytes long. COUNT also specifies the number of bytes to be
Ctransferred in a RAM to RAM block data move.
C###############################################################################
      BYTE COUNT ( 4 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( ';', COUNT, 4, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE BEGDEV ( BEGIN, ISTS )
C
C###############################################################################
C	Set beginning of device to the address BEGIN. BEGIN is an ASCII hex
Cvalue that is a maximum of four bytes long. This value is also used as the
Cdestination address in a RAM to RAM block data move.
C###############################################################################
      BYTE BEGIN ( 4 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( ':', BEGIN, 4, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE CHKSUM ( SUMCHK, ISTS )
C
C###############################################################################
C	This command instructs the PP to compute the checksum of the data
Cstored in the PROGRAMMER RAM (not the PROM). The value is returned
Cas an 4 byte ascii hex string in the variable SUMCHK. This function
Ccan return a value of ists=FAIL.
C
C			********************
C			*       NOTE       *
C			********************
C
C	Contrary to the PP instruction manual, the calculated checksum  will be
Caffected by the set begin ram (BEGRAM) and the set block size (BLKSIZ)
Csubroutines. Only COUNT number of bytes of memory starting at address
CBEGRAM will be included in the checksum returned by the PP.
C	Also, the number of points that can be included in the checksum
C(i.e. determined by the most recent call to BLKSIZ) cannot exceed the
Cmaximum size limit corresponding to the PROM programming adapter socket
Cthat is installed in the PP. That is, if a 2K prom adapter socket is
Cinstalled (e.g. for a 2716), then the block size cannot be set to a value
Clarger than 2048. (7ff in hex). If this restriction is not adhered to, the
Cchecksum subroutine will return ists=FAIL.
C###############################################################################
      BYTE SUMCHK ( 4 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( 'S',, 0, LINBUF, ISTS )
       I = 1
20000 IF (.NOT.( I .LE. 4)) GOTO 20002
      SUMCHK ( I ) = LINBUF ( I )
20001 I = I + 1 
      GOTO 20000
20002 CONTINUE
      RETURN
      END

C
      SUBROUTINE EXTFUN ( FUNXN, ISTS )
C
C###############################################################################
C	This command allows entry of select codes as 2 byte ascii hex code
Cnumber FUNXN. This allows execution of functions carried in extended software
Con some (but not all!) programming modules. See the operation instructions
Cfor the programming module.
C###############################################################################
      BYTE FUNXN ( 2 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( ']', FUNXN, 2, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE ERRSTS ( STATUS, ISTS )
C
C###############################################################################
C	The computer writes the 32 bit error status code to the host. The error
Cstatus code is returned in the 8 byte string STATUS. Note that STATUS is
Cencoded in ASCII hex format, (see APPENDIX page 3-5 for a description of the
Cstatus word, and pages 3-8 and 3-9 for a description of the error codes).
C###############################################################################
      BYTE STATUS ( 8 ), PREADY
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPX ( 27, 1 )
      IF (.NOT.( .NOT. PREADY ( ) )) GOTO 20003
      ISTS = - 2
      RETURN
20003 CONTINUE
      CALL PPXR ( 'F',, 0, LINBUF, ISTS )
       I = 1
20005 IF (.NOT.( I .LE. 8)) GOTO 20007
      STATUS ( I ) = LINBUF ( I )
20006 I = I + 1 
      GOTO 20005
20007 CONTINUE
      RETURN
      END

C
      SUBROUTINE BADBIT ( ISTS )
C
C###############################################################################
C	Instructs the PP to search for a programmed bit in the PROM
Cthat does not exist in PP RAM (that's what it says, not really very meaningful
Cis it?). If the test indicates an illegally programmed bit then ists=FAIL
Cand ists=SUCCES indicates the test was successful.
C###############################################################################
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( 'T',, 0, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE BLANK ( ISTS )
C
C###############################################################################
C	Instructs the PP to search the PROM for programmed bits. If any
Cprogrammed bits are found then ists=FAIL, and if the PROM is blank then
Cists=SUCCES.
C###############################################################################
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( 'B',, 0, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE IFAMLY ( FAMPIN, ISTS )
C
C###############################################################################
C	Instructs the programmer to send to the computer a 4 digit hex number
Cconsisting of a 2 digit family code and a 2 digit pinout code, and in that
Corder. These codes identify the PROM which the UNIPAK is configured to program.
CThis command is valid only with the UNIPAK installed in the programmer.
C###############################################################################
      BYTE FAMPIN ( 4 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( '[',, 0, LINBUF, ISTS )
       I = 1
20008 IF (.NOT.( I .LE. 4)) GOTO 20010
      FAMPIN ( I ) = LINBUF ( I )
20009 I = I + 1 
      GOTO 20008
20010 CONTINUE
      RETURN
      END

C
      SUBROUTINE SFAMLY ( FAMPIN, ISTS )
C
C###############################################################################
C	Sends the programmer a 4 digit hex number consisting of a 2 digit family
Ccode and a 2 digit pinout code, and in that order. These codes specify the PROM
Cconfiguration of the UNIPAK. This command is valid only with the UNIPAK
Cinstalled in the programmer.
C###############################################################################
      BYTE FAMPIN ( 4 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( '@', FAMPIN, 4, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE RESPND ( RESP, ISTS )
C
C###############################################################################
C	Returns an arbitrary length string of ASCII hex characters in the
Cbyte string RESP. The value returned can be used to determine the installed
Cprogramming electronics and the socket adapter. RESP should be dimensioned
Cas at least 10 bytes in length. The byte string RESP will be terminated
Cby a null byte.
C###############################################################################
      BYTE RESP ( 10 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( 'R',, 0, LINBUF, ISTS )
      CALL COPY ( LINBUF, RESP, 10 )
      RETURN
      END

C
      SUBROUTINE LOAD ( ISTS )
C
C###############################################################################
C	Instructs the PP to load data into its internal RAM from the
CPROM in the socket adapter within the parameters defined by the block
Climits L1, L2 and L3. If the device data did not load correctly, the function
Cwill return ists=FAIL.
C###############################################################################
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( 'L',, 0, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE PRGRM ( ISTS )
C
C###############################################################################
C	Instructs the PP to program the PROM in the socket adapter from the
Ccontents of the PP internal RAM, within the block limits L1, L2 and L3. If the
Cprogramming operation fails, ists=FAIL.
C###############################################################################
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( 'P',, 0, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE VERIFY ( ISTS )
C
C###############################################################################
C	Instructs the PP to compare RAM data with the data of the PROM device
Cin the socket adapter, within the parameters defined by the block limits
CL1, L2 and L3. If the verify operation fails, ists=FAIL.
C###############################################################################
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( 'V',, 0, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE OFFSET ( OFST, ISTS )
C
C###############################################################################
C	This is used to specify an address offset OFST. OFST is an ASCII hex
Cvalue that is at most four bytes long. This offset will be subtracted from all
Caddresses input to the programmer, and added to all addresses output from the
Cprogrammer. The address offset adjusts RAM addresses to address the range of
Clarger memories.
C###############################################################################
      BYTE OFST ( 4 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( 'W', OFST, 4, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE INDATA ( COUNT, DATA, ISTS )
C
C###############################################################################
C	Instructs the programmer to accept formatted data from the computer.
CThe input byte string DATA must contain the ASCII hex data to be stored in the
CPP's internal RAM. COUNT number of memory bytes of data will be written,
C(or 2*COUNT number of ASCII characters are in DATA). Failure of the operation
Creturns ists=FAIL. Also the routine will return HEXERR if COUNT is an illegal
Chex value. This function sets the COUNT block limit.
C
C	The DATA vector is assumed to store the equivalent of COUNT bytes of
CASCII hex data. Since in ASCII code, each binary byte is stored as two ASCII
Cbytes, COUNT*2=length(DATA). Also:
C
C	data(I)   --  ASCII hex of hi nibble  |  I={1,3,5,7,...}
C	data(I+1) --  ASCII hex of lo nibble  |
C###############################################################################
      BYTE DATA ( 1 ), COUNT ( 4 )
      CALL SENDPP ( COUNT, 'I', DATA, ISTS )
      RETURN
      END

C
      SUBROUTINE ODATA ( COUNT, DATA, ISTS )
C
C###############################################################################
C	Instructs the programmer to send the data stored in the PROGRAMMER RAM
Cto the host computer. The byte vector DATA is used to store the ASCII hex
Cbytes that are sent by the PP. COUNT specifyies the number of bytes of memory
Cto be output, and the first address to read from. Failure on data output
Creturns ists=FAIL. This function alters the COUNT block limit in the PROM
Cprogrammer.
C	The DATA vector will return the equivalent of COUNT number of bytes of
CASCII hex data. Since in ASCII code, each binary byte is stored as two ASCII
Cbytes, COUNT*2=length(DATA). Also:
C
C	data(I)   --  ASCII hex of hi nibble  |  I={1,3,5,7,...}
C	data(I+1) --  ASCII hex of lo nibble  |
C
C	The function returns status in the integer status parameter ISTS.
CISTS can return SUCCES, FAIL, HEXERR, PPERR or RCVERR.
C
C	Programming note: It is possible to call this routine several times
Cin order to allow functions to be performed with very large memories, as
Ca program may otherwise be limited by the amount of available buffer space.
CThe calling routine MUST adjust the BLOCK LIMITS in order to accomplish this.
C###############################################################################
      BYTE DATA ( 1 ), COUNT ( 4 )
      BYTE HEXBIN, ADRS ( 4 ), COMPAR, TOKEN ( 10 )
      INTEGER IPPTOK
      IF (.NOT.( .NOT. HEXBIN ( COUNT, ICNT ) )) GOTO 20011
      ISTS = - 3
      RETURN
20011 CONTINUE
      CALL BLKSIZ ( COUNT, ISTS )
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20013
      RETURN
20013 CONTINUE
      CALL LOAD ( ISTS )
      IF (.NOT.( ISTS .NE. 1 )) GOTO 20015
      RETURN
20015 CONTINUE
      CALL PPXLIN ( 'O', 1 )
      ITIPE = IPPTOK ( . TRUE ., TOKEN )
      IF (.NOT.( ITIPE .LE. 0 )) GOTO 20017
      ISTS = ITIPE
      RETURN
20017 CONTINUE
      IF (.NOT.( ITIPE .NE. 10 )) GOTO 20019
      ISTS = - 2
      RETURN
20019 CONTINUE
20018 CONTINUE
      IUP = ICNT * 2
       I = 1
20021 IF (.NOT.( I .LE. IUP)) GOTO 20023
      CONTINUE
20024 CONTINUE
      ITIPE = IPPTOK ( . FALSE ., TOKEN )
      IF (.NOT.( ITIPE .LE. 0 )) GOTO 20027
      ISTS = ITIPE
      RETURN
20027 CONTINUE
      IF (.NOT.( ITIPE .EQ. 11 )) GOTO 20029
      ISTS = - 1
      RETURN
20029 CONTINUE
20025 IF (.NOT.( ITIPE .EQ. 12 )) GOTO 20024
20026 CONTINUE
      DATA ( I ) = TOKEN ( 1 )
      DATA ( I + 1 ) = TOKEN ( 2 )
20022 I = I + 2 
      GOTO 20021
20023 CONTINUE
      ITIPE = IPPTOK ( . FALSE ., TOKEN )
      LEN = LENGTH ( TOKEN )
      IF (.NOT.( ITIPE .LE. 0 )) GOTO 20031
      ISTS = ITIPE
      GOTO 20032
20031 CONTINUE
      IF (.NOT.( ITIPE .NE. 11 )) GOTO 20033
      ISTS = - 2
      GOTO 20034
20033 CONTINUE
      ISTS = 1
20034 CONTINUE
20032 CONTINUE
      RETURN
      END

C
      SUBROUTINE CMPM2R ( COUNT, DATA, ISTS )
C
C###############################################################################
C	Instructs the programmer to compare data in RAM with the data in
CDATA. The byte vector DATA is used to store the ASCII hex bytes
Cthat are compared with the data in PP RAM. COUNT is the number of bytes of
Cmemory to be compared, (i.e. 2*COUNT number of ASCII characters are in DATA).
CFailure of the operation returns ists=FAIL. The routine will return HEXERR
Cif COUNT is an illegal hex value. This function sets the COUNT block limit.
C
C	The DATA vector is assumed to store the equivalent of COUNT number of
Cbytes of ASCII hex data. Since in ASCII code, each binary byte is stored as
Ctwo ASCII bytes, COUNT*2=length(DATA). Also:
C
C	data(I)   --  ASCII hex of hi nibble  |  I={1,3,5,7,...}
C	data(I+1) --  ASCII hex of lo nibble  |
C
C		**********************
C		*       NOTE!!       *
C		**********************
C
C	The function CMPRAM is probably better to use for comparing RAM to an
Carray because CMPRAM routine logs each discrepancy as it occurs, so it is
Cpossible to determine what bytes are wrong.
C
C###############################################################################
      BYTE DATA ( 1 ), COUNT ( 4 )
      CALL SENDPP ( COUNT, 'C', DATA, ISTS )
      RETURN
      END

C
      SUBROUTINE PARITY ( PTY, ISTS )
C
C###############################################################################
C	Instructs the programmer to output the hex number of parity errors.
CThis number is returned as a random length string terminated by a null byte,
Cin the byte vector PTY. PTY must be dimensioned at least 4 bytes long.
C###############################################################################
      BYTE PTY ( 4 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( 'Y',, 0, LINBUF, ISTS )
      CALL COPY ( LINBUF, PTY, 4 )
      RETURN
      END

C
      SUBROUTINE SWPNIB ( ISTS )
C
C###############################################################################
C	Instructs the programmer to exchange high and low order halves of every
Cbyte in RAM. This is useful for programming 4-bit devices with only one-half
Cof RAM at a time.
C###############################################################################
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( 'Q',, 0, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE R2RMOV ( ISTS )
C
C###############################################################################
C	RAM to RAM block move. Moves COUNT number of bytes from RAM location FROM
Cto RAM location TO, where:
C
C		parameter   |   set by subroutine
C		------------|-------------------
C		  COUNT     |      BLKSIZ
C		  FROM      |      BEGRAM
C		  TO        |      BEGDEV
C###############################################################################
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( '\',, 0, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE SPLIT ( CTRPNT, ISTS )
C
C###############################################################################
C	Instructs the PP to split RAM data, where CTRPNT is the ASCII hex
Cvalue indicating the center point. CTRPNT is a maximum of 4 bytes long.
C###############################################################################
      BYTE CTRPNT ( 4 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( '?', CTRPNT, 4, LINBUF, ISTS )
      RETURN
      END

C
      SUBROUTINE SHUFFLE ( CTRPNT, ISTS )
C
C###############################################################################
C	Instructs the PP to shuffle RAM data, and CTRPNT is the ASCII hex
Cvalue indicating the center point. CTRPNT is a maximum of 4 bytes long.
C###############################################################################
      BYTE CTRPNT ( 4 )
C###############################################################################
C		Prom programmer common data
C###############################################################################
      BYTE LINBUF ( 132 )
      BYTE RAMBUF ( 100 )
      COMMON / PPDATA / LINBUF, RAMBUF
C###############################################################################
      CALL PPXR ( '>', CTRPNT, 4, LINBUF, ISTS )
      RETURN
      END

                                                                                                                                               