	PROGRAM DEMONSTRATION
C
C	This program demonstrates most of the features of PLOT.
C	It should be run in conjunction with the source listing.
C	Note that the routines at speed 0 (see manual)
C	and ate therefore designed for use with a storage monitor.
C	Use with an XY recorder requires that all calls to PLOT(9,0,15)
C	be altered to, say, PLOT(9,500,15)
C	Dr. R. N. Caffin (DF 13232)
C
	TYPE 10
10	FORMAT(1H ,//' DEMONSTRATION OF PLOTXY'//)
C
C	SCALE XY RECORDER
C
	PAUSE  'SCALE,HOME: <CR>'
	CALL PLOT(0)
	CALL PLOT(1)
C
C	JUMP
C
	PAUSE  'JUMP: <CR>'
	CALL PLOT(3,-400,50)
	CALL PLOT(3,1000,1000)
	CALL PLOT(3,2000,2000)
	CALL PLOT(3,-2000,2000)
	CALL PLOT(3,0,0)
	CALL PLOT(1)
C
	PAUSE  'VECTOR & CIRCLE: <CR>'
	CALL ORIGIN
C
	PAUSE  'POINT: <CR>'
	CALL PLOT(11)
	CALL POINT
C
	PAUSE  'VECTOR: <CR>'
	CALL PLOT(11)
	CALL VEC
C
	PAUSE  'CHARACTER: <CR>'
	CALL PLOT(11)
	CALL CHAR
C
	PAUSE  'SPEED: <CR>'
	CALL PLOT(11)
	CALL SPEED
C
	PAUSE  'BOUNDS: <CR>'
	CALL PLOT(11)
	CALL LIMIT
	STOP
	END
C
	SUBROUTINE VEC
	CALL PLOT(9,0,15)
	CALL PLOT(2,-1500,-1500)
	CALL PLOT(3,0,0)
	CALL PLOT(5,3000,3000)
	CALL PLOT(1)
C
	PAUSE  '<CR>'
	CALL PLOT(3,3000,3000)
	CALL PLOT(5,3000,0)
	CALL PLOT(5,0,0)
C
	CALL PLOT(7,1500,-180,260,1,"5)
	CALL PLOT(7,1600,-240,78,1,'X')
	CALL PLOT(7,3115,1500,260,1,"5)
	CALL PLOT(7,3172,1444,78,1,'Y')
	CALL PLOT(1)
C
	PAUSE '<CR>'
	CALL PLOT(3,0,0)
	IX=0
	IY=200
	INC=200
	CALL PLOT(5,IX,IY)
	DO 200 I=100,1400,100
	IX=IX+INC
	CALL PLOT(5,IX,IY)
	IY=IY+INC
	CALL PLOT(5,IX,IY)
200	CONTINUE
	IX=IX+INC
	CALL PLOT(5,IX,IY)
	CALL PLOT(1)
	RETURN
	END
C
	SUBROUTINE ORIGIN
	CALL PLOT(9,0,15)
	CALL PLOT(0)
	PI=3.14159/30.
	TH=PI
	CALL PLOT(6,0,0)
	CALL PLOT(3,1500,0)
	DO 204 I=1,60
	IY=SIN(TH)*1500
	IX=COS(TH)*1500
	TH=TH+PI
204	CALL PLOT(5,IX,IY)
	CALL PLOT(1)
C
	PAUSE  'SINE WAVE: <CR>'
	CALL PLOT(11)
	PI=3.14159
	D5=PI/36.
	CALL PLOT(2,-2000,0)
	CALL PLOT(6,0,0)
	CALL PLOT(3,0,0)
	X=0
	IX=0
	DO 10 I=1,360
	X=X+D5
	IX=IX+10
	IY=3*SIN(X)*300.
10	CALL PLOT(5,IX,IY)
	CALL PLOT(1)
C
	PAUSE  'BINOMIAL DIST.: <CR>'
	CALL PLOT(11)
	CALL PLOT(8,-2000,2000,-2000,2000)
	DIMENSION PNT(26),NH(26)
	DATA PNT/4.,7.4,10.,12.,13.,13.4,13.2,12.2,10.6,
	1	8.6,6.6,5.2,4.2,3.2,2.4,2.,1.4,1.2,.8,.6,
	2	.4,.2,.2,.2,.1,0./
	NP=26
	INC=150
	CALL PLOT(2,-2000,-2000)
	CALL PLOT(6,0,0)
	CALL PLOT(3,0,0)
	IX=INC
	DO 105 I=1,NP
	NH(I)=PNT(I)*INC
	CALL PLOT(5,IX,NH(I))
105	IX=IX+INC
	CALL PLOT(1)
	RETURN
	END
C
	SUBROUTINE POINT
	DIMENSION PNT(20),NH(20)
	DATA PNT/4.,7.4,10.,12.,13.,13.4,13.2,12.2,10.6,
	1	8.6,6.6,5.2,4.2,3.2,2.4,2.,1.4,1.2,.8,.6/
	NP=20
	INC=200
	CALL PLOT(2,-2000,-2000)
	CALL PLOT(6,0,0)
	CALL PLOT(9,0,15)
	IX=INC
	DO 100 I=1,NP
	NH(I)=PNT(I)*INC
	CALL PLOT(4,IX,NH(I))
	CALL PLOT(4,IX+2,NH(I))
100	IX=IX+INC
	CALL PLOT(1)
	RETURN
	END
C
	SUBROUTINE CHAR
	CALL PLOT(9,0,15)
	CALL PLOT(8,-2000,2000,-2000,2000)
	CALL PLOT(2,0,0)
	IS=100
	IX=-2000
	INCX=160
	IY=1700
	INCY=-400
	K=1
	DO 100 L=1,6
	J=IX
	DO 20 I=K,K+23
	IF(I.GT.127)GO TO 200
	CALL PLOT(7,J,IY,IS,1,I)
20	J=J+INCX
	K=K+24
100	IY=IY+INCY
200	IX=-2000
	IY=-2000
	IS=512
	DO 300 I=1,5
	CALL PLOT(7,IX,IY,IS,1,65)
	IX=IX+IS*2
300	IS=IS*3/4
C
	IY=-1800
	IX=2000
	IS=-400
	DO 400 I=1,3
	CALL PLOT(7,IX,IY,IS,1,65)
	IY=IY-IS*2
400	IS=IS/2
	CALL PLOT(1)
	RETURN
	END
C
C
C
C
	SUBROUTINE SPEED
	CALL PLOT(9,0,15)
	CALL STAR
	PAUSE 'SLOW:<CR>'
	CALL PLOT(11)
	CALL PLOT(9,150,15)
	CALL STAR
	RETURN
	END
C
	SUBROUTINE STAR
	CALL PLOT(3,0,-1500)
	CALL PLOT(5,500,-800)
	CALL PLOT(5,1500,-800)
	CALL PLOT(5,900,30)
	CALL PLOT(5,1500,800)
	CALL PLOT(5,500,800)
	CALL PLOT(5,0,1500)
	CALL PLOT(5,-500,800)
	CALL PLOT(5,-1500,800)
	CALL PLOT(5,-900,30)
	CALL PLOT(5,-1500,-800)
	CALL PLOT(5,-500,-800)
	CALL PLOT(5,0,-1500)
	CALL PLOT(1)
	RETURN
	END
C
	SUBROUTINE LIMIT
	LOGICAL*1 BOUNDS
	COMMON BOUNDS
	CALL PLOT(9,0,15)
1000	BOUNDS=.FALSE.
	CALL GRAPH
	PAUSE
	CALL PLOT(11)
	BOUNDS=.TRUE.
	CALL GRAPH
	PAUSE
	CALL PLOT(8,-2000,2000,-2000,2000)
	RETURN
	END
C
	SUBROUTINE GRAPH
	LOGICAL*1 BOUNDS
	COMMON BOUNDS
	CALL A
	CALL B
	CALL C
	CALL D
	RETURN
	END
C
	SUBROUTINE A
	LOGICAL*1 BOUNDS
	COMMON BOUNDS
	IF(BOUNDS)CALL PLOT(8,-2000,-100,0,2000)
	CALL PLOT(2,-2000,0)
	INC=110
	CALL AB(INC)
	RETURN
	END
C
	SUBROUTINE AB(INC)
	DIMENSION PNT(20),NH(20)
	DATA PNT/4.,7.4,10.,12.,13.,13.4,13.2,12.2,10.6,
	1	8.6,6.6,5.2,4.2,3.2,2.4,2.,1.4,1.2,.8,.6/
	NP=20
	CALL PLOT(6,0,0)
	CALL PLOT(3,0,0)
	IX=INC
	DO 9 I=1,NP
	NH(I)=PNT(I)*INC
	CALL PLOT(5,IX,NH(I))
9	IX=IX+INC
	CALL PLOT(1)
	RETURN
	END
C
	SUBROUTINE B
	DIMENSION PNT(20),NH(20)
	DATA PNT/4.,7.4,10.,12.,13.,13.4,13.2,12.2,10.6,
	1	8.6,6.6,5.2,4.2,3.2,2.4,2.,1.4,1.2,.8,.6/
	LOGICAL*1 BOUNDS
	COMMON BOUNDS
	IF(BOUNDS)CALL PLOT(8,-2000,-100,-2000,-100)
	INCX=120
	INCY=200
	CALL PLOT(2,-2000,-2000)
	CALL PLOT(6,0,0)
	CALL PLOT(3,0,0)
	DO 100 I=0,19
	CALL PLOT(5,I*INCX,IFIX(PNT(I+1)*INCY))
	CALL PLOT(5,(I+1)*INCX,IFIX(PNT(I+1)*INCY))
	CALL PLOT(5,(I+1)*INCX,0)
100	CONTINUE
	RETURN
	END
C
	SUBROUTINE C
	LOGICAL*1 BOUNDS
	COMMON BOUNDS
	IF(BOUNDS)CALL PLOT(8,0,2000,0,2000)
	CALL PLOT(2,0,1200)
	PI=3.14159
	D5=PI/36.
	CALL PLOT(6,0,0)
	CALL PLOT(3,0,0)
	X=0
	IX=0
	DO 10 I=1,180
	X=X+D5
	IX=IX+10
	IY=3*SIN(X)*300.
10	CALL PLOT(5,IX,IY)
	CALL PLOT(1)
	RETURN
	END
C
	SUBROUTINE D
	LOGICAL*1 BOUNDS
	COMMON BOUNDS
	CALL PLOT(2,1000,-1000)
	IF(BOUNDS)CALL PLOT(8,0,2000,-2000,-100)
	CALL PLOT(6,0,0)
	D=3.14159/90.
	TH=D
	CALL PLOT(3,500,0)
	DO 148 I=1,180
	IXP=COS(TH)*500
	IYP=SIN(TH)*500
	CALL PLOT(5,IXP,IYP)
148	TH=TH+D
	CALL PLOT(1)
	RETURN
	END
                                                                                                                                                                                                                                                                                                                           