
	SUBROUTINE HIDE (X,Y,XG,G,XH,H,NG,MAXDIM,N1,NFNS,TITLE,
	1                 XLNTH,YLNTH,XMIN,DELTAX,YMIN,DELTAY)
C
C	HIDE.FOR
C
C	PURPOSE.
C	THIS SUBROUTINE PRODUCES A 2-DIMENSIONAL REPRESENTATION OF
C	A 3-DIMENSIONTAL FIGURE OR SURFACE.
C
C	UTILIZATION.
C	THE FIRST CALL TO HIDE IS FOR INITIALIZATION AN PLOTTING
C	THE CURVE FARTHEST IN THE FOREGROUND. ON EACH SUBSEQUENT
C	CALL, A CURVE FARTHER IN THE BACKROUND IS PLOTTED.
C
C	ARGUMENTS.
C
C	X IS THE ABCISSA ARRAY FOR THE CURVE TO BE PLOTTED BY
C	  HIDE ON THIS CALL. THE X VALUES MUST BE INCREASING.
C	  IF X(I) GE X(I+1) FOR SOME I, MAXDIM WILL BE SET TO ZERO
C	  AND A RETURN WILL BE EXECUTED.
C
C	Y IS THE ORDINATE ARRAY.
C
C	G VS XG IS THE CURRENT VISUAL MAXIMUM FUNCTION ON EACH
C	  RETURN FROM HIDE
C
C	XH AND H ARE WORKING ARRAYS.
C
C	ON EACH RETURN FROM HIDE, NG IS THE NUMBER OF POINTS IN
C	   THE CURRENT MAXIMUM FUNCTION.
C	ON THE FIRST CALL, NG IS A NONPOSITIVE INTEGER WHICH
C	   SPECIFIES CERTAIN OPTIONS.
C	     -1 DO NOT DRAW THE 8 1/2 BY 11 INCH BORDER.
C	     -2 PLOT UNHIDDEN MINIMUM RATHER THAN MAXIMUM. IN THIS
C	        CASE, G VS XG WILL BE THE NEGATIVE OF THE VISUAL
C	        MINIMUM FUNCTION.
C	     -3 DO NOT PLOT BORDER, PLOT MINIMUM RATHER THAN MAXIMUM.
C	      0 PLOT BORDER, PLOT MAXIMUM.
C
C	IF THE BORDER IS DRAWN, ITS LEFT, BOTTOM CORNER WILL BE
C	  WHERE THE PLOTTING REFERENCE POINT WAS JUST BEFORE THE
C	  FIRST CALL TO HIDE, AND THE REFERENCE POINT WILL BE MOVED
C	  1 INCH RIGHT AND 2 INCHES UP. IF THE BORDER IS NOT DRAWN.
C	  THE REFERENCE POINT WILL NOT BE MOVED BY HIDE.
C
C	MAXDIM IS THE DIMENSION IN THE CALLING PROGRAM OF THE 
C	  ARRAYS XG,G,XH,AND H. IF ONE OF THESE ARRAYS WOULD
C	  HAVE BEEN OVERFLOWED, MAXDIM IS SET EQUAL TO ITS NEGATIVE,
C	  AND RETURN IS EXECUTED.
C
C	N1 IS THE NUMBER OF POINTS (X(I),Y(I)) TO BE PLOTTED IN
C	   A GIVEN CALL TO HIDE.
C	   IF N1 IS LESS THAN 0, Y VS X WILL NOT BE PLOTTED, BUT ON
C	   SUBSEQUENT CALLS, PLOTTING WILL BE DONE AS IF
C	   ((X(I),Y(I),I=1,-N1) HAD BEEN PLOTTED (WHERE UNHIDDEN)
C	   N1 WILL BE RETURNED AS ITS ABSOLUTE VALUE.
C
C	NFNS IS THE TOTAL NO. OF CURVES TO BE PLOTTED FOR THIS
C	   GRAPH IF TRANSLATING THE ARRAYS TO STIMULATE STEPPING IN
C	   THE DEPTH DIMENSION IS DESIRED. IF NO TRANSLATION IS
C	   DESIRED, NFNS SHOULD BE NEGATIVE. IF THE SAME TRANSLATION
C	   AS IN THE PREVIOUS CALL TO HIDE IS DESIRED, NFNS SHOULD BE
C	   ZERO. THE NFNS=0 OPTION MAY BE SPECIFIED FOR INDIVIDUAL
C	   CURVES AFTER THE FIRST FOR A GIVEN GRAPH. ALL TRANSLATIONS 
C	   WHICH ARE PERFORMED WILL HAVE EQUAL STEP SIZE
C	   DETERMINED BY THE VALUES IN THE INITIAL CALL FOR XLNTH.
C	   YNNLTH, AND NFNS.
C
C	TITLE IS AN 80-CHARACTER TITLE.
C	  IF TITLE(1)=6HNOTTLE, THE TITLE WILL NOT BE PLOTTED.
C	  TITLE(1) AND XH(1) OR H(1) MAY BE THE SAME LOCATION IF THE
C	  TITLE IS NOT NEEDED AFTER IT IS PLOTTED.
C
C	XLNTH IS THE LENGTH IN INCHES OF THE HORIZONTAL AXIS.
C	  IF XLNTH IS LESS THAN 0, THE X-AXIS AND THE DEPTH AXIS
C	  WILL NOT BE DRAWN. IN ANY CASE, UNLESS THIS OPTION IS
C	  SUPPRESSED THROUGH NFNS, THE I'TH CURVE WILL BE TRANSLATED
C	  (I-1)*(9.0-ABS(XNLTH))/(NFNS-1) INCHES TO THE LEFT.
C	  THIS PLUS A SIMILAR VERTICAL TRANSLATION IS DONE TO SIMULATE
C	  STEPPING IN THE DEPTH DIMENSION.
C	  XMIN-(9.0-ABS(XLNTH))*DELTAX WILL BE THE ABCISSA
C	  VALUE AT THE PLOTTING REFERENCE POINT (WHICH IS THERE THE
C	  HORIZONTAL AND VERTICAL AXES WOULD INTERSECT IS DRAWN.
C
C	YNLTH IS THE LENGTH OF THE VERTICAL AXIS IN INCHES.
C	  IF YLNTH IS LESS THAN 0, THE VERTICAL AND DEPTH AXES WILL
C	  NOT BE DRAWN. BUT IN ANY CASE, UNLESS THIS OPTION IS
C	  SUPPRESSED THROUGH NFNS, THE I'TH CURVE WILL BE TRANSLATED
C	  (I-1)*(6.0-ABS(YNLTH))/(NFNS-1) INCHES UP
C	  TO SIMULATE STEPPING IN THE DEPTH DIMENSION. YMIN-
C	  (6.0-ABS(YLNTH))*DELTAY WILL BE THE ORDINATE VALUE
C	  AT THE PLOTTING REFERENCE POINT.
C
C	IF TRANSLATIONS ARE PERFORMED, X AND Y WILL BE RESTORED TO
C	  THEIR ORIGINAL VALUES BEFORE THE RETURN TO THE CALLING
C	  PROGRAM.
C
C	NOTE THAT IF ABS(XLNTH)=9, AND ABS(YLNTH)=6, THERE WILL BE
C	  NO TRANSLATION, AND, IF BORDER AND AXES ARE NOT DRAWN, THE
C	  DIMENSION OF THE PLOT ARE UNSPECIFIED.
C	  IF THE AXES AND BORDER ARE DRAWN, THE TOP OF THE VERTICAL
C	  AXIS AND THE RIGHT END OF THE HORIZONTAL AXIS ARE FIXED
C	  RELATIVE TO THE BORDER, AND THE DEPTH AXIS JOINS THE LEFT
C	  END OF THE HORIZONTAL AXIS AND THE BOTTOM OF THE VERTICAL AXIS.
C
C	XMIN IS A LOWER BOUND FOR X.
C
C	DELTAX IS THE X DATA INCREMENT PER INCH FOR THE PLOT
C	  XMIN AND DELTAX DETERMINE THE PLOTTING SCALE FOR X.
C	  (SEE ABOVE.)
C
C	YMIN AND DELTAY,SIMILARLY, DETERMINE THE SCALE FOR Y.
C
C	IF AN ERROR RETURN IS MADE FROM HIDE, ALL FURTHER CALLS
C	  WILL RESULT ONLY IN THE EXECUTION OF A RETURN UNLESS
C	  MAXDIM IS RESET TO A POSITIVE VALUE.
C
C
C	SUBROUTINES CALLED.
C		SYSTMP
C		PLOT
C		SYMBOL
C		AXIS
C		LOOKUP
C		PDATAX
C
C
C	REFERENCES.
C	WILLIAMSON, H.,  CACM, (15) 2, FEB '72, 100-103.
C
C	WILLIAMSON, H.,  CACM, (16) 9, SEPT'73, 578-579.
C
C
C	AUTHOR.
C	ORIGINAL VERSION BY;
C	HUGH WILLIAMSON
C
C
C	CONVERTED TO RT-11 FORTRAN 4 BY,
C	M.W. VANNIER
C	WENNER GREN LAB
C	UNIVERSITY OF KENTUCKY
C	24 AUGUST 1976
C
C
C
C
	DIMENSION X(1),Y(1),XG(1),G(1),H(1),XH(1),TITLE(1)
	INTEGER TITLE
C
C	THE ONLY PURPOSE OF THE FOLLOWING EQUIVALENCE STATEMENT 
C	IS TO SAVE STORAGE
C
	EQUIVALENCE (KI,IWHICH),(K2,SLOPE),(FNSM1,Z1),
	1(IGGP1,K1),(K1,N2)
C
C	EPSI IS THE RELATIVE ABCISSA INCREMENT USED TO SIMULATE
C	DISCONTINUITIES IN THE MAXIMUM FUNCTION
C
	DATA EPSI/1.0E-6/
	DATA NOTTLE /6HNOTTLE/
C
C	THE FOLLOWING STATEMENT FUNCTION COMPUTES THE ORDINATE ON 
C	THE LINE JOINING (XI,YI) AND (XIP1,YIP1) CORRESPONDING TO
C	THE ABCISSA XX.
C
	F(XX,XI,YI,XIP1,YIP1)=YI+(XX-XI)*(YIP1-YI)/(XIP1-XI)
C
C	CALL ARGCHK  !SYSTEM SUBROUTINE CALL FOR PURDUE-CC
C
	IF(MAXDIM.LE.0)RETURN
	IFPLOT=1
	IF(N1.GT.0)GO TO 76
	N1=-N1
	IFPLOT=0
76	DO 71 I=2,N1
	IF(X(I-1).LT.X(I))GO TO 71
	MAXDIM=0
C	CALL SYSTMP(X,Y,XG,G,XH,H,500,
C	137HABCISSA ARRAY NOT IN INCREASING ORDER  )
	TYPE 776
776	FORMAT (/,' ***HIDE***  ABSCISSA ARRAY NOT IN INCREASING',
	1 ' ORDER',/)
	GO TO 75
71	CONTINUE
	IF(NG.GT.0)GO TO 5000
	IF(N1+4.0.LE.MAXDIM)GO TO 74
	MAXDIM=-MAXDIM
75	RETURN
C
C	WE WANT SIGN=1 IF WE ARE PLOTTING MAXIMUM, =-1 IF MINIMUM
C
74	SIGN=1.0
	IF(NG.LT.-1)SIGN=-1.0
C
C	THE K'TH CURVE TO BE PLOTTED WILL (OPTIONALLY) BE
C	TRANSLATED BY THE VECTOR (-DXIN,DYIN)*(K-1) TO
C	SIMULATE STEPPING IN THE DEPTH DIMENSION.
C
	FNSM1=0.0
	IF(NFNS.LE.0)GO TO 46
	FNSM1=NFNS-1
	DXIN=(9.0-ABS(XLNTH))*DELTAX/FNSM1
	DYIN=(6.0-ABS(YLNTH))*DELTAY/FNSM1
C
C	SYSTEMS ROUTINE PLOT MOVES THE PEN TO A POINT WHOSE
C	COORDINATES ARE SPECIFIED IN INCHES BY THE FIRST TWO
C	PARAMETERS. THE PEN IS PICKED UP IF THE ABSOLUTE VALUE OF
C	THE THIRD PARAMETER IS 3, IS PUT DOWN IF 2, AND IS LEFT AS
C	AFTER LAST CALL IF 1. IF THE THIRD PARAMETER IS NEGATIVE,
C	A NEW REFERENCE POINT WILL BE ESTABLISHED.
C
46	IF(NG.EQ.-1.OR.NG.EQ.-3)GO TO 41
C
C	DRAW 8 1/2 BY 11 INCHES BORDER
C
	CALL PLOT (0.0,0.0,3)
	CALL PLOT (11.0,0.0,2)
	CALL PLOT (11.0,8.5,1)
	CALL PLOT (00.0,8.5,1)
	CALL PLOT (00.0,0.0,1)
	CALL PLOT (01.0,2.0,-3)
C
C	CALL SYSTEMS ROUTINE TO PLOT THE 80-CHARACTER TITLE.
C	THE FIRST TWO ARGUMENTS ARE THE COORDINATES IN INCHES
C	RELATIVE TO THE REFERENCE POINT OF THE LOWER LEFT-HAND
C	CORNER OF THE FIRST CHARACTER. THE THIRD ARGUMENT
C	DETERMINES THE HEIGHT IN INCHES OF THE CHARACTERS. THE
C	FIFTH ARGUMENT GIVES THE ANGLE RELATIVE TO HORIZONTAL OF
C	THE PLOTTED CHARACTERS.
C
41	IF(TITLE(1).NE.NOTTLE)CALL SYMBOL(0.28,1.0,0.14,
	1TITLE,0.0,80)
	IF(XLNTH.LT.0.0)GO TO 42
C
C	CALL SYSTEMS ROUTINE TO DRAW THE HORIZONTAL AXIS. THE
C	LEFT END IS SPECIFIED IN INCHES RELATIVE TO THE REFERENCE
C	POINT BY THE FIRST TWO ARGUMENTS
C
	CALL AXIS(9.0-XLNTH,0.,1H ,-1,XLNTH,0.,XMIN,DELTAX)
	IF(YLNTH.LT.0.0)GO TO 43
C
C	DRAW THE DEPTH AXIS.
C
	CALL PLOT(9.0-XLNTH,0.0,3)
	CALL PLOT(0.0,6.0-YLNTH,2)
42	IF(YLNTH.LT.0.0)GO TO 43
C
C	DRAW THE VERTICAL AXIS. THE BOTTOM POINT IS SPECIFIED IN
C	INCHES RELATIVE TO THE REFERENCE POINT BY THE FIRST TWO
C	ARGUMENTS.
C
	CALL AXIS(0.0,6.0-YLNTH,1H ,1,YLNTH,90.0,YMIN,DELTAY)
C
C	CURVES SUCCESSIVELY FARTHER IN THE BACKGROUND WILL BE
C	PLOTTED WHERE THEY ARE NOT HIDDEN BY G VS. XG
C	WILL BE UPDATED EACH TIME A NEW CURVE  IS DRAWN AND WILL BE
C	THE VISUAL MAXIMUM (OR MINIMUM) FUNCTION OF THE CURVES
C	ALREADY PLOTTED.
C
43	INDEXT=3
	DO 3 J=1,N1
	XG(INDEXT)=X(J)
	G(INDEXT)=SIGN*Y(J)
3	INDEXT=INDEXT+1
C
C	FOLLOWING PRECAUTIONARY STEP IS USED IN PLACE OF A
C	TEST IN SUBROUTINE LOOKUP TO SEE IF THE VALUE FOR WHICH WE
C	WANT AN INDEX IS OUTSIDE STHE TABLE.
C	THE LAST XG VALUE WILL BE SET EQUAL TO THE LAST ABCISSA
C	OF THE CURVE TO BE PLOTTED IN THE NEXT CALL TO HIDE.
C
	EPS=EPS1*(ABS(XMIN)+ABS(DELTAX))
	NG=N1+4
	XG(1)=-FNSM1*DXIN+XMIN-ABS(XMIN)-ABS(XG(3))-1.0
	XG(2)=XG(3)-EPS
	XG(N1+3)=XG(N1+2)+EPS
	ZZ=YMIN
	IF(SIGN.LT.0.0)ZZ=-YMIN-50.0*DELTAY
	G(1)=ZZ
	G(2)=ZZ
	G(N1+3)=ZZ
	G(NG)=ZZ
C
C	CALL SYSTEMS ROUTINE TO PRODUCE A LINE PLOT OF
C	X(I),Y(I),I=1,N1) - THIS IS THE CURVE FARTHEST IN THE
C	FOREGROUND.
C	XSTART IS THE X VALUE AT THE REFERENCE POINT.
C
	XSTART=XMIN-(9.0-ABS(XLNTH))*DELTAX
C
	IF(IFPLOT.EQ.1)CALL PDATAX(X,Y,N1,XSTART,DELTAX,YMIN,DELTAY)
	DXKK=0.0
	DYKK=0.0
	RELINC=DELTAX/DELTAY
	XG(NG)=SIGN
	RETURN
C
C	STATEMENT 5000 IS REACHED IF ANY EXCEPT THE CURVE FARTHEST
C	IN THE FOREGROUND IS TO BE PLOTTED.
C
5000	SIGN=XG(NG)
	XG(NG)=X(N1)
C
C	TRANSLATE THE ARRAYS BEFORE PLOTTING TO SIMULATE STEPPING
C	IN THE DEPTH DIMENSION.
C
	IF(NFNS)52,48,49
49	DXKK=DXKK+DXIN
	DYKK=DYKK+DYIN
48	DO 4 J=1,N1
	Y(J)=SIGN*(Y(J)+DYKK)
4	X(J)=X(J)-DXKK
52	CALL LOOKUP (X(1),XG(1),JJ)
	IF(JJ.GE.MAXDIM)GO TO 700
	DO 31 J=1,JJ
	XH(J)=XG(J)
31	H(J)=G(J)
	IG=JJ+1
	XH(IG)=X(1)
	H(IG)=F(X(1),XG(JJ),G(JJ),XG(IG),G(IG))
C
C	WE WILL BE MAKING TABLE LOOKUPS FOR AN INCREASING SEQUENCE
C	OF NUMBERS - THEREFORE, WE DO NOT HAVE TO SEARCH FROM THE
C	FIRST OF THE (XG AND X) TABLES EACH TIME. HENCE INDEXG
C	AND INDEXT.
C
	INDEXG=JJ
	INDEXT=1
	Z1=X(1)
	F1 = H(IG) - Y(1)
	IT = 2
	JJ = IG
	IF(H(IG).GE.Y(1))GO TO 32
	IF(JJ.GE.MAXDIM)GO TO 700
	JJ=IG+1
	H(JJ)=Y(1)
	XH(JJ)=Z1+EPS
32	LAST=0
	X1=Z1
C
C	FIND THE FIRST ZERO, Z2, OF THE FUNCTION G-Y TO THE RIGHT
C	OF Z1.
C
1100	IF(XG(IG).LT.X(IT))GO TO 1001
C
C	DO NOT JUMP IF WE ARE TO LOOK FOR A ZERO BETWEEN X1 AND
C	X(I).
C
	IWHICH=0
	X2=X(IT)
	F2=F(X2,XG(IG-1),G(IG-1),XG(IG),G(IG))-Y(IT)
	IT=IT+1
	GO TO 1002
C
C	COME TO 1001 IF WE ARE TO LOOK FOR A ZERO BETWEEN X1 AND
C	XG(IG).
C
1001	X2=XG(IG)
	IWHICH=1
	F2=G(IG)-F(X2,X(IT-1),Y(IT-1),X(IT),Y(IT))
	IG=IG+1
C
C	THE FUNCTION (G-Y) HAS A ZERO Z2 SUCH THAT X1 LE Z2 LE X2
C	IF AND ONLY IF (G-Y AT X1) * (G-Y AT X2) LE 0.
C	(G-Y IS ASSUMED, FOR PLOTTING PURPOSES, TO BE LINEAR ON
C	EACH INTERVAL (X1,X2).)
C
1002 	IF(F1*F2.GT.0.)GO TO 1005
	IF(F1.EQ.F2)GO TO 1005
D	TYPE 3127,F1,F2,X1,X2
D3127	FORMAT (2X,4G15.3,//)
	IF (X1.EQ.X2) X2=X1-1.E-5
	SLOPE=(F2-F1)/(X2-X1)
	IGG=IG-1-IWHICH
	ITT=IT-2+IWHICH
	IF(ABS(SLOPE*RELINC).GT.EPSI)GO TO 1007
C
C	IF G AND Y DIFFER IMPERCEPTIBLY (FOR PLOTTING PURPOSES)
C	ON THE INTERVAL (X1,X2), SET Z2=X2. THIS STEP PREVENTS
C	DIVISION BY ZERO.
C
	Z2=X2
	GO TO 1006
C
C	OTHERWISE, COMPUTE THE ZERO Z2
C
1007	Z2 = X1-F1/SLOPE
	GOTO 1006
C	
C	IF NO ZERO WAS FOUND BETWEEN X1 AND X2, CONTINUE THE
C	SEARCH FOR ZEROES.
C
1005	X1 = X2
	F1 = F2
	IF (IT.NE.N1) GOTO 1100
C
C	IF THE END OF THE X TABLE HAS BEEN REACHED, CONSIDER THE
C	INTERVAL FROM THE LAST ZERO FOUND TO THE END OF THE X
C	TABLE (PLOT, UPDATE MAXIMUM FUNCTION AS INDICATED).
C
1008	LAST=1
	Z2=X(N1)
	CALL LOOKUP(Z2,XG(INDEXG),IGG)
	IGG=INDEXG+IGG-1
	ITT=N1-1
C
C	IT IS NECESSARY TO PLOT Y VS X ON THE INTERVAL (Z1,Z2)
C	ONLY IF Y IS UNHIDDEN AT EACH ZZ SUCH THAT Z1 LT ZZ LT Z2.
C	WE CHOOSE ZZ NEAR THE LEFT END OF THE INTERVAL FOR
C	EFFICIENCY IN THE TABLE LOOKUP.
C	NOTE THAT IT IS MORE EFFICIENT TO CHOOSE THIS VALUE FOR ZZ
C	THAN, SAY, 0.99 * X(INDEXT) + 0.01* X(INDEXT+1), WHICH
C	WOULD ELIMINATE ONE OF THE TWO TABLE LOOKUPS, BUT WOULD
C	NECESSITATE A TEST TO DETERMINE IF ZZ WAS BETWEEN Z1 AND Z2.
C
1006	ZZ=0.99*Z1+0.01*Z2
	CALL LOOKUP(ZZ,X(INDEXT),K1)
	CALL LOOKUP(ZZ,XG(INDEXG),K2)
	K1=K1+INDEXT-1
	K2=K2+INDEXG-1
	IF(F(ZZ,X(K1),Y(K1),X(K1+1),Y(K1+1)).GT.
	1F(ZZ,XG(K2),G(K2),XG(K2+1),G(K2+1)))GO TO 7
C
C	IF Y IS HIDDEN BETWEEN Z1 AND Z2, UPDATE THE MAXIMUM
C	FUNCTION.
C	FOR GENERALITY, THE MAXIMUM FUNCTION SI UPDATED EVEN IF
C	THIS IS THE (NFNS)TH CURVE.
C
	IF(JJ+IGG-INDEXG.GE.MAXDIM)GOTO 700
	IF(INDEXG.EQ.IGG)GO TO 712
	J1=INDEXG+1
	DO 12 I=J1,IGG
	JJ=JJ+1
	XH(JJ)=XG(I)
12	H(JJ)=G(I)
712	JJ=JJ+1
	XH(JJ)=Z2
	H(JJ)=F(Z2,XG(IGG),G(IGG),XG(IGG+1),G(IGG+1))
	INDEXG=IGG
	INDEXT=ITT
	GO TO 60
C
C	IF Y IS NOT HIDDEN BETWEEN Z1 AND Z2, UPDATE THE MAXIMUM
C	FUNCTION AND PLOT.
C
7	NGRAPH=ITT-INDEXT+2
	IF(JJ+NGRAPH-1.GT.MAXDIM)GOTO 700
	N2=JJ
	IF(NGRAPH.EQ.2)GOTO 9
	J1=INDEXT+1
	DO 11 I=J1,ITT
	JJ=JJ+1
	XH(JJ)=X(I)
11	H(JJ)=Y(I)
9	JJ=JJ+1
	XH(JJ)=Z2
	H(JJ)=F(Z2,X(ITT),Y(ITT),X(ITT+1),Y(ITT+1))
C
C	CALL SYSTEMS ROUTINE TO PRODUCE LINE PLOT OF
C	(XH(I),H(I),I=N2,N2+NGRAPH-1).
C
	IF(IFPLOT.EQ.1)CALL PDATAX(XH(N2),H(N2),NGRAPH,XSTART,DELTAX,
	1SIGN*YMIN,SIGN*DELTAY)
C
	INDEXT=ITT
	INDEXG=IGG
60	IF(LAST.EQ.1)GOTO 61
	X1=X2
	F1=F2
	Z1=Z2
C
C	AFTER PLOTTING AND/OR UPDATING THE MAXIMUM FUNCTION ON THE
C	INTERVAL (Z1,Z2),SEARCH FOR THE NEXT ZERO IF THE END OF
C	THE ABCISSA TABLE XT HAS NOT BEEN REACHED.
C
	IF(IT.LE.N1)GOTO 1100
	GOTO 1008
C
C	AFTER Y VS X HAS BEEN PLOTTED, FINISH UPDATING AND STORE
C	THE NEW MAXIMUM FUNCTION.
C	ALLOW FOR THE POSSIBILITY THAT THE PREVIOUS MAXIMUM
C	FUNCTION EXTENDS TO THE RIGHT OF THE FUNCTION JUST
C	PLOTTED.
C
61	IF(XG(NG).LE.XG(NG-1))NG=NG-1
	IF(XG(NG).LE.X(N1))GO TO 33
	IF(JJ+3+NG-IGG.GT.MAXDIM)GO TO 700
	XH(JJ+1)=XH(JJ)+EPS
	JJ=JJ+1
	H(JJ)=F(X(N1),XG(IGG),G(IGG),XG(IGG+1),G(IGG+1))
	IGGP1=IGG+1
	DO 34 J=IGGP1,NG
	JJ=JJ+1
	XH(JJ)=XG(J)
34	H(JJ)=G(J)
33	NG=JJ+2
	IF(NG.GT.MAXDIM)GOTO 700
	DO 13 I=1,JJ
	G(I)=H(I)
13	XG(I)=XH(I)
C
C	THE FOLLOWING PRECAUTIONARY STEP IS USED IN PLACE OF A
C	TEST IN SUBROUTINE LOOKUP TO SEE IF THE VALUE FOR WHICH WE
C	WANT AN INDEX IS OUTSIDE THE TABLE.
C	THE LAST XG VALUE WILL BE SET EQUAL TO THE LAST ABCISSA
C	OF THE NEXT CURVE TO BE PLOTTED.
C
	XG(JJ+1)=XG(JJ)+EPS
	G(JJ+1)=YMIN+DYKK
	IF(SIGN.LT.0)G(JJ+1)=-YMIN-50.0*DELTAY+DYKK
	G(NG)=G(JJ+1)
C
C	RESTORE ARRAYS X AND Y BEFORE RETURNING.
C
66	IF(NFN.LT.0)GO TO 53
	DO 82 I=1,N1
	X(I)=X(I)+DXKK
82	Y(I)=SIGN*Y(I)-DYKK
53	XG(NG)=SIGN
	RETURN
C
C	IF STATEMENT 700 IS REACHED, DIMENSIONS WOULD HAVE BEEN
C	EXCEEDED. SEE COMMENTS ON CALLING SEQUENCE FOR HIDE.
C
700	MAXDIM=-MAXDIM
C	CALL SYSTMP(X,Y,XG,G,XH,H,500,
C	129HVISUAL MAXIMUM EXCEEDS MAXDIM )
	TYPE 766
766	FORMAT (/,' ***HIDE*** VISUAL MAXIMUM EXCEEDS MAXDIM',/)
	GOTO 66
	END


	SUBROUTINE LOOKUP(X,XTBL,J)
C
C	LOOKUP.FOR
C	THIS SUBROUTINE IS CALLED BY HIDE TO PERFORM A TABLE
C	LOOKUP. BECAUSE OF PRECAUTIONS TAKEN IN HIDE. A TEST TO
C	SEE IF X IS OUTSIDE THE TABLE IS UNNECESSARY.
C
C	ORIGINAL VERSION BY H. WILLIAMSON
C	CONVERTED TO RT-11 FORTRAN 4 BY;
C	M.W. VANNIER
C	WENNER GREN LAB
C	27 AUGUST 1976
C
	DIMENSION XTBL(1)
	J=2
4	IF(XTBL(J)-X)1,2,3
1	J=J+1
	GOTO 4
2	RETURN
3	J=J-1
	RETURN
	END


	SUBROUTINE PDATAX(X,Y,N,XM,DX,YM,DY)
C
C	PURDUE CALCOMP/DIPL COMPATABLE DATA PLOTING ROUTINE
C
C	ORIGINAL VERSION FROM PURDUE UNIV. COMPUTER CENTER.
C	MODIFIED FOR RT-11 FORTRAN 4 BY;
C	M.W. VANNIER
C	UNIV. OF KENTUCKY
C	WENNER GREN LAB
C	27 AUGUST 1976
C
	DIMENSION X(N),Y(N)
	DATA CX,CY/2*0.0/
	PX(I)=(X(I)-XM)/DX
	PY(I)=(Y(I)-YM)/DY
C
	I1=1
	I2=1
	IF(AMAX1(ABS(CX-PX(1)),ABS(CY-PY(1))).LT.
	1   AMAX1(ABS(CX-PX(N)),ABS(CY-PY(N))))GOTO 1
	I1=N
	I2=-I2
1	CALL PLOT(PX(I1),PY(I1),3)
	DO 2 I3=2,N
	I1=I1+I2
2	CALL PLOT(PX(I1),PY(I1),2)
	CX=PX(I1) 
	CY=PY(I1)
	RETURN
	END
	  

                                                                                                      