;
;	Re-alphabetize a dictionary in anagrammatic order.
;	Any files in the directory named ANA*.DIC will
;	be used (and destroyed) by this procedure.
;
	.ENABLE SUBSTITUTION
	.SETS S$MCR ""
	.IF <CLI> <> "MCR"	.SETS S$MCR "MCR "
	.SETT L$Q
	.TESTDEVICE TI:
	.SETS S$DEV <EXSTRI>[1:2]
	.IF S$DEV <> "VT" .ASK L$Q Do you wish to continue
	.SETS S$MYTK "ANA"+<EXSTRI>[1:1]+<EXSTRI>[3:4]
	.PARSE S$MYTK ":" S$MYTK S$JUNK
;
;---- Blowing away the old ANA%%.TMP files
	'S$MCR'PIP ANA%%.TMP;*/DE/NM
;
;---- Concatenating dictionary files.
;     Please ignore complaints from PIP during this step.
	'S$MCR'PIP ANA.TMP=NL: & ANA.TMP/PU & ANA.TMP/AP=ANA*.DIC;
;
;---- Pulling the combined file apart into its components.
	.IFNINS ANADIC	'S$MCR'INS ANADIC/TASK='S$MYTK'
	'S$MCR'REA 'S$MYTK' 5 SY:
	.OPEN FOR005.DAT
	.DATA ANA.TMP
	.CLOSE
	'S$MCR'RUN 'S$MYTK'/EST=YES
	'S$MCR'REM 'S$MYTK'
	'S$MCR'PIP FOR005.DAT;*/DE/NM
;
;---- For each record length found:
	.SETN N$LEN 0.
.LENLOP:
	.INC N$LEN
	.IF N$LEN > 40. .GOTO LENEND
	.TESTFILE ANA'N$LEN%DR2Z'.TMP
	.IF <FILERR> <> 1	.GOTO LENLOP
;
;---- Processing file ANA'N$LEN%DR2Z'.TMP
;
;---- Creating file with anagrams (this will take a bit).
	.IFNINS ANAMAK	'S$MCR'INS ANAMAK/TASK='S$MYTK'
	'S$MCR'REA 'S$MYTK' 5 SY:
	'S$MCR'REA 'S$MYTK' 6 NL:
	.OPEN FOR005.DAT
	.DATA ANA'N$LEN%DR2Z'.TMP
	.DATA ANA'N$LEN%DR2Z'.TMP
	.CLOSE
	'S$MCR'RUN 'S$MYTK'/EST=YES
	'S$MCR'REM 'S$MYTK'
	'S$MCR'PIP FOR005.DAT;*/DE/NM & ANA'N$LEN%DR2Z'.TMP/PU
;
;---- Creating an indexed file for the load.
	.SETN N$ILEN N$LEN*2+1.
	.OPEN ANA.DES
	.DATA FILE    
	.DATA   Name                     ANA'N$LEN%DR2Z'.TMP  
	.DATA   Organization             INDEXED  
	.DATA RECORD    
	.DATA   Size                     'N$ILEN%D'  
	.DATA   Format                   FIXED  
	.DATA   Carriage_Control         CARRIAGE_RETURN  
	.DATA KEY    0
	.DATA   Name                     REC  
	.DATA   Type                     STRING  
	.DATA   Null_Key                 NO  
	.DATA   Null_Value               32  
	.DATA   Duplicates               NO  
	.DATA   Changes                  NO  
	.DATA   Seg0_Position            0  
	.DATA   Seg0_Length              'N$ILEN%D'  
	.DATA   Data_Fill                100  
	.DATA   Data_Area                0  
	.DATA   Index_Fill               100  
	.DATA   Level1_Index_Area        1  
	.DATA   Index_Area               2  
	.DATA AREA    0
	.DATA   Allocation               6  
	.DATA   Extension                2  
	.DATA   Bucket_Size              2  
	.DATA   Contiguous               NO  
	.DATA   Position                 NONE  0  
	.DATA   Exact_Positioning        NO  
	.DATA AREA    1
	.DATA   Allocation               2  
	.DATA   Extension                2  
	.DATA   Bucket_Size              2  
	.DATA   Contiguous               NO  
	.DATA   Position                 NONE  0  
	.DATA   Exact_Positioning        NO  
	.DATA AREA    2
	.DATA   Allocation               0  
	.DATA   Extension                2  
	.DATA   Bucket_Size              2  
	.DATA   Contiguous               NO  
	.DATA   Position                 NONE  0  
	.DATA   Exact_Positioning        NO  
	.CLOSE
	'S$MCR'RUN $RMSDES/CMD="DES ANA.DES"
	'S$MCR'PIP ANA.DES;*/DE
;
;---- Loading the indexed file.
	'S$MCR'RUN $RMSIFL/CMD="IFL ANA'N$LEN%DR2Z'.TMP/ER:NL:/PD:#40/TR=ANA'N$LEN%DR2Z'.TMP;-1"
	'S$MCR'PIP ANA'N$LEN%DR2Z'.TMP/PU
;
;---- Unloading the now-sorted indexed file.
	'S$MCR'PIP ANA'N$LEN%DR2Z'.TMP=NL:
	'S$MCR'RUN $RMSCNV/CMD="CNV ANA'N$LEN%DR2Z'.TMP/AP=ANA'N$LEN%DR2Z'.TMP;-1"
	'S$MCR'PIP ANA'N$LEN%DR2Z'.TMP/PU
;
;---- Excising anagrams from sorted file.
;     You can ignore errors from EDT.
	.OPEN ANA.EDT
	.DATA SET TE HCPY
	.DATA SET QUIET
	.DATA C;BR 16(32767(DEW+L)) EX
	.DATA S/ //WH/NOTY
	.DATA EXIT
	.CLOSE
	'S$MCR'EDT ANA'N$LEN%DR2Z'.TMP,ANA.EDT
	'S$MCR'PIP ANA.EDT;*/DE
	'S$MCR'PIP ANA'N$LEN%DR2Z'.TMP/PU
;
;---- Converting the file to fixed-length records.
	.OPEN ANA.DES
	.DATA CLEAR ALL
	.DATA SET FILE ORGANIZATION SEQUENTIAL
	.DATA SET FILE PROTECTION (SYSTEM:RWED, OWNER:RWED, GROUP:R, WORLD:R )
	.DATA SET RECORD SIZE 'N$LEN%D'
	.DATA SET RECORD FORMAT FIXED
	.DATA SET RECORD BLOCK_SPAN YES
	.DATA SET RECORD CARRIAGE_CONTROL CARRIAGE_RETURN
	.DATA CREATE ANA'N$LEN%DR2Z'.TMP
	.DATA EXIT ANA.DES
	.CLOSE
	'S$MCR'RUN $RMSDES/CMD="DES @ANA.DES"
	'S$MCR'RUN $RMSCNV/CMD="CNV ANA'N$LEN%DR2Z'.TMP/AP/PD:40/TR=ANA'N$LEN%DR2Z'.TMP;-1"
	'S$MCR'PIP ANA'N$LEN%DR2Z'.TMP/PU & ANA.DES;*/DE
;
;---- Done with ANA'N$LEN%DR2Z'.TMP
	.GOTO LENLOP

.LENEND:
;
;---- Blowing away the old ANA*.DIC files.
	'S$MCR'PIP ANA*.DIC;*/DE
;
;---- Renaming the ANA%%.TMP files to ANA%%.DIC
	'S$MCR'PIP *.DIC;/RE=ANA%%.TMP;*
;
;---- Dictionary reconstruction complete.
	.EXIT
