.;----------------------------------------------------------------------------
.;
.; CMD-file:	R P T R E G
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	14-NOV-84
.;
.; Version:	1.5	9-Jun-87
.;
.; Purpose:	Generating Full Device Registers Error Log Report.
.;
.; Description:	Switches used:
.; 		/Format:Full
.; 		/Type:Error
.; 		/Date:(Today, Yesterday, Previous:n days, or
.; 			start- to end date)
.; 		/Device:All
.; 		/Serial:Drive:(392 and/or 655)
.; 		/Packet:*:*
.; 		/Width:Wide
.;
.; Calls to:	RPTDATE.CMD in BIOREGAN.CLB, P16L3.CMD, P16L9.CMD
.;		PIP, PRI, RPT, SRD
.;
.; Globals:	Name	Type	Description
.; 		$RANGE	String	Date range received from RPTDATE.CMD
.;		$PRSET	String	Printer setting escape-sequence filespec
.;
.; Modified by:	Jan H. Belgraver	 6-DEC-84	JB01	V1.1
.;		Left RK07 device serial number correction
.;
.;		Jan H. Belgraver	17-JAN-86	JB02	V1.2
.;		Fetch RPTDATE.CMD from BIOREGAN.CLB	
.;
.;		Jan H. Belgraver	18-Jun-86	JB03	V1.3
.;		1. Pre- and postfix RPT list file with escape-sequences for
.;		printer control.
.;		2. Selectively delete list files with SRD.
.;
.;		Jan H. Belgraver	2-Sep-86	JB04	V1.4
.;		Purge listfiles before selective delete.
.;
.;		Jan H. Belgraver	9-Jun-87	JB05	V1.5
.;		Redesign of device input section for addtion of RP06.
.;----------------------------------------------------------------------------
.;
.;

.enable	substitution
.enable	decimal
.enable	global
.enable	quiet
.disable	lowercase
.sets	RK1	"493"							! JB05
.sets	RK2	"655"							! JB05
.SETS	RK3	"022"							! JB05
.sets	RP1	"DB:"							! JB05
.sets	DEV1	"None"							! JB05
.sets	DEV2	"None"							! JB05
.sets	DEV3	"None"							! JB05
.sets	DEV4	"None"							! JB05
.setn	NP	0
.setn	NPASS	1							! JB05
.ifnins	RPT	INS $RPT/TASK=...RPT
.disable	quiet
;
; Generating Full Disk Registers Error Log Report
;
; Available Disk Drives  RK1 = Left  RK07 Drive
;                        RK2 = Right RK07 Drive
;                        RK3 = DMRD  RK07 Drive
;                        RP1 = RP06  Drive
;                        * = All Units
;
; Respond with: one or more drives, separated with , or * on next question;
;
.GETDEV:
	.enable quiet							! JB05
	.asks [1:15]	DEV Select Drive(s)
	.setf	ALL							! JB05
	.if	DEV eq "*"	.sett	ALL				! JB05
	.iff	ALL	.goto	GTD10
	.setn	NPASS	4						! JB05
	.sets	DEV1	RK1						! JB05
	.sets	DEV2	RK2						! JB05
	.sets	DEV3	RK3						! JB05
	.sets	DEV4	RP1						! JB05
	.goto	DEVEND							! JB05
.GTD10:
	.parse	DEV ","	D1 D2 D3 D4					! JB05
	.setn	DEVTOT	4						! JB05
	.setn	N	0						! JB05
	.setn	NPASS	0						! JB05
.DEVLP:									.;JB05
	.inc	N							! JB05
	.if	N gt DEVTOT	.goto	DEVEND				! JB05
	.gosub	TSTDEV							! JB05
	.if	N eq 1	.ift	EMPTY	.goto	GETDEV			! JB05
	.if	N gt 1	.ift	EMPTY	.goto	DEVEND			! JB05
	.goto	DEVLP							! JB05
.DEVEND:								.;JB03
	.disable quiet							! JB05
.;
.; Available Date Ranges: T = Today
.;                        Y = Yesterday
.;                        P = Previous n days
.;                        R = User defined start- to end date
.;
	.enable quiet							! JB05
@[5,104]BIOREGAN/LB:RPTDATE	! Get date string, returned in $RANGE	! JB02
.;	The next question section was edited as update JB005.
.GETPRT:								.;JB05
	.disable quiet							! JB05
;
; Select output devices: LA = LA120
;                        LP = Lineprinter
;
	.asks [2:2]	PRNTR Select Printer
	.if	PRNTR ne "LA"	.if PRNTR ne "LP"	.goto	GETPRT
;
;	B U S Y . . . .
;
	.gosub	REPORT		! Have RPT produce report-file		| JB05
.;
	.if	PRNTR eq "LP"	.goto	PRTLST				! JB05
	.gosub	PRINT		! Assemble print-file for LA120		| JB05
.;
	PRI TT4:/NOFL=RPTREG.LST					! JB05
.PRTLST:								.;JB05
	PRI	RPTREG.LST						! JB05
.;
	SRD	RPTREG.LST;*/SD/MI					! JB03
	.if	PRNTR eq "LP"	.goto	FINISH				! JB05
	PIP	'PREFIL';*,'PSTFIL';*/DE/NM				! JB05
.FINISH:								.;JB05
	REM	RPT
	.disable display
.exit

.;----------------------------------------------------------------------------
.; Subroutine:	PRINT
.; Purpose:	Assembles final report file
.; Author:	Jan H. Belgraver
.; Date:	9-Jun-87
.; Version:	V1.0
.; Modidfied by:.
.;----------------------------------------------------------------------------

.PRINT:
	.enable quiet							! 
	SRD	RPTREG.LST/NA/WB/NOLI
	.if	PRNTR eq "LP"	.returm					! 
.;
.;	Get printer set/reset escape-sequences in files.
.;
	@[5,104]BIOREGAN/LB:P16L3					! 
	.sets	PREFIL	$PRSET						! 
	@[5,104]BIOREGAN/LB:P16L9					! 
	.sets	PSTFIL	$PRSET						! 
.;
	PIP	RPTPRE.LST='PREFIL'/RE/NV				! 
	PIP	RPTPRE.LST=RPTREG.LST;*/AP	! Append to prefix file	| 
	PIP	RPTPRE.LST='PSTFIL'/AP		! Append postfix file	| 
	PIP	RPTREG.LST=RPTPRE.LST/RE/NV				! 
	PIP	RPTREG.LST/PU/NM					! 
	.return

.;----------------------------------------------------------------------------
.; Subroutine:	REPORT
.; Purpose:	Runs RPT to produce report file
.; Author:	Jan H. Belgraver
.; Date:	9-Jun-87
.; Version:	V1.0
.; Modidfied by:.
.;----------------------------------------------------------------------------

.REPORT:
	.enable	quiet
	.setn	N	0						! 
	.sets	FXD	"/FO:F/DA:"+$RANGE+"/TY:E"
	PIP	RPTREG.LST;*/DE/NM
	.open	RPTTMP.LST
	.data	Device Register Error Log Report generated on '<DATE>'
	.data	
	.data	Command-line (fixed part) = 'FXD'
	.data	
	.data	DEV1 = 'DEV1', DEV2 = 'DEV2', DEV3 = 'DEV3', DEV4 = 'DEV4'
	.close
	.disable quiet
	; Reporting on drive:
.RPTLP:
	.inc	N							! 
	.if	N gt NPASS	.goto	RPTEND				! 
	.sets	DRIVE	DEV'N'
	.disable quiet
	;
	; 'DRIVE'
	.enable quiet
	.if DEV'N' eq RP1	RPT RPTREG.LST='FXD'/DE:'DRIVE'
	.if DEV'N' ne RP1	RPT RPTREG.LST='FXD'/SE:D:'DRIVE'
	PIP	RPTTMP.LST/AP=RPTREG.LST
	PIP	RPTREG.LST;*/DE/NM
	.goto	RPTLP:
.RPTEND:
	PIP	RPTREG.LST/NV=RPTTMP.LST/RE
	.return

.;----------------------------------------------------------------------------
.; Subroutine:	TSTDEV
.; Purpose:	Find out which devices to report on.
.; Author:	Jan H. Belgraver
.; Date:	9-Jun-87
.; Version:	V1.0
.; Modified by:	.
.;----------------------------------------------------------------------------

.TSTDEV:								.;JB05
	.setf	EMPTY							! JB05
	.setn	NP	NPASS						! JB05
.;	
	.test	D'N'							! JB05
	.if	<STRLEN> eq 0	.sett	EMPTY				! JB05
	.ift	EMPTY	.goto	TSTEND					! JB05
.DEV1:									.;JB05
	.test	D'N' "RK1"						! JB05
	.if	<STRLEN> eq 0	.goto	DEV2				! JB05
	.inc	NP							! JB05
	.sets	DEV'N'	RK1						! JB05
	.goto	TSTEND							! JB05
.DEV2:									.;JB05
	.test	D'N' "RK2"						! JB05
	.if	<STRLEN> eq 0	.goto	DEV3				! JB05
	.inc	NP							! JB05
	.sets	DEV'N'	RK2						! JB05
	.goto	TSTEND							! JB05
.DEV3:									.;JB05
	.test	D'N' "RK3"						! JB05
	.if	<STRLEN> eq 0	.goto	DEV4				! JB05
	.inc	NP							! JB05
	.sets	DEV'N'	RK3						! JB05
	.goto	TSTEND							! JB05
.DEV4:									.;JB05
	.test	D'N' "RP1"						! JB05
	.if	<STRLEN> eq 0	.goto	DEVEND				! JB05
	.inc	NP							! JB05
	.sets	DEV'N'	RP1						! JB05
.TSTEND:								.;JB05
	.setn	NPASS	NP						! JB05
	.return								! JB05
