.;
.;----------------------------------------------------------------------------
.;
.; CMD-file:	R P T D A T E
.;
.; Purpose:	Asks for Error Log Reporting Date Range
.;
.; Author:	Jan H. Belgraver
.;
.; Date:	14-NOV-84
.;
.; Version:	1.1	16-JAN-86
.;
.; Description:	The date syntax is checked via a call to CHKDATE.CMD
.;
.; Call:	@DM:[1,1]BIOREGAN/LB:RPTDATE 
.;
.; Arguments:	None
.;
.; Globals:	Name		Description
.; 		$RANGE	Date range, i.e. dd-mmm-yy:dd-mmm-yy
.;
.; Modified by:	Jan H. Belgraver	16-JAN-86	JB01	V1.1
.;		1. Name change of datecheck cmd-file
.;		2. CHKDATE.CMD now located in DM:[1,1]BIOREGAN.CLB
.;
.;----------------------------------------------------------------------------
.;
.;
.enable	substitution
.enable	global
.disable	quiet
;
; Available Date Ranges: T = Today
;                        Y = Yesterday
;                        P = Previous n days
;                        R = User defined start- to end date
;
.GETDAT:
	.ASKS [1:1]	$RANGE Select range
	.IF	$RANGE EQ "T"	.GOTO	FINISH
	.IF	$RANGE EQ "Y"	.GOTO	FINISH
	.IF	$RANGE EQ "P"	.GOTO	1
	.IF	$RANGE EQ "R"	.GOTO	10
	.GOTO	GETDAT		! Invalid letter
.;
.1:	.ASKS [1:2:"1"]	DAYS How many days
	.SETS	$RANGE	$RANGE+":"+DAYS
	.GOTO	FINISH
.10:	.ASKS [1:16:<DATE>]	$DATE Start Date
	.IF	$DATE EQ "*"	.GOTO	15
	.enable	quiet
	@/LB:CHKDATE	'$DATE'						! JB01
	.disable	quiet
.15:	.SETS	BEGIN	$DATE
	.ASKS [1:16:<DATE>]	$DATE End   Date
	.IF	$DATE EQ "*"	.GOTO	20
	.enable	quiet
	@/LB:CHKDATE	'$DATE'						! JB01
.20:	.SETS	END	$DATE
	.SETS	$RANGE	$RANGE+":"+BEGIN+":"+END
.FINISH:
	.exit
