.;
.;----------------------------------------------------------------------------
.;
.; CMD-program:	P R I N T 
.;
.; Purpose:	Selectively prints files via Queue Manager.
.;
.; Author:	Jan H. Belgraver
.;		Modified from COPY.CMD received from Han Lasance in 1980.
.;
.; Date:	24-Jun-85
.;
.; Version:	V1.4	21-OCT-85
.;
.; Calls to:	STATUS
.;
.; Modified by:	Jan H. Belgraver	26-JUN-85	JB01	V1.1
.;		Wait until despooler finished before renaming.
.;
.;		Jan H. Belgraver	 5-AUG-85	JB02	V1.2
.;		Add forgotten Quit option.
.;
.;		Jan H. Belgraver	10-AUG-85	JB03	V1.3
.;		Call Bell when printing terminates.
.;
.;		Jan H. Belgraver	21-OCT-85	JB04	V1.4
.;		Preset KEEP flag.
.;----------------------------------------------------------------------------
.;
.enable substitution
.enable	quiet					
.disable lowercase
	.SETF	DCL				
	.IF	<CLI> EQ "DCL"	.SETT	DCL	
.;	If current CLI is DCL reset to MCR	
	.IFT	DCL	SET TERMINAL/MCR
.;
.sets	STRING ""
.setf	FLAG
.setf	GO
.setf	KEEP								.;JB04
.;
.;	ASK FOR COMMAND PARAMETERS IF NOT PRESENT
.;
.START:	.if	P2 EQ ""	.asks P1 FROM	
	.if	P2 EQ ""	.asks P2 TO	
	.if	P2 NE "LP0:"	.if   P2 NE "TT4:"	.goto	START
.;
.;	FIND OUT WHAT TO COPY
.;
	.asks	FTYPE	Filetype	
	.if	<STRLEN> EQ 0	.goto	FINISH
	.ift	<EOF>		.goto	FINISH
	.if FTYPE EQ "LST"	.ask [<FALSE>] KEEP	Keep list files	
	SRD	'P1'/NA/WB/NOLI		
	SRD	'P1'DIRECTORY.TMP;1234='P1'*.'FTYPE'/LI
.;
	.OPENR	'P1'DIRECTORY.TMP;1234
.LOOP:
	.sets	PREVIO	STRING
	.read	RECORD
	.ift	<EOF>		.goto	EXIT
	.if	<FILERR> NE 1	.goto	ERROR
	.test	RECORD
	.if	<STRLEN> LE 2	.goto	LOOP
	.sets	STRING	RECORD
	.parse	STRING	".;"	NAME TYPE VERS
	.if	TYPE EQ ""	.goto	LOOP
.;
.;	WATCH OUT FOR THE FILE ITSELF
.;
	.if	NAME NE "DIRECTORY"	.goto	MORE
	.if	TYPE NE "TMP"		.goto	MORE
	.if	VERS NE "1234"		.goto	MORE
	.goto	LOOP
.MORE:
	.ift	GO	.goto	PRINT
	.asks [1:1]	FIRST	Print 'P1''STRING' [Y,N,Q,G,^]	
	.if	FIRST EQ ""	.goto	LOOP
	.if	FIRST EQ "Y"	.goto	PRINT
	.if	FIRST EQ "N"	.goto	LOOP
	.if	FIRST EQ "Q"	.goto	EXIT				.;JB02
	.if	FIRST EQ "G"	.SETT	GO
	.if	FIRST EQ "^"	.SETT	FLAG
	.ift	GO		.goto	PRINT
	.iff	FLAG		.goto	MORE
	.sets	CURREN	STRING
	.sets	STRING	PREVIO
.PRINT:
	.disable quiet
	.parse	STRING	".;"	NAME TYPE VERS
	PRI	'P2'='P1''STRING'
	.enable quiet
	.iff	KEEP	.goto	CONTIN
	.gosub	STATUS
.WAIT:	.iff	ATACHD	.goto	RENAME
	.delay	5S
	.gosub	STATUS
	.goto	WAIT
.RENAME:
	.disable quiet
	PIP	'P1''NAME'.LIS='P1''STRING'/RE
	.enable quiet
.CONTIN:
	BEL	0							! JB03
	.iff	FLAG	.goto	LOOP
	.sets	STRING	CURREN
	.goto	MORE
.ERROR:
	.disable	quiet
	;..... ERROR '<FILERR>' IN '<FILSPC>'
.EXIT:
	.enable	quiet							
	PIP	DIRECTORY.TMP;1234/DE
.FINISH:
	.enable	quiet							
	.;	If user CLI was DCL reset terminal.			
	.IFT	DCL	SET /DCL=TI:
	.disable display						
.EXIT
.;
.;----------------------------------------------------------------------------
.;
.; Subroutine:	S T A T U S
.; Author:	Jan H. Belgraver
.; Date:	26-JUN-85
.; Version:	1.0
.; Purpose:	Testing of printer status to find out if despooler task is 
.;		busy or not.
.; Description:	<EXSTRI> is filled following an .TESTDEVICE directive.
.;		It contains the four device-characteristics words:
.;		U.CW1, U.CW2, U.CW3, resp. U.CW4 and one or more 
.;		device atttributes.
.;		If despooler task is busy status is ATT (attached), otherwise
.;		one of the device attributes contains NAT (not attached).
.; Modified by:	
.;
.;----------------------------------------------------------------------------
.;
.STATUS:
	.enable	substitution
	.testdevice	'P2'
	.sets	TMP	<EXSTRI>
	.parse	TMP	"," DEV CW1 CW2 CW3 CW4 DEVATR
	.PARSE	DEVATR	"," D1 D2 D3 D4 D5 D6 D7 D8 D9 D10 D11 D12 D13 D14 D15
.;
	.setn	N	0
	.setf	ATACHD
.SLOOP:
	.inc	N
	.if	N GT 15		.goto	RETURN
	.if D'N' NE "ATT"	.goto	SLOOP
	.sett	ATACHD
.RETURN:
	.return
